# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeLoadBalancerVirtualServiceCommonProperties(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'NetworkingObjectStatusType',
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'enabled': 'bool',
        'virtual_ip_address': 'str',
        'load_balancer_pool_ref': 'EntityReference',
        'gateway_ref': 'EntityReference',
        'service_engine_group_ref': 'EntityReference',
        'certificate_ref': 'EntityReference',
        'service_ports': 'list[EdgeLoadBalancerServicePort]',
        'health_status': 'str',
        'health_message': 'str',
        'detailed_health_message': 'str'
    }

    attribute_map = {
        'status': 'status',
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'enabled': 'enabled',
        'virtual_ip_address': 'virtualIpAddress',
        'load_balancer_pool_ref': 'loadBalancerPoolRef',
        'gateway_ref': 'gatewayRef',
        'service_engine_group_ref': 'serviceEngineGroupRef',
        'certificate_ref': 'certificateRef',
        'service_ports': 'servicePorts',
        'health_status': 'healthStatus',
        'health_message': 'healthMessage',
        'detailed_health_message': 'detailedHealthMessage'
    }

    def __init__(self, status=None, id=None, name=None, description=None, enabled=None, virtual_ip_address=None, load_balancer_pool_ref=None, gateway_ref=None, service_engine_group_ref=None, certificate_ref=None, service_ports=None, health_status=None, health_message=None, detailed_health_message=None):
        """
        EdgeLoadBalancerVirtualServiceCommonProperties - a model defined in Swagger
        """

        self._status = None
        self._id = None
        self._name = None
        self._description = None
        self._enabled = None
        self._virtual_ip_address = None
        self._load_balancer_pool_ref = None
        self._gateway_ref = None
        self._service_engine_group_ref = None
        self._certificate_ref = None
        self._service_ports = None
        self._health_status = None
        self._health_message = None
        self._detailed_health_message = None

        if status is not None:
          self.status = status
        if id is not None:
          self.id = id
        self.name = name
        if description is not None:
          self.description = description
        self.enabled = enabled
        self.virtual_ip_address = virtual_ip_address
        self.load_balancer_pool_ref = load_balancer_pool_ref
        self.gateway_ref = gateway_ref
        self.service_engine_group_ref = service_engine_group_ref
        if certificate_ref is not None:
          self.certificate_ref = certificate_ref
        self.service_ports = service_ports
        if health_status is not None:
          self.health_status = health_status
        if health_message is not None:
          self.health_message = health_message
        if detailed_health_message is not None:
          self.detailed_health_message = detailed_health_message

    @property
    def status(self):
        """
        Gets the status of this EdgeLoadBalancerVirtualServiceCommonProperties.
        Represents current status of the networking object. 

        :return: The status of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: NetworkingObjectStatusType
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this EdgeLoadBalancerVirtualServiceCommonProperties.
        Represents current status of the networking object. 

        :param status: The status of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: NetworkingObjectStatusType
        """

        self._status = status

    @property
    def id(self):
        """
        Gets the id of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The identifier of the Virtual Service in URN format

        :return: The id of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The identifier of the Virtual Service in URN format

        :param id: The id of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The name of the Virtual Service. Name is unique across all Virtual Services for an Edge Gateway.

        :return: The name of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The name of the Virtual Service. Name is unique across all Virtual Services for an Edge Gateway.

        :param name: The name of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The description of the Virtual Service.

        :return: The description of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The description of the Virtual Service.

        :param description: The description of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: str
        """

        self._description = description

    @property
    def enabled(self):
        """
        Gets the enabled of this EdgeLoadBalancerVirtualServiceCommonProperties.
        A flag indicating whether Virtual Service is enabled or not.

        :return: The enabled of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this EdgeLoadBalancerVirtualServiceCommonProperties.
        A flag indicating whether Virtual Service is enabled or not.

        :param enabled: The enabled of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: bool
        """
        if enabled is None:
            raise ValueError("Invalid value for `enabled`, must not be `None`")

        self._enabled = enabled

    @property
    def virtual_ip_address(self):
        """
        Gets the virtual_ip_address of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The virtual IP Address (VIP) of the Virtual Service. This IP can be an allocated IP to the Gateway from the External Network or it can be an arbitrary internal IP address used for internal load balancing. It it's an internal IP Address, this IP cannot be part of any existing subnet attached to the Edge Gateway or any vDC Group network if the Edge Gateway is scoped accordingly. 

        :return: The virtual_ip_address of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: str
        """
        return self._virtual_ip_address

    @virtual_ip_address.setter
    def virtual_ip_address(self, virtual_ip_address):
        """
        Sets the virtual_ip_address of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The virtual IP Address (VIP) of the Virtual Service. This IP can be an allocated IP to the Gateway from the External Network or it can be an arbitrary internal IP address used for internal load balancing. It it's an internal IP Address, this IP cannot be part of any existing subnet attached to the Edge Gateway or any vDC Group network if the Edge Gateway is scoped accordingly. 

        :param virtual_ip_address: The virtual_ip_address of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: str
        """
        if virtual_ip_address is None:
            raise ValueError("Invalid value for `virtual_ip_address`, must not be `None`")

        self._virtual_ip_address = virtual_ip_address

    @property
    def load_balancer_pool_ref(self):
        """
        Gets the load_balancer_pool_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The Load Balancer Pool associated with this Virtual Service.

        :return: The load_balancer_pool_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: EntityReference
        """
        return self._load_balancer_pool_ref

    @load_balancer_pool_ref.setter
    def load_balancer_pool_ref(self, load_balancer_pool_ref):
        """
        Sets the load_balancer_pool_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The Load Balancer Pool associated with this Virtual Service.

        :param load_balancer_pool_ref: The load_balancer_pool_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: EntityReference
        """
        if load_balancer_pool_ref is None:
            raise ValueError("Invalid value for `load_balancer_pool_ref`, must not be `None`")

        self._load_balancer_pool_ref = load_balancer_pool_ref

    @property
    def gateway_ref(self):
        """
        Gets the gateway_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The Edge Gateway associated with this Virtual Service.

        :return: The gateway_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: EntityReference
        """
        return self._gateway_ref

    @gateway_ref.setter
    def gateway_ref(self, gateway_ref):
        """
        Sets the gateway_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The Edge Gateway associated with this Virtual Service.

        :param gateway_ref: The gateway_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: EntityReference
        """
        if gateway_ref is None:
            raise ValueError("Invalid value for `gateway_ref`, must not be `None`")

        self._gateway_ref = gateway_ref

    @property
    def service_engine_group_ref(self):
        """
        Gets the service_engine_group_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The Load Balancer Service Engine Group that is assigned to the Edge Gateway. This Virtual Service will be deployed to this Service Engine Group. 

        :return: The service_engine_group_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: EntityReference
        """
        return self._service_engine_group_ref

    @service_engine_group_ref.setter
    def service_engine_group_ref(self, service_engine_group_ref):
        """
        Sets the service_engine_group_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The Load Balancer Service Engine Group that is assigned to the Edge Gateway. This Virtual Service will be deployed to this Service Engine Group. 

        :param service_engine_group_ref: The service_engine_group_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: EntityReference
        """
        if service_engine_group_ref is None:
            raise ValueError("Invalid value for `service_engine_group_ref`, must not be `None`")

        self._service_engine_group_ref = service_engine_group_ref

    @property
    def certificate_ref(self):
        """
        Gets the certificate_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The certificate used for SSL termination for the Virtual Service. This is required if the service port type is \"HTTPS\" or \"L4_TLS\".

        :return: The certificate_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: EntityReference
        """
        return self._certificate_ref

    @certificate_ref.setter
    def certificate_ref(self, certificate_ref):
        """
        Sets the certificate_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The certificate used for SSL termination for the Virtual Service. This is required if the service port type is \"HTTPS\" or \"L4_TLS\".

        :param certificate_ref: The certificate_ref of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: EntityReference
        """

        self._certificate_ref = certificate_ref

    @property
    def service_ports(self):
        """
        Gets the service_ports of this EdgeLoadBalancerVirtualServiceCommonProperties.
        A list of service ports supported by this Virtual Service.  Multiple service ports are allowed only with additional licensing. 

        :return: The service_ports of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: list[EdgeLoadBalancerServicePort]
        """
        return self._service_ports

    @service_ports.setter
    def service_ports(self, service_ports):
        """
        Sets the service_ports of this EdgeLoadBalancerVirtualServiceCommonProperties.
        A list of service ports supported by this Virtual Service.  Multiple service ports are allowed only with additional licensing. 

        :param service_ports: The service_ports of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: list[EdgeLoadBalancerServicePort]
        """
        if service_ports is None:
            raise ValueError("Invalid value for `service_ports`, must not be `None`")

        self._service_ports = service_ports

    @property
    def health_status(self):
        """
        Gets the health_status of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The current health status of the virtual service. Possible values are: <ul> <li> UP - The virtual service is healthy. <li> DOWN - The virtual service is down, inactive, or has failed. <li> DISABLED - The virtual service is disabled. <li> UNAVAILABLE - The virtual service is unavailable. <li> PENDING - The virtual service is being creating or resources are being allocated. <li> UNKNOWN - The virtual service state is unknown. </ul> 

        :return: The health_status of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: str
        """
        return self._health_status

    @health_status.setter
    def health_status(self, health_status):
        """
        Sets the health_status of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The current health status of the virtual service. Possible values are: <ul> <li> UP - The virtual service is healthy. <li> DOWN - The virtual service is down, inactive, or has failed. <li> DISABLED - The virtual service is disabled. <li> UNAVAILABLE - The virtual service is unavailable. <li> PENDING - The virtual service is being creating or resources are being allocated. <li> UNKNOWN - The virtual service state is unknown. </ul> 

        :param health_status: The health_status of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: str
        """

        self._health_status = health_status

    @property
    def health_message(self):
        """
        Gets the health_message of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The localized message on the health of the virtual service.

        :return: The health_message of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: str
        """
        return self._health_message

    @health_message.setter
    def health_message(self, health_message):
        """
        Sets the health_message of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The localized message on the health of the virtual service.

        :param health_message: The health_message of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: str
        """

        self._health_message = health_message

    @property
    def detailed_health_message(self):
        """
        Gets the detailed_health_message of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The non-localized detailed message on the health of the virtual service.

        :return: The detailed_health_message of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :rtype: str
        """
        return self._detailed_health_message

    @detailed_health_message.setter
    def detailed_health_message(self, detailed_health_message):
        """
        Sets the detailed_health_message of this EdgeLoadBalancerVirtualServiceCommonProperties.
        The non-localized detailed message on the health of the virtual service.

        :param detailed_health_message: The detailed_health_message of this EdgeLoadBalancerVirtualServiceCommonProperties.
        :type: str
        """

        self._detailed_health_message = detailed_health_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeLoadBalancerVirtualServiceCommonProperties):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
