# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeLoadBalancerServicePort(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'tcp_udp_profile': 'EdgeLoadBalancerTcpUdpProfile',
        'port_start': 'int',
        'port_end': 'int',
        'ssl_enabled': 'bool'
    }

    attribute_map = {
        'tcp_udp_profile': 'tcpUdpProfile',
        'port_start': 'portStart',
        'port_end': 'portEnd',
        'ssl_enabled': 'sslEnabled'
    }

    def __init__(self, tcp_udp_profile=None, port_start=None, port_end=None, ssl_enabled=False):
        """
        EdgeLoadBalancerServicePort - a model defined in Swagger
        """

        self._tcp_udp_profile = None
        self._port_start = None
        self._port_end = None
        self._ssl_enabled = None

        if tcp_udp_profile is not None:
          self.tcp_udp_profile = tcp_udp_profile
        self.port_start = port_start
        if port_end is not None:
          self.port_end = port_end
        if ssl_enabled is not None:
          self.ssl_enabled = ssl_enabled

    @property
    def tcp_udp_profile(self):
        """
        Gets the tcp_udp_profile of this EdgeLoadBalancerServicePort.
        Specifies the TCP/UDP profile for the service ports such as TCP_PROXY or TCP_FAST_PATH. If unset, a profile using the system-defined type of TCP_PROXY is used. This is valid for all Application Profiles. For L4 application profile type, user can set the profile to a different type such as TCP_FAST_PATH. For any other application profile type, the TCP/UDP profile type must be TCP_PROXY. 

        :return: The tcp_udp_profile of this EdgeLoadBalancerServicePort.
        :rtype: EdgeLoadBalancerTcpUdpProfile
        """
        return self._tcp_udp_profile

    @tcp_udp_profile.setter
    def tcp_udp_profile(self, tcp_udp_profile):
        """
        Sets the tcp_udp_profile of this EdgeLoadBalancerServicePort.
        Specifies the TCP/UDP profile for the service ports such as TCP_PROXY or TCP_FAST_PATH. If unset, a profile using the system-defined type of TCP_PROXY is used. This is valid for all Application Profiles. For L4 application profile type, user can set the profile to a different type such as TCP_FAST_PATH. For any other application profile type, the TCP/UDP profile type must be TCP_PROXY. 

        :param tcp_udp_profile: The tcp_udp_profile of this EdgeLoadBalancerServicePort.
        :type: EdgeLoadBalancerTcpUdpProfile
        """

        self._tcp_udp_profile = tcp_udp_profile

    @property
    def port_start(self):
        """
        Gets the port_start of this EdgeLoadBalancerServicePort.
        The starting port number in the port range of the Virtual Service. If a single port is desired, only this field needs to be specified. An example is that HTTP uses port 80. 

        :return: The port_start of this EdgeLoadBalancerServicePort.
        :rtype: int
        """
        return self._port_start

    @port_start.setter
    def port_start(self, port_start):
        """
        Sets the port_start of this EdgeLoadBalancerServicePort.
        The starting port number in the port range of the Virtual Service. If a single port is desired, only this field needs to be specified. An example is that HTTP uses port 80. 

        :param port_start: The port_start of this EdgeLoadBalancerServicePort.
        :type: int
        """
        if port_start is None:
            raise ValueError("Invalid value for `port_start`, must not be `None`")
        if port_start is not None and port_start > 65535:
            raise ValueError("Invalid value for `port_start`, must be a value less than or equal to `65535`")
        if port_start is not None and port_start < 0:
            raise ValueError("Invalid value for `port_start`, must be a value greater than or equal to `0`")

        self._port_start = port_start

    @property
    def port_end(self):
        """
        Gets the port_end of this EdgeLoadBalancerServicePort.
        The ending port number in the port range of the Virtual Service.  This is not required if a single port is desired.

        :return: The port_end of this EdgeLoadBalancerServicePort.
        :rtype: int
        """
        return self._port_end

    @port_end.setter
    def port_end(self, port_end):
        """
        Sets the port_end of this EdgeLoadBalancerServicePort.
        The ending port number in the port range of the Virtual Service.  This is not required if a single port is desired.

        :param port_end: The port_end of this EdgeLoadBalancerServicePort.
        :type: int
        """
        if port_end is not None and port_end > 65535:
            raise ValueError("Invalid value for `port_end`, must be a value less than or equal to `65535`")
        if port_end is not None and port_end < 1:
            raise ValueError("Invalid value for `port_end`, must be a value greater than or equal to `1`")

        self._port_end = port_end

    @property
    def ssl_enabled(self):
        """
        Gets the ssl_enabled of this EdgeLoadBalancerServicePort.
        A flag indicating whether SSL termination is enabled at the port or not. This can only be enabled if HTTPS and L4_TLS Application Profile types are used. At least one service port must have ssl enabled when using HTTPS or L4_TLS Application Profile types. For HTTPS, if SSL is disabled for a specific port, traffic from that port will be redirected to the first SSL port specified. This allows for automatic HTTP to HTTPS redirects. Disabling SSL for HTTPS and L4_TLS is allowed only with additional licensing. 

        :return: The ssl_enabled of this EdgeLoadBalancerServicePort.
        :rtype: bool
        """
        return self._ssl_enabled

    @ssl_enabled.setter
    def ssl_enabled(self, ssl_enabled):
        """
        Sets the ssl_enabled of this EdgeLoadBalancerServicePort.
        A flag indicating whether SSL termination is enabled at the port or not. This can only be enabled if HTTPS and L4_TLS Application Profile types are used. At least one service port must have ssl enabled when using HTTPS or L4_TLS Application Profile types. For HTTPS, if SSL is disabled for a specific port, traffic from that port will be redirected to the first SSL port specified. This allows for automatic HTTP to HTTPS redirects. Disabling SSL for HTTPS and L4_TLS is allowed only with additional licensing. 

        :param ssl_enabled: The ssl_enabled of this EdgeLoadBalancerServicePort.
        :type: bool
        """

        self._ssl_enabled = ssl_enabled

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeLoadBalancerServicePort):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
