# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeLoadBalancerPoolSummary(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'NetworkingObjectStatusType',
        'id': 'str',
        'description': 'str',
        'enabled': 'bool',
        'passive_monitoring_enabled': 'bool',
        'health_status': 'str',
        'member_count': 'int',
        'enabled_member_count': 'int',
        'up_member_count': 'int',
        'health_message': 'str',
        'name': 'str',
        'active_monitoring_enabled': 'bool',
        'virtual_service_refs': 'list[EntityReference]',
        'member_ssl_enabled': 'bool'
    }

    attribute_map = {
        'status': 'status',
        'id': 'id',
        'description': 'description',
        'enabled': 'enabled',
        'passive_monitoring_enabled': 'passiveMonitoringEnabled',
        'health_status': 'healthStatus',
        'member_count': 'memberCount',
        'enabled_member_count': 'enabledMemberCount',
        'up_member_count': 'upMemberCount',
        'health_message': 'healthMessage',
        'name': 'name',
        'active_monitoring_enabled': 'activeMonitoringEnabled',
        'virtual_service_refs': 'virtualServiceRefs',
        'member_ssl_enabled': 'memberSslEnabled'
    }

    def __init__(self, status=None, id=None, description=None, enabled=True, passive_monitoring_enabled=True, health_status=None, member_count=None, enabled_member_count=None, up_member_count=None, health_message=None, name=None, active_monitoring_enabled=False, virtual_service_refs=None, member_ssl_enabled=None):
        """
        EdgeLoadBalancerPoolSummary - a model defined in Swagger
        """

        self._status = None
        self._id = None
        self._description = None
        self._enabled = None
        self._passive_monitoring_enabled = None
        self._health_status = None
        self._member_count = None
        self._enabled_member_count = None
        self._up_member_count = None
        self._health_message = None
        self._name = None
        self._active_monitoring_enabled = None
        self._virtual_service_refs = None
        self._member_ssl_enabled = None

        if status is not None:
          self.status = status
        if id is not None:
          self.id = id
        if description is not None:
          self.description = description
        if enabled is not None:
          self.enabled = enabled
        if passive_monitoring_enabled is not None:
          self.passive_monitoring_enabled = passive_monitoring_enabled
        if health_status is not None:
          self.health_status = health_status
        if member_count is not None:
          self.member_count = member_count
        if enabled_member_count is not None:
          self.enabled_member_count = enabled_member_count
        if up_member_count is not None:
          self.up_member_count = up_member_count
        if health_message is not None:
          self.health_message = health_message
        if name is not None:
          self.name = name
        if active_monitoring_enabled is not None:
          self.active_monitoring_enabled = active_monitoring_enabled
        if virtual_service_refs is not None:
          self.virtual_service_refs = virtual_service_refs
        if member_ssl_enabled is not None:
          self.member_ssl_enabled = member_ssl_enabled

    @property
    def status(self):
        """
        Gets the status of this EdgeLoadBalancerPoolSummary.
        Represents current status of the networking object. 

        :return: The status of this EdgeLoadBalancerPoolSummary.
        :rtype: NetworkingObjectStatusType
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this EdgeLoadBalancerPoolSummary.
        Represents current status of the networking object. 

        :param status: The status of this EdgeLoadBalancerPoolSummary.
        :type: NetworkingObjectStatusType
        """

        self._status = status

    @property
    def id(self):
        """
        Gets the id of this EdgeLoadBalancerPoolSummary.
        The unique ID of this Load Balancer Pool. On updates, the ID is required for the pool, while for create a new ID will be generated.

        :return: The id of this EdgeLoadBalancerPoolSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeLoadBalancerPoolSummary.
        The unique ID of this Load Balancer Pool. On updates, the ID is required for the pool, while for create a new ID will be generated.

        :param id: The id of this EdgeLoadBalancerPoolSummary.
        :type: str
        """

        self._id = id

    @property
    def description(self):
        """
        Gets the description of this EdgeLoadBalancerPoolSummary.
        The description of the Load Balancer Pool.

        :return: The description of this EdgeLoadBalancerPoolSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EdgeLoadBalancerPoolSummary.
        The description of the Load Balancer Pool.

        :param description: The description of this EdgeLoadBalancerPoolSummary.
        :type: str
        """

        self._description = description

    @property
    def enabled(self):
        """
        Gets the enabled of this EdgeLoadBalancerPoolSummary.
        True if Load Balancer Pool is enabled.

        :return: The enabled of this EdgeLoadBalancerPoolSummary.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this EdgeLoadBalancerPoolSummary.
        True if Load Balancer Pool is enabled.

        :param enabled: The enabled of this EdgeLoadBalancerPoolSummary.
        :type: bool
        """

        self._enabled = enabled

    @property
    def passive_monitoring_enabled(self):
        """
        Gets the passive_monitoring_enabled of this EdgeLoadBalancerPoolSummary.
        Whether passive monitoring for this pool is enabled or not.

        :return: The passive_monitoring_enabled of this EdgeLoadBalancerPoolSummary.
        :rtype: bool
        """
        return self._passive_monitoring_enabled

    @passive_monitoring_enabled.setter
    def passive_monitoring_enabled(self, passive_monitoring_enabled):
        """
        Sets the passive_monitoring_enabled of this EdgeLoadBalancerPoolSummary.
        Whether passive monitoring for this pool is enabled or not.

        :param passive_monitoring_enabled: The passive_monitoring_enabled of this EdgeLoadBalancerPoolSummary.
        :type: bool
        """

        self._passive_monitoring_enabled = passive_monitoring_enabled

    @property
    def health_status(self):
        """
        Gets the health_status of this EdgeLoadBalancerPoolSummary.
        The current health status of the pool. Possible values are: <ul> <li> UP - The pool is operational. <li> RUNNING - The pool is operational, but less than 50% of the pool members are up. <li> DOWN - All members in the pool are down. <li> DISABLED - Either the pool is disabled or all of the members are disabled. <li> UNAVAILABLE - The pool is unavailable. Examples: pool has no members or pool is not assigned to any virtual service. <li> UNKNOWN - The pool state is unknown. </ul> 

        :return: The health_status of this EdgeLoadBalancerPoolSummary.
        :rtype: str
        """
        return self._health_status

    @health_status.setter
    def health_status(self, health_status):
        """
        Sets the health_status of this EdgeLoadBalancerPoolSummary.
        The current health status of the pool. Possible values are: <ul> <li> UP - The pool is operational. <li> RUNNING - The pool is operational, but less than 50% of the pool members are up. <li> DOWN - All members in the pool are down. <li> DISABLED - Either the pool is disabled or all of the members are disabled. <li> UNAVAILABLE - The pool is unavailable. Examples: pool has no members or pool is not assigned to any virtual service. <li> UNKNOWN - The pool state is unknown. </ul> 

        :param health_status: The health_status of this EdgeLoadBalancerPoolSummary.
        :type: str
        """

        self._health_status = health_status

    @property
    def member_count(self):
        """
        Gets the member_count of this EdgeLoadBalancerPoolSummary.
        The total number of members in the pool.

        :return: The member_count of this EdgeLoadBalancerPoolSummary.
        :rtype: int
        """
        return self._member_count

    @member_count.setter
    def member_count(self, member_count):
        """
        Sets the member_count of this EdgeLoadBalancerPoolSummary.
        The total number of members in the pool.

        :param member_count: The member_count of this EdgeLoadBalancerPoolSummary.
        :type: int
        """

        self._member_count = member_count

    @property
    def enabled_member_count(self):
        """
        Gets the enabled_member_count of this EdgeLoadBalancerPoolSummary.
        The number of enabled members in the pool.

        :return: The enabled_member_count of this EdgeLoadBalancerPoolSummary.
        :rtype: int
        """
        return self._enabled_member_count

    @enabled_member_count.setter
    def enabled_member_count(self, enabled_member_count):
        """
        Sets the enabled_member_count of this EdgeLoadBalancerPoolSummary.
        The number of enabled members in the pool.

        :param enabled_member_count: The enabled_member_count of this EdgeLoadBalancerPoolSummary.
        :type: int
        """

        self._enabled_member_count = enabled_member_count

    @property
    def up_member_count(self):
        """
        Gets the up_member_count of this EdgeLoadBalancerPoolSummary.
        The number of enabled members in the pool that are operational.

        :return: The up_member_count of this EdgeLoadBalancerPoolSummary.
        :rtype: int
        """
        return self._up_member_count

    @up_member_count.setter
    def up_member_count(self, up_member_count):
        """
        Sets the up_member_count of this EdgeLoadBalancerPoolSummary.
        The number of enabled members in the pool that are operational.

        :param up_member_count: The up_member_count of this EdgeLoadBalancerPoolSummary.
        :type: int
        """

        self._up_member_count = up_member_count

    @property
    def health_message(self):
        """
        Gets the health_message of this EdgeLoadBalancerPoolSummary.
        The localized message on the health of the pool.

        :return: The health_message of this EdgeLoadBalancerPoolSummary.
        :rtype: str
        """
        return self._health_message

    @health_message.setter
    def health_message(self, health_message):
        """
        Sets the health_message of this EdgeLoadBalancerPoolSummary.
        The localized message on the health of the pool.

        :param health_message: The health_message of this EdgeLoadBalancerPoolSummary.
        :type: str
        """

        self._health_message = health_message

    @property
    def name(self):
        """
        Gets the name of this EdgeLoadBalancerPoolSummary.
        Name for the Load Balancer Pool. Name is unique across all pools for an Edge Gateway.

        :return: The name of this EdgeLoadBalancerPoolSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EdgeLoadBalancerPoolSummary.
        Name for the Load Balancer Pool. Name is unique across all pools for an Edge Gateway.

        :param name: The name of this EdgeLoadBalancerPoolSummary.
        :type: str
        """

        self._name = name

    @property
    def active_monitoring_enabled(self):
        """
        Gets the active_monitoring_enabled of this EdgeLoadBalancerPoolSummary.
        Whether active monitoring for this pool is enabled or not.

        :return: The active_monitoring_enabled of this EdgeLoadBalancerPoolSummary.
        :rtype: bool
        """
        return self._active_monitoring_enabled

    @active_monitoring_enabled.setter
    def active_monitoring_enabled(self, active_monitoring_enabled):
        """
        Sets the active_monitoring_enabled of this EdgeLoadBalancerPoolSummary.
        Whether active monitoring for this pool is enabled or not.

        :param active_monitoring_enabled: The active_monitoring_enabled of this EdgeLoadBalancerPoolSummary.
        :type: bool
        """

        self._active_monitoring_enabled = active_monitoring_enabled

    @property
    def virtual_service_refs(self):
        """
        Gets the virtual_service_refs of this EdgeLoadBalancerPoolSummary.
        The list of Load Balancer Virtual Services associated with this Load balancer Pool. Only first 10 Virtual Services will be returned. 

        :return: The virtual_service_refs of this EdgeLoadBalancerPoolSummary.
        :rtype: list[EntityReference]
        """
        return self._virtual_service_refs

    @virtual_service_refs.setter
    def virtual_service_refs(self, virtual_service_refs):
        """
        Sets the virtual_service_refs of this EdgeLoadBalancerPoolSummary.
        The list of Load Balancer Virtual Services associated with this Load balancer Pool. Only first 10 Virtual Services will be returned. 

        :param virtual_service_refs: The virtual_service_refs of this EdgeLoadBalancerPoolSummary.
        :type: list[EntityReference]
        """

        self._virtual_service_refs = virtual_service_refs

    @property
    def member_ssl_enabled(self):
        """
        Gets the member_ssl_enabled of this EdgeLoadBalancerPoolSummary.
        Whether SSL is enabled for communicatation between the Load Balancer Virtual Services and the pool members 

        :return: The member_ssl_enabled of this EdgeLoadBalancerPoolSummary.
        :rtype: bool
        """
        return self._member_ssl_enabled

    @member_ssl_enabled.setter
    def member_ssl_enabled(self, member_ssl_enabled):
        """
        Sets the member_ssl_enabled of this EdgeLoadBalancerPoolSummary.
        Whether SSL is enabled for communicatation between the Load Balancer Virtual Services and the pool members 

        :param member_ssl_enabled: The member_ssl_enabled of this EdgeLoadBalancerPoolSummary.
        :type: bool
        """

        self._member_ssl_enabled = member_ssl_enabled

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeLoadBalancerPoolSummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
