# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeLoadBalancerPoolMember(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ip_address': 'str',
        'port': 'int',
        'ratio': 'int',
        'enabled': 'bool',
        'health_status': 'str',
        'marked_down_by': 'list[str]',
        'detailed_health_message': 'str'
    }

    attribute_map = {
        'ip_address': 'ipAddress',
        'port': 'port',
        'ratio': 'ratio',
        'enabled': 'enabled',
        'health_status': 'healthStatus',
        'marked_down_by': 'markedDownBy',
        'detailed_health_message': 'detailedHealthMessage'
    }

    def __init__(self, ip_address=None, port=None, ratio=1, enabled=True, health_status=None, marked_down_by=None, detailed_health_message=None):
        """
        EdgeLoadBalancerPoolMember - a model defined in Swagger
        """

        self._ip_address = None
        self._port = None
        self._ratio = None
        self._enabled = None
        self._health_status = None
        self._marked_down_by = None
        self._detailed_health_message = None

        self.ip_address = ip_address
        if port is not None:
          self.port = port
        if ratio is not None:
          self.ratio = ratio
        if enabled is not None:
          self.enabled = enabled
        if health_status is not None:
          self.health_status = health_status
        if marked_down_by is not None:
          self.marked_down_by = marked_down_by
        if detailed_health_message is not None:
          self.detailed_health_message = detailed_health_message

    @property
    def ip_address(self):
        """
        Gets the ip_address of this EdgeLoadBalancerPoolMember.
        The ip address of the Load Balancer Pool member.

        :return: The ip_address of this EdgeLoadBalancerPoolMember.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this EdgeLoadBalancerPoolMember.
        The ip address of the Load Balancer Pool member.

        :param ip_address: The ip_address of this EdgeLoadBalancerPoolMember.
        :type: str
        """
        if ip_address is None:
            raise ValueError("Invalid value for `ip_address`, must not be `None`")

        self._ip_address = ip_address

    @property
    def port(self):
        """
        Gets the port of this EdgeLoadBalancerPoolMember.
        The port number of the Load Balancer Pool member. If unset, the port that the client used to connect will be used.

        :return: The port of this EdgeLoadBalancerPoolMember.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this EdgeLoadBalancerPoolMember.
        The port number of the Load Balancer Pool member. If unset, the port that the client used to connect will be used.

        :param port: The port of this EdgeLoadBalancerPoolMember.
        :type: int
        """
        if port is not None and port > 65535:
            raise ValueError("Invalid value for `port`, must be a value less than or equal to `65535`")
        if port is not None and port < 1:
            raise ValueError("Invalid value for `port`, must be a value greater than or equal to `1`")

        self._port = port

    @property
    def ratio(self):
        """
        Gets the ratio of this EdgeLoadBalancerPoolMember.
        The ratio of selecting eligible servers in the pool.

        :return: The ratio of this EdgeLoadBalancerPoolMember.
        :rtype: int
        """
        return self._ratio

    @ratio.setter
    def ratio(self, ratio):
        """
        Sets the ratio of this EdgeLoadBalancerPoolMember.
        The ratio of selecting eligible servers in the pool.

        :param ratio: The ratio of this EdgeLoadBalancerPoolMember.
        :type: int
        """
        if ratio is not None and ratio > 20:
            raise ValueError("Invalid value for `ratio`, must be a value less than or equal to `20`")
        if ratio is not None and ratio < 1:
            raise ValueError("Invalid value for `ratio`, must be a value greater than or equal to `1`")

        self._ratio = ratio

    @property
    def enabled(self):
        """
        Gets the enabled of this EdgeLoadBalancerPoolMember.
        Whether the Load Balancer Pool member is enabled or not.

        :return: The enabled of this EdgeLoadBalancerPoolMember.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this EdgeLoadBalancerPoolMember.
        Whether the Load Balancer Pool member is enabled or not.

        :param enabled: The enabled of this EdgeLoadBalancerPoolMember.
        :type: bool
        """

        self._enabled = enabled

    @property
    def health_status(self):
        """
        Gets the health_status of this EdgeLoadBalancerPoolMember.
        The current health status of the pool member. Possible values are: <ul> <li> UP - The member is operational. <li> DOWN - The member is down. <li> DISABLED - The member is disabled <li> UNKNOWN - The state is unknown. </ul> 

        :return: The health_status of this EdgeLoadBalancerPoolMember.
        :rtype: str
        """
        return self._health_status

    @health_status.setter
    def health_status(self, health_status):
        """
        Sets the health_status of this EdgeLoadBalancerPoolMember.
        The current health status of the pool member. Possible values are: <ul> <li> UP - The member is operational. <li> DOWN - The member is down. <li> DISABLED - The member is disabled <li> UNKNOWN - The state is unknown. </ul> 

        :param health_status: The health_status of this EdgeLoadBalancerPoolMember.
        :type: str
        """

        self._health_status = health_status

    @property
    def marked_down_by(self):
        """
        Gets the marked_down_by of this EdgeLoadBalancerPoolMember.
        When the member is DOWN, the value gives the names of the health monitors that marked the member as down. If a monitor cannot be determined, the value will be UNKNOWN. 

        :return: The marked_down_by of this EdgeLoadBalancerPoolMember.
        :rtype: list[str]
        """
        return self._marked_down_by

    @marked_down_by.setter
    def marked_down_by(self, marked_down_by):
        """
        Sets the marked_down_by of this EdgeLoadBalancerPoolMember.
        When the member is DOWN, the value gives the names of the health monitors that marked the member as down. If a monitor cannot be determined, the value will be UNKNOWN. 

        :param marked_down_by: The marked_down_by of this EdgeLoadBalancerPoolMember.
        :type: list[str]
        """

        self._marked_down_by = marked_down_by

    @property
    def detailed_health_message(self):
        """
        Gets the detailed_health_message of this EdgeLoadBalancerPoolMember.
        The non-localized detailed message on the health of the pool member. 

        :return: The detailed_health_message of this EdgeLoadBalancerPoolMember.
        :rtype: str
        """
        return self._detailed_health_message

    @detailed_health_message.setter
    def detailed_health_message(self, detailed_health_message):
        """
        Sets the detailed_health_message of this EdgeLoadBalancerPoolMember.
        The non-localized detailed message on the health of the pool member. 

        :param detailed_health_message: The detailed_health_message of this EdgeLoadBalancerPoolMember.
        :type: str
        """

        self._detailed_health_message = detailed_health_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeLoadBalancerPoolMember):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
