# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeLoadBalancerPool(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'NetworkingObjectStatusType',
        'id': 'str',
        'description': 'str',
        'enabled': 'bool',
        'passive_monitoring_enabled': 'bool',
        'health_status': 'str',
        'member_count': 'int',
        'enabled_member_count': 'int',
        'up_member_count': 'int',
        'health_message': 'str',
        'name': 'str',
        'default_port': 'int',
        'graceful_timeout_period': 'int',
        'algorithm': 'str',
        'health_monitors': 'list[EdgeLoadBalancerHealthMonitor]',
        'persistence_profile': 'EdgeLoadBalancerPersistenceProfile',
        'members': 'list[EdgeLoadBalancerPoolMember]',
        'virtual_service_refs': 'list[EntityReference]',
        'gateway_ref': 'EntityReference',
        'ca_certificate_refs': 'list[EntityReference]',
        'common_name_check_enabled': 'bool',
        'domain_names': 'list[str]'
    }

    attribute_map = {
        'status': 'status',
        'id': 'id',
        'description': 'description',
        'enabled': 'enabled',
        'passive_monitoring_enabled': 'passiveMonitoringEnabled',
        'health_status': 'healthStatus',
        'member_count': 'memberCount',
        'enabled_member_count': 'enabledMemberCount',
        'up_member_count': 'upMemberCount',
        'health_message': 'healthMessage',
        'name': 'name',
        'default_port': 'defaultPort',
        'graceful_timeout_period': 'gracefulTimeoutPeriod',
        'algorithm': 'algorithm',
        'health_monitors': 'healthMonitors',
        'persistence_profile': 'persistenceProfile',
        'members': 'members',
        'virtual_service_refs': 'virtualServiceRefs',
        'gateway_ref': 'gatewayRef',
        'ca_certificate_refs': 'caCertificateRefs',
        'common_name_check_enabled': 'commonNameCheckEnabled',
        'domain_names': 'domainNames'
    }

    def __init__(self, status=None, id=None, description=None, enabled=True, passive_monitoring_enabled=True, health_status=None, member_count=None, enabled_member_count=None, up_member_count=None, health_message=None, name=None, default_port=80, graceful_timeout_period=1, algorithm='LEAST_CONNECTIONS', health_monitors=None, persistence_profile=None, members=None, virtual_service_refs=None, gateway_ref=None, ca_certificate_refs=None, common_name_check_enabled=False, domain_names=None):
        """
        EdgeLoadBalancerPool - a model defined in Swagger
        """

        self._status = None
        self._id = None
        self._description = None
        self._enabled = None
        self._passive_monitoring_enabled = None
        self._health_status = None
        self._member_count = None
        self._enabled_member_count = None
        self._up_member_count = None
        self._health_message = None
        self._name = None
        self._default_port = None
        self._graceful_timeout_period = None
        self._algorithm = None
        self._health_monitors = None
        self._persistence_profile = None
        self._members = None
        self._virtual_service_refs = None
        self._gateway_ref = None
        self._ca_certificate_refs = None
        self._common_name_check_enabled = None
        self._domain_names = None

        if status is not None:
          self.status = status
        if id is not None:
          self.id = id
        if description is not None:
          self.description = description
        if enabled is not None:
          self.enabled = enabled
        if passive_monitoring_enabled is not None:
          self.passive_monitoring_enabled = passive_monitoring_enabled
        if health_status is not None:
          self.health_status = health_status
        if member_count is not None:
          self.member_count = member_count
        if enabled_member_count is not None:
          self.enabled_member_count = enabled_member_count
        if up_member_count is not None:
          self.up_member_count = up_member_count
        if health_message is not None:
          self.health_message = health_message
        self.name = name
        if default_port is not None:
          self.default_port = default_port
        if graceful_timeout_period is not None:
          self.graceful_timeout_period = graceful_timeout_period
        if algorithm is not None:
          self.algorithm = algorithm
        if health_monitors is not None:
          self.health_monitors = health_monitors
        if persistence_profile is not None:
          self.persistence_profile = persistence_profile
        if members is not None:
          self.members = members
        if virtual_service_refs is not None:
          self.virtual_service_refs = virtual_service_refs
        self.gateway_ref = gateway_ref
        if ca_certificate_refs is not None:
          self.ca_certificate_refs = ca_certificate_refs
        if common_name_check_enabled is not None:
          self.common_name_check_enabled = common_name_check_enabled
        if domain_names is not None:
          self.domain_names = domain_names

    @property
    def status(self):
        """
        Gets the status of this EdgeLoadBalancerPool.
        Represents current status of the networking object. 

        :return: The status of this EdgeLoadBalancerPool.
        :rtype: NetworkingObjectStatusType
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this EdgeLoadBalancerPool.
        Represents current status of the networking object. 

        :param status: The status of this EdgeLoadBalancerPool.
        :type: NetworkingObjectStatusType
        """

        self._status = status

    @property
    def id(self):
        """
        Gets the id of this EdgeLoadBalancerPool.
        The unique ID of this Load Balancer Pool. On updates, the ID is required for the pool, while for create a new ID will be generated.

        :return: The id of this EdgeLoadBalancerPool.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeLoadBalancerPool.
        The unique ID of this Load Balancer Pool. On updates, the ID is required for the pool, while for create a new ID will be generated.

        :param id: The id of this EdgeLoadBalancerPool.
        :type: str
        """

        self._id = id

    @property
    def description(self):
        """
        Gets the description of this EdgeLoadBalancerPool.
        The description of the Load Balancer Pool.

        :return: The description of this EdgeLoadBalancerPool.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EdgeLoadBalancerPool.
        The description of the Load Balancer Pool.

        :param description: The description of this EdgeLoadBalancerPool.
        :type: str
        """

        self._description = description

    @property
    def enabled(self):
        """
        Gets the enabled of this EdgeLoadBalancerPool.
        True if Load Balancer Pool is enabled.

        :return: The enabled of this EdgeLoadBalancerPool.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this EdgeLoadBalancerPool.
        True if Load Balancer Pool is enabled.

        :param enabled: The enabled of this EdgeLoadBalancerPool.
        :type: bool
        """

        self._enabled = enabled

    @property
    def passive_monitoring_enabled(self):
        """
        Gets the passive_monitoring_enabled of this EdgeLoadBalancerPool.
        Whether passive monitoring for this pool is enabled or not.

        :return: The passive_monitoring_enabled of this EdgeLoadBalancerPool.
        :rtype: bool
        """
        return self._passive_monitoring_enabled

    @passive_monitoring_enabled.setter
    def passive_monitoring_enabled(self, passive_monitoring_enabled):
        """
        Sets the passive_monitoring_enabled of this EdgeLoadBalancerPool.
        Whether passive monitoring for this pool is enabled or not.

        :param passive_monitoring_enabled: The passive_monitoring_enabled of this EdgeLoadBalancerPool.
        :type: bool
        """

        self._passive_monitoring_enabled = passive_monitoring_enabled

    @property
    def health_status(self):
        """
        Gets the health_status of this EdgeLoadBalancerPool.
        The current health status of the pool. Possible values are: <ul> <li> UP - The pool is operational. <li> RUNNING - The pool is operational, but less than 50% of the pool members are up. <li> DOWN - All members in the pool are down. <li> DISABLED - Either the pool is disabled or all of the members are disabled. <li> UNAVAILABLE - The pool is unavailable. Examples: pool has no members or pool is not assigned to any virtual service. <li> UNKNOWN - The pool state is unknown. </ul> 

        :return: The health_status of this EdgeLoadBalancerPool.
        :rtype: str
        """
        return self._health_status

    @health_status.setter
    def health_status(self, health_status):
        """
        Sets the health_status of this EdgeLoadBalancerPool.
        The current health status of the pool. Possible values are: <ul> <li> UP - The pool is operational. <li> RUNNING - The pool is operational, but less than 50% of the pool members are up. <li> DOWN - All members in the pool are down. <li> DISABLED - Either the pool is disabled or all of the members are disabled. <li> UNAVAILABLE - The pool is unavailable. Examples: pool has no members or pool is not assigned to any virtual service. <li> UNKNOWN - The pool state is unknown. </ul> 

        :param health_status: The health_status of this EdgeLoadBalancerPool.
        :type: str
        """

        self._health_status = health_status

    @property
    def member_count(self):
        """
        Gets the member_count of this EdgeLoadBalancerPool.
        The total number of members in the pool.

        :return: The member_count of this EdgeLoadBalancerPool.
        :rtype: int
        """
        return self._member_count

    @member_count.setter
    def member_count(self, member_count):
        """
        Sets the member_count of this EdgeLoadBalancerPool.
        The total number of members in the pool.

        :param member_count: The member_count of this EdgeLoadBalancerPool.
        :type: int
        """

        self._member_count = member_count

    @property
    def enabled_member_count(self):
        """
        Gets the enabled_member_count of this EdgeLoadBalancerPool.
        The number of enabled members in the pool.

        :return: The enabled_member_count of this EdgeLoadBalancerPool.
        :rtype: int
        """
        return self._enabled_member_count

    @enabled_member_count.setter
    def enabled_member_count(self, enabled_member_count):
        """
        Sets the enabled_member_count of this EdgeLoadBalancerPool.
        The number of enabled members in the pool.

        :param enabled_member_count: The enabled_member_count of this EdgeLoadBalancerPool.
        :type: int
        """

        self._enabled_member_count = enabled_member_count

    @property
    def up_member_count(self):
        """
        Gets the up_member_count of this EdgeLoadBalancerPool.
        The number of enabled members in the pool that are operational.

        :return: The up_member_count of this EdgeLoadBalancerPool.
        :rtype: int
        """
        return self._up_member_count

    @up_member_count.setter
    def up_member_count(self, up_member_count):
        """
        Sets the up_member_count of this EdgeLoadBalancerPool.
        The number of enabled members in the pool that are operational.

        :param up_member_count: The up_member_count of this EdgeLoadBalancerPool.
        :type: int
        """

        self._up_member_count = up_member_count

    @property
    def health_message(self):
        """
        Gets the health_message of this EdgeLoadBalancerPool.
        The localized message on the health of the pool.

        :return: The health_message of this EdgeLoadBalancerPool.
        :rtype: str
        """
        return self._health_message

    @health_message.setter
    def health_message(self, health_message):
        """
        Sets the health_message of this EdgeLoadBalancerPool.
        The localized message on the health of the pool.

        :param health_message: The health_message of this EdgeLoadBalancerPool.
        :type: str
        """

        self._health_message = health_message

    @property
    def name(self):
        """
        Gets the name of this EdgeLoadBalancerPool.
        Name for the Load Balancer Pool. Name is unique across all pools for an Edge Gateway.

        :return: The name of this EdgeLoadBalancerPool.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EdgeLoadBalancerPool.
        Name for the Load Balancer Pool. Name is unique across all pools for an Edge Gateway.

        :param name: The name of this EdgeLoadBalancerPool.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def default_port(self):
        """
        Gets the default_port of this EdgeLoadBalancerPool.
        The destination server port used by the traffic sent to the member.

        :return: The default_port of this EdgeLoadBalancerPool.
        :rtype: int
        """
        return self._default_port

    @default_port.setter
    def default_port(self, default_port):
        """
        Sets the default_port of this EdgeLoadBalancerPool.
        The destination server port used by the traffic sent to the member.

        :param default_port: The default_port of this EdgeLoadBalancerPool.
        :type: int
        """
        if default_port is not None and default_port > 65535:
            raise ValueError("Invalid value for `default_port`, must be a value less than or equal to `65535`")
        if default_port is not None and default_port < 1:
            raise ValueError("Invalid value for `default_port`, must be a value greater than or equal to `1`")

        self._default_port = default_port

    @property
    def graceful_timeout_period(self):
        """
        Gets the graceful_timeout_period of this EdgeLoadBalancerPool.
        Maximum time (in minutes) to gracefully disable a member. Virtual service waits for the specified time before terminating the existing connections to the members that are disabled. <code>Special values: 0 represents 'Immediate', -1 represents 'Infinite'.</code> 

        :return: The graceful_timeout_period of this EdgeLoadBalancerPool.
        :rtype: int
        """
        return self._graceful_timeout_period

    @graceful_timeout_period.setter
    def graceful_timeout_period(self, graceful_timeout_period):
        """
        Sets the graceful_timeout_period of this EdgeLoadBalancerPool.
        Maximum time (in minutes) to gracefully disable a member. Virtual service waits for the specified time before terminating the existing connections to the members that are disabled. <code>Special values: 0 represents 'Immediate', -1 represents 'Infinite'.</code> 

        :param graceful_timeout_period: The graceful_timeout_period of this EdgeLoadBalancerPool.
        :type: int
        """
        if graceful_timeout_period is not None and graceful_timeout_period > 7200:
            raise ValueError("Invalid value for `graceful_timeout_period`, must be a value less than or equal to `7200`")
        if graceful_timeout_period is not None and graceful_timeout_period < -1:
            raise ValueError("Invalid value for `graceful_timeout_period`, must be a value greater than or equal to `-1`")

        self._graceful_timeout_period = graceful_timeout_period

    @property
    def algorithm(self):
        """
        Gets the algorithm of this EdgeLoadBalancerPool.
        The algorithm for choosing a member within the pool's list of available members for each new connection. Default value is \"LEAST_CONNECTIONS\". Supported algorithms are: <ul> <li>LEAST_CONNECTIONS <li>ROUND_ROBIN <li>CONSISTENT_HASH <li>FASTEST_RESPONSE <li>LEAST_LOAD <li>FEWEST_SERVERS <li>RANDOM <li>FEWEST_TASKS <li>CORE_AFFINITY </ul> <em>CONSISTENT_HASH</em> uses Source IP Address hash. Using <em>FASTEST_RESPONSE</em>, <em>LEAST_LOAD</em>, <em>FEWEST_SERVERS</em>, <em>RANDOM</em>, <em>FEWEST_TASKS</em>, <em>CORE_AFFINITY</em> algorithms may require additional licensing. 

        :return: The algorithm of this EdgeLoadBalancerPool.
        :rtype: str
        """
        return self._algorithm

    @algorithm.setter
    def algorithm(self, algorithm):
        """
        Sets the algorithm of this EdgeLoadBalancerPool.
        The algorithm for choosing a member within the pool's list of available members for each new connection. Default value is \"LEAST_CONNECTIONS\". Supported algorithms are: <ul> <li>LEAST_CONNECTIONS <li>ROUND_ROBIN <li>CONSISTENT_HASH <li>FASTEST_RESPONSE <li>LEAST_LOAD <li>FEWEST_SERVERS <li>RANDOM <li>FEWEST_TASKS <li>CORE_AFFINITY </ul> <em>CONSISTENT_HASH</em> uses Source IP Address hash. Using <em>FASTEST_RESPONSE</em>, <em>LEAST_LOAD</em>, <em>FEWEST_SERVERS</em>, <em>RANDOM</em>, <em>FEWEST_TASKS</em>, <em>CORE_AFFINITY</em> algorithms may require additional licensing. 

        :param algorithm: The algorithm of this EdgeLoadBalancerPool.
        :type: str
        """

        self._algorithm = algorithm

    @property
    def health_monitors(self):
        """
        Gets the health_monitors of this EdgeLoadBalancerPool.
        Member server's health can be monitored by using one or more health monitors. Active monitors generate synthetic traffic and mark a server up or down based on the response. 

        :return: The health_monitors of this EdgeLoadBalancerPool.
        :rtype: list[EdgeLoadBalancerHealthMonitor]
        """
        return self._health_monitors

    @health_monitors.setter
    def health_monitors(self, health_monitors):
        """
        Sets the health_monitors of this EdgeLoadBalancerPool.
        Member server's health can be monitored by using one or more health monitors. Active monitors generate synthetic traffic and mark a server up or down based on the response. 

        :param health_monitors: The health_monitors of this EdgeLoadBalancerPool.
        :type: list[EdgeLoadBalancerHealthMonitor]
        """

        self._health_monitors = health_monitors

    @property
    def persistence_profile(self):
        """
        Gets the persistence_profile of this EdgeLoadBalancerPool.
        Selected persistence profile for the Load Balancer Pool.

        :return: The persistence_profile of this EdgeLoadBalancerPool.
        :rtype: EdgeLoadBalancerPersistenceProfile
        """
        return self._persistence_profile

    @persistence_profile.setter
    def persistence_profile(self, persistence_profile):
        """
        Sets the persistence_profile of this EdgeLoadBalancerPool.
        Selected persistence profile for the Load Balancer Pool.

        :param persistence_profile: The persistence_profile of this EdgeLoadBalancerPool.
        :type: EdgeLoadBalancerPersistenceProfile
        """

        self._persistence_profile = persistence_profile

    @property
    def members(self):
        """
        Gets the members of this EdgeLoadBalancerPool.
        The list of destination servers which are used by the Load Balancer Pool to direct load balanced traffic. 

        :return: The members of this EdgeLoadBalancerPool.
        :rtype: list[EdgeLoadBalancerPoolMember]
        """
        return self._members

    @members.setter
    def members(self, members):
        """
        Sets the members of this EdgeLoadBalancerPool.
        The list of destination servers which are used by the Load Balancer Pool to direct load balanced traffic. 

        :param members: The members of this EdgeLoadBalancerPool.
        :type: list[EdgeLoadBalancerPoolMember]
        """

        self._members = members

    @property
    def virtual_service_refs(self):
        """
        Gets the virtual_service_refs of this EdgeLoadBalancerPool.
        The list of Load Balancer Virtual Services associated with this Load balancer Pool.

        :return: The virtual_service_refs of this EdgeLoadBalancerPool.
        :rtype: list[EntityReference]
        """
        return self._virtual_service_refs

    @virtual_service_refs.setter
    def virtual_service_refs(self, virtual_service_refs):
        """
        Sets the virtual_service_refs of this EdgeLoadBalancerPool.
        The list of Load Balancer Virtual Services associated with this Load balancer Pool.

        :param virtual_service_refs: The virtual_service_refs of this EdgeLoadBalancerPool.
        :type: list[EntityReference]
        """

        self._virtual_service_refs = virtual_service_refs

    @property
    def gateway_ref(self):
        """
        Gets the gateway_ref of this EdgeLoadBalancerPool.
        The Edge Gateway associated with this Load Balancer Pool.

        :return: The gateway_ref of this EdgeLoadBalancerPool.
        :rtype: EntityReference
        """
        return self._gateway_ref

    @gateway_ref.setter
    def gateway_ref(self, gateway_ref):
        """
        Sets the gateway_ref of this EdgeLoadBalancerPool.
        The Edge Gateway associated with this Load Balancer Pool.

        :param gateway_ref: The gateway_ref of this EdgeLoadBalancerPool.
        :type: EntityReference
        """
        if gateway_ref is None:
            raise ValueError("Invalid value for `gateway_ref`, must not be `None`")

        self._gateway_ref = gateway_ref

    @property
    def ca_certificate_refs(self):
        """
        Gets the ca_certificate_refs of this EdgeLoadBalancerPool.
        The root certificates to use when validating certificates presented by the pool members.

        :return: The ca_certificate_refs of this EdgeLoadBalancerPool.
        :rtype: list[EntityReference]
        """
        return self._ca_certificate_refs

    @ca_certificate_refs.setter
    def ca_certificate_refs(self, ca_certificate_refs):
        """
        Sets the ca_certificate_refs of this EdgeLoadBalancerPool.
        The root certificates to use when validating certificates presented by the pool members.

        :param ca_certificate_refs: The ca_certificate_refs of this EdgeLoadBalancerPool.
        :type: list[EntityReference]
        """

        self._ca_certificate_refs = ca_certificate_refs

    @property
    def common_name_check_enabled(self):
        """
        Gets the common_name_check_enabled of this EdgeLoadBalancerPool.
        Whether to check the common name of the certificate presented by the pool member. This cannot be enabled if no caCertificateRefs are specified. 

        :return: The common_name_check_enabled of this EdgeLoadBalancerPool.
        :rtype: bool
        """
        return self._common_name_check_enabled

    @common_name_check_enabled.setter
    def common_name_check_enabled(self, common_name_check_enabled):
        """
        Sets the common_name_check_enabled of this EdgeLoadBalancerPool.
        Whether to check the common name of the certificate presented by the pool member. This cannot be enabled if no caCertificateRefs are specified. 

        :param common_name_check_enabled: The common_name_check_enabled of this EdgeLoadBalancerPool.
        :type: bool
        """

        self._common_name_check_enabled = common_name_check_enabled

    @property
    def domain_names(self):
        """
        Gets the domain_names of this EdgeLoadBalancerPool.
        A list of domain names which will be used to verify the common names or subject alternative names presented by the pool member certificates. It is performed only when common name check (commonNameCheckEnabled) is enabled. If common name check is enabled, but domain names are not specified then the incoming host header will be used to check the certificate. 

        :return: The domain_names of this EdgeLoadBalancerPool.
        :rtype: list[str]
        """
        return self._domain_names

    @domain_names.setter
    def domain_names(self, domain_names):
        """
        Sets the domain_names of this EdgeLoadBalancerPool.
        A list of domain names which will be used to verify the common names or subject alternative names presented by the pool member certificates. It is performed only when common name check (commonNameCheckEnabled) is enabled. If common name check is enabled, but domain names are not specified then the incoming host header will be used to check the certificate. 

        :param domain_names: The domain_names of this EdgeLoadBalancerPool.
        :type: list[str]
        """

        self._domain_names = domain_names

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeLoadBalancerPool):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
