# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeLoadBalancerMetricSummaryStats(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'mean': 'float',
        'min': 'float',
        'max': 'float',
        'trend': 'float',
        'sample_size': 'float',
        'start_time': 'str',
        'end_time': 'str'
    }

    attribute_map = {
        'mean': 'mean',
        'min': 'min',
        'max': 'max',
        'trend': 'trend',
        'sample_size': 'sampleSize',
        'start_time': 'startTime',
        'end_time': 'endTime'
    }

    def __init__(self, mean=None, min=None, max=None, trend=None, sample_size=None, start_time=None, end_time=None):
        """
        EdgeLoadBalancerMetricSummaryStats - a model defined in Swagger
        """

        self._mean = None
        self._min = None
        self._max = None
        self._trend = None
        self._sample_size = None
        self._start_time = None
        self._end_time = None

        if mean is not None:
          self.mean = mean
        if min is not None:
          self.min = min
        if max is not None:
          self.max = max
        if trend is not None:
          self.trend = trend
        if sample_size is not None:
          self.sample_size = sample_size
        if start_time is not None:
          self.start_time = start_time
        if end_time is not None:
          self.end_time = end_time

    @property
    def mean(self):
        """
        Gets the mean of this EdgeLoadBalancerMetricSummaryStats.
        Mean value of sample.

        :return: The mean of this EdgeLoadBalancerMetricSummaryStats.
        :rtype: float
        """
        return self._mean

    @mean.setter
    def mean(self, mean):
        """
        Sets the mean of this EdgeLoadBalancerMetricSummaryStats.
        Mean value of sample.

        :param mean: The mean of this EdgeLoadBalancerMetricSummaryStats.
        :type: float
        """

        self._mean = mean

    @property
    def min(self):
        """
        Gets the min of this EdgeLoadBalancerMetricSummaryStats.
        Min value of sample.

        :return: The min of this EdgeLoadBalancerMetricSummaryStats.
        :rtype: float
        """
        return self._min

    @min.setter
    def min(self, min):
        """
        Sets the min of this EdgeLoadBalancerMetricSummaryStats.
        Min value of sample.

        :param min: The min of this EdgeLoadBalancerMetricSummaryStats.
        :type: float
        """

        self._min = min

    @property
    def max(self):
        """
        Gets the max of this EdgeLoadBalancerMetricSummaryStats.
        Max value of sample.

        :return: The max of this EdgeLoadBalancerMetricSummaryStats.
        :rtype: float
        """
        return self._max

    @max.setter
    def max(self, max):
        """
        Sets the max of this EdgeLoadBalancerMetricSummaryStats.
        Max value of sample.

        :param max: The max of this EdgeLoadBalancerMetricSummaryStats.
        :type: float
        """

        self._max = max

    @property
    def trend(self):
        """
        Gets the trend of this EdgeLoadBalancerMetricSummaryStats.
        Sample trend.

        :return: The trend of this EdgeLoadBalancerMetricSummaryStats.
        :rtype: float
        """
        return self._trend

    @trend.setter
    def trend(self, trend):
        """
        Sets the trend of this EdgeLoadBalancerMetricSummaryStats.
        Sample trend.

        :param trend: The trend of this EdgeLoadBalancerMetricSummaryStats.
        :type: float
        """

        self._trend = trend

    @property
    def sample_size(self):
        """
        Gets the sample_size of this EdgeLoadBalancerMetricSummaryStats.
        Sample size.

        :return: The sample_size of this EdgeLoadBalancerMetricSummaryStats.
        :rtype: float
        """
        return self._sample_size

    @sample_size.setter
    def sample_size(self, sample_size):
        """
        Sets the sample_size of this EdgeLoadBalancerMetricSummaryStats.
        Sample size.

        :param sample_size: The sample_size of this EdgeLoadBalancerMetricSummaryStats.
        :type: float
        """

        self._sample_size = sample_size

    @property
    def start_time(self):
        """
        Gets the start_time of this EdgeLoadBalancerMetricSummaryStats.
        Start time of data series.  ISO 8601 format (i.e. 2020-07-24T00:00:00).

        :return: The start_time of this EdgeLoadBalancerMetricSummaryStats.
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Sets the start_time of this EdgeLoadBalancerMetricSummaryStats.
        Start time of data series.  ISO 8601 format (i.e. 2020-07-24T00:00:00).

        :param start_time: The start_time of this EdgeLoadBalancerMetricSummaryStats.
        :type: str
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """
        Gets the end_time of this EdgeLoadBalancerMetricSummaryStats.
        End time of data series.  ISO 8601 format (i.e. 2020-07-24T00:00:00).

        :return: The end_time of this EdgeLoadBalancerMetricSummaryStats.
        :rtype: str
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """
        Sets the end_time of this EdgeLoadBalancerMetricSummaryStats.
        End time of data series.  ISO 8601 format (i.e. 2020-07-24T00:00:00).

        :param end_time: The end_time of this EdgeLoadBalancerMetricSummaryStats.
        :type: str
        """

        self._end_time = end_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeLoadBalancerMetricSummaryStats):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
