# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeL2VpnTunnel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'local_endpoint_ip': 'str',
        'remote_endpoint_ip': 'str',
        'tunnel_interface': 'str',
        'pre_shared_key': 'str',
        'connector_initiation_mode': 'str',
        'enabled': 'bool',
        'session_mode': 'str',
        'peer_code': 'str',
        'attached_networks': 'list[EntityReference]',
        'stretched_networks': 'list[EdgeL2VpnStretchedNetwork]',
        'logging': 'bool',
        'version': 'ObjectVersion'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'local_endpoint_ip': 'localEndpointIP',
        'remote_endpoint_ip': 'remoteEndpointIP',
        'tunnel_interface': 'tunnelInterface',
        'pre_shared_key': 'preSharedKey',
        'connector_initiation_mode': 'connectorInitiationMode',
        'enabled': 'enabled',
        'session_mode': 'sessionMode',
        'peer_code': 'peerCode',
        'attached_networks': 'attachedNetworks',
        'stretched_networks': 'stretchedNetworks',
        'logging': 'logging',
        'version': 'version'
    }

    def __init__(self, id=None, name=None, description=None, local_endpoint_ip=None, remote_endpoint_ip=None, tunnel_interface=None, pre_shared_key=None, connector_initiation_mode='INITIATOR', enabled=True, session_mode='SERVER', peer_code=None, attached_networks=None, stretched_networks=None, logging=False, version=None):
        """
        EdgeL2VpnTunnel - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._local_endpoint_ip = None
        self._remote_endpoint_ip = None
        self._tunnel_interface = None
        self._pre_shared_key = None
        self._connector_initiation_mode = None
        self._enabled = None
        self._session_mode = None
        self._peer_code = None
        self._attached_networks = None
        self._stretched_networks = None
        self._logging = None
        self._version = None

        if id is not None:
          self.id = id
        self.name = name
        if description is not None:
          self.description = description
        self.local_endpoint_ip = local_endpoint_ip
        self.remote_endpoint_ip = remote_endpoint_ip
        self.tunnel_interface = tunnel_interface
        self.pre_shared_key = pre_shared_key
        if connector_initiation_mode is not None:
          self.connector_initiation_mode = connector_initiation_mode
        if enabled is not None:
          self.enabled = enabled
        self.session_mode = session_mode
        if peer_code is not None:
          self.peer_code = peer_code
        if attached_networks is not None:
          self.attached_networks = attached_networks
        if stretched_networks is not None:
          self.stretched_networks = stretched_networks
        if logging is not None:
          self.logging = logging
        if version is not None:
          self.version = version

    @property
    def id(self):
        """
        Gets the id of this EdgeL2VpnTunnel.
        The unique id of this L2 VPN tunnel. On updates, the id is required for the tunnel, while for create a new id will be generated. This id is not a VCD URN. 

        :return: The id of this EdgeL2VpnTunnel.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeL2VpnTunnel.
        The unique id of this L2 VPN tunnel. On updates, the id is required for the tunnel, while for create a new id will be generated. This id is not a VCD URN. 

        :param id: The id of this EdgeL2VpnTunnel.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this EdgeL2VpnTunnel.
        Name for the tunnel.

        :return: The name of this EdgeL2VpnTunnel.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EdgeL2VpnTunnel.
        Name for the tunnel.

        :param name: The name of this EdgeL2VpnTunnel.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this EdgeL2VpnTunnel.
        Description for the tunnel.

        :return: The description of this EdgeL2VpnTunnel.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this EdgeL2VpnTunnel.
        Description for the tunnel.

        :param description: The description of this EdgeL2VpnTunnel.
        :type: str
        """

        self._description = description

    @property
    def local_endpoint_ip(self):
        """
        Gets the local_endpoint_ip of this EdgeL2VpnTunnel.
        The IP address of the local endpoint, which corresponds to the Edge Gateway the tunnel is being configured on. 

        :return: The local_endpoint_ip of this EdgeL2VpnTunnel.
        :rtype: str
        """
        return self._local_endpoint_ip

    @local_endpoint_ip.setter
    def local_endpoint_ip(self, local_endpoint_ip):
        """
        Sets the local_endpoint_ip of this EdgeL2VpnTunnel.
        The IP address of the local endpoint, which corresponds to the Edge Gateway the tunnel is being configured on. 

        :param local_endpoint_ip: The local_endpoint_ip of this EdgeL2VpnTunnel.
        :type: str
        """
        if local_endpoint_ip is None:
            raise ValueError("Invalid value for `local_endpoint_ip`, must not be `None`")

        self._local_endpoint_ip = local_endpoint_ip

    @property
    def remote_endpoint_ip(self):
        """
        Gets the remote_endpoint_ip of this EdgeL2VpnTunnel.
        The IP address of the remote endpoint, which corresponds to the device on the remote site terminating the VPN tunnel. 

        :return: The remote_endpoint_ip of this EdgeL2VpnTunnel.
        :rtype: str
        """
        return self._remote_endpoint_ip

    @remote_endpoint_ip.setter
    def remote_endpoint_ip(self, remote_endpoint_ip):
        """
        Sets the remote_endpoint_ip of this EdgeL2VpnTunnel.
        The IP address of the remote endpoint, which corresponds to the device on the remote site terminating the VPN tunnel. 

        :param remote_endpoint_ip: The remote_endpoint_ip of this EdgeL2VpnTunnel.
        :type: str
        """
        if remote_endpoint_ip is None:
            raise ValueError("Invalid value for `remote_endpoint_ip`, must not be `None`")

        self._remote_endpoint_ip = remote_endpoint_ip

    @property
    def tunnel_interface(self):
        """
        Gets the tunnel_interface of this EdgeL2VpnTunnel.
        The network CIDR block over which the session interfaces.

        :return: The tunnel_interface of this EdgeL2VpnTunnel.
        :rtype: str
        """
        return self._tunnel_interface

    @tunnel_interface.setter
    def tunnel_interface(self, tunnel_interface):
        """
        Sets the tunnel_interface of this EdgeL2VpnTunnel.
        The network CIDR block over which the session interfaces.

        :param tunnel_interface: The tunnel_interface of this EdgeL2VpnTunnel.
        :type: str
        """
        if tunnel_interface is None:
            raise ValueError("Invalid value for `tunnel_interface`, must not be `None`")

        self._tunnel_interface = tunnel_interface

    @property
    def pre_shared_key(self):
        """
        Gets the pre_shared_key of this EdgeL2VpnTunnel.
        This is the Pre-shared key used for authentication, no specific format is required.

        :return: The pre_shared_key of this EdgeL2VpnTunnel.
        :rtype: str
        """
        return self._pre_shared_key

    @pre_shared_key.setter
    def pre_shared_key(self, pre_shared_key):
        """
        Sets the pre_shared_key of this EdgeL2VpnTunnel.
        This is the Pre-shared key used for authentication, no specific format is required.

        :param pre_shared_key: The pre_shared_key of this EdgeL2VpnTunnel.
        :type: str
        """
        if pre_shared_key is None:
            raise ValueError("Invalid value for `pre_shared_key`, must not be `None`")

        self._pre_shared_key = pre_shared_key

    @property
    def connector_initiation_mode(self):
        """
        Gets the connector_initiation_mode of this EdgeL2VpnTunnel.
        This is the mode used by the local endpoint to establish an IKE Connection with the remote site. The default is INITIATOR. <ul>   <li>INITIATOR - Local endpoint initiates tunnel setup and will also respond to incoming tunnel setup requests from the peer gateway.</li>   <li>RESPOND_ONLY - Local endpoint shall only respond to incoming tunnel setup requests, it shall not initiate the tunnel setup.</li>   <li>ON_DEMAND - In this mode local endpoint will initiate tunnel creation once first packet matching the policy rule is received, and will also respond to   incoming initiation requests.</li> </ul> 

        :return: The connector_initiation_mode of this EdgeL2VpnTunnel.
        :rtype: str
        """
        return self._connector_initiation_mode

    @connector_initiation_mode.setter
    def connector_initiation_mode(self, connector_initiation_mode):
        """
        Sets the connector_initiation_mode of this EdgeL2VpnTunnel.
        This is the mode used by the local endpoint to establish an IKE Connection with the remote site. The default is INITIATOR. <ul>   <li>INITIATOR - Local endpoint initiates tunnel setup and will also respond to incoming tunnel setup requests from the peer gateway.</li>   <li>RESPOND_ONLY - Local endpoint shall only respond to incoming tunnel setup requests, it shall not initiate the tunnel setup.</li>   <li>ON_DEMAND - In this mode local endpoint will initiate tunnel creation once first packet matching the policy rule is received, and will also respond to   incoming initiation requests.</li> </ul> 

        :param connector_initiation_mode: The connector_initiation_mode of this EdgeL2VpnTunnel.
        :type: str
        """

        self._connector_initiation_mode = connector_initiation_mode

    @property
    def enabled(self):
        """
        Gets the enabled of this EdgeL2VpnTunnel.
        Described whether the tunnel is enabled or not. The default is true.

        :return: The enabled of this EdgeL2VpnTunnel.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this EdgeL2VpnTunnel.
        Described whether the tunnel is enabled or not. The default is true.

        :param enabled: The enabled of this EdgeL2VpnTunnel.
        :type: bool
        """

        self._enabled = enabled

    @property
    def session_mode(self):
        """
        Gets the session_mode of this EdgeL2VpnTunnel.
        The current session mode, one of either SERVER or CLIENT. <ul>   <li>SERVER - In which the edge gateway acts as the server side of the L2 VPN tunnel and generates peer codes to distribute to client sessions.</li>   <li>CLIENT - In which the edge gateway receives peer codes from the server side of the L2 VPN tunnel to establish a connection.</li> </ul> 

        :return: The session_mode of this EdgeL2VpnTunnel.
        :rtype: str
        """
        return self._session_mode

    @session_mode.setter
    def session_mode(self, session_mode):
        """
        Sets the session_mode of this EdgeL2VpnTunnel.
        The current session mode, one of either SERVER or CLIENT. <ul>   <li>SERVER - In which the edge gateway acts as the server side of the L2 VPN tunnel and generates peer codes to distribute to client sessions.</li>   <li>CLIENT - In which the edge gateway receives peer codes from the server side of the L2 VPN tunnel to establish a connection.</li> </ul> 

        :param session_mode: The session_mode of this EdgeL2VpnTunnel.
        :type: str
        """
        if session_mode is None:
            raise ValueError("Invalid value for `session_mode`, must not be `None`")

        self._session_mode = session_mode

    @property
    def peer_code(self):
        """
        Gets the peer_code of this EdgeL2VpnTunnel.
        This property is a base64 encoded string of the full configuration for the tunnel, generated by the server-side L2 VPN session. An L2 VPN client session must receive and validate this string in order to successfully establish a tunnel, but be careful sharing or storing this code since it does contain the encoded PSK. Leave this property blank if this call is being used to establish a server-side session. 

        :return: The peer_code of this EdgeL2VpnTunnel.
        :rtype: str
        """
        return self._peer_code

    @peer_code.setter
    def peer_code(self, peer_code):
        """
        Sets the peer_code of this EdgeL2VpnTunnel.
        This property is a base64 encoded string of the full configuration for the tunnel, generated by the server-side L2 VPN session. An L2 VPN client session must receive and validate this string in order to successfully establish a tunnel, but be careful sharing or storing this code since it does contain the encoded PSK. Leave this property blank if this call is being used to establish a server-side session. 

        :param peer_code: The peer_code of this EdgeL2VpnTunnel.
        :type: str
        """

        self._peer_code = peer_code

    @property
    def attached_networks(self):
        """
        Gets the attached_networks of this EdgeL2VpnTunnel.
        The list of OrgVDC Network entity references which are currently attached to this L2VPN tunnel. 

        :return: The attached_networks of this EdgeL2VpnTunnel.
        :rtype: list[EntityReference]
        """
        return self._attached_networks

    @attached_networks.setter
    def attached_networks(self, attached_networks):
        """
        Sets the attached_networks of this EdgeL2VpnTunnel.
        The list of OrgVDC Network entity references which are currently attached to this L2VPN tunnel. 

        :param attached_networks: The attached_networks of this EdgeL2VpnTunnel.
        :type: list[EntityReference]
        """

        self._attached_networks = attached_networks

    @property
    def stretched_networks(self):
        """
        Gets the stretched_networks of this EdgeL2VpnTunnel.
        The list of OrgVDC Network entity references which are currently attached to this L2VPN tunnel. 

        :return: The stretched_networks of this EdgeL2VpnTunnel.
        :rtype: list[EdgeL2VpnStretchedNetwork]
        """
        return self._stretched_networks

    @stretched_networks.setter
    def stretched_networks(self, stretched_networks):
        """
        Sets the stretched_networks of this EdgeL2VpnTunnel.
        The list of OrgVDC Network entity references which are currently attached to this L2VPN tunnel. 

        :param stretched_networks: The stretched_networks of this EdgeL2VpnTunnel.
        :type: list[EdgeL2VpnStretchedNetwork]
        """

        self._stretched_networks = stretched_networks

    @property
    def logging(self):
        """
        Gets the logging of this EdgeL2VpnTunnel.
        Whether logging for the tunnel is enabled or not.

        :return: The logging of this EdgeL2VpnTunnel.
        :rtype: bool
        """
        return self._logging

    @logging.setter
    def logging(self, logging):
        """
        Sets the logging of this EdgeL2VpnTunnel.
        Whether logging for the tunnel is enabled or not.

        :param logging: The logging of this EdgeL2VpnTunnel.
        :type: bool
        """

        self._logging = logging

    @property
    def version(self):
        """
        Gets the version of this EdgeL2VpnTunnel.

        :return: The version of this EdgeL2VpnTunnel.
        :rtype: ObjectVersion
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this EdgeL2VpnTunnel.

        :param version: The version of this EdgeL2VpnTunnel.
        :type: ObjectVersion
        """

        self._version = version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeL2VpnTunnel):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
