# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class EdgeBgpNeighbor(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'neighbor_address': 'str',
        'remote_as_number': 'str',
        'keep_alive_timer': 'int',
        'hold_down_timer': 'int',
        'graceful_restart_mode': 'GracefulRestartModeTypes',
        'bfd': 'EdgeBgpBfdConfig',
        'allow_as_in': 'bool',
        'neighbor_password': 'str',
        'ip_address_type_filtering': 'str',
        'in_routes_filter_ref': 'ExtObjectReference',
        'out_routes_filter_ref': 'ExtObjectReference',
        'version': 'ObjectVersion'
    }

    attribute_map = {
        'id': 'id',
        'neighbor_address': 'neighborAddress',
        'remote_as_number': 'remoteASNumber',
        'keep_alive_timer': 'keepAliveTimer',
        'hold_down_timer': 'holdDownTimer',
        'graceful_restart_mode': 'gracefulRestartMode',
        'bfd': 'bfd',
        'allow_as_in': 'allowASIn',
        'neighbor_password': 'neighborPassword',
        'ip_address_type_filtering': 'ipAddressTypeFiltering',
        'in_routes_filter_ref': 'inRoutesFilterRef',
        'out_routes_filter_ref': 'outRoutesFilterRef',
        'version': 'version'
    }

    def __init__(self, id=None, neighbor_address=None, remote_as_number=None, keep_alive_timer=60, hold_down_timer=180, graceful_restart_mode=None, bfd=None, allow_as_in=False, neighbor_password=None, ip_address_type_filtering='DISABLED', in_routes_filter_ref=None, out_routes_filter_ref=None, version=None):
        """
        EdgeBgpNeighbor - a model defined in Swagger
        """

        self._id = None
        self._neighbor_address = None
        self._remote_as_number = None
        self._keep_alive_timer = None
        self._hold_down_timer = None
        self._graceful_restart_mode = None
        self._bfd = None
        self._allow_as_in = None
        self._neighbor_password = None
        self._ip_address_type_filtering = None
        self._in_routes_filter_ref = None
        self._out_routes_filter_ref = None
        self._version = None

        if id is not None:
          self.id = id
        self.neighbor_address = neighbor_address
        self.remote_as_number = remote_as_number
        if keep_alive_timer is not None:
          self.keep_alive_timer = keep_alive_timer
        if hold_down_timer is not None:
          self.hold_down_timer = hold_down_timer
        if graceful_restart_mode is not None:
          self.graceful_restart_mode = graceful_restart_mode
        if bfd is not None:
          self.bfd = bfd
        if allow_as_in is not None:
          self.allow_as_in = allow_as_in
        if neighbor_password is not None:
          self.neighbor_password = neighbor_password
        if ip_address_type_filtering is not None:
          self.ip_address_type_filtering = ip_address_type_filtering
        if in_routes_filter_ref is not None:
          self.in_routes_filter_ref = in_routes_filter_ref
        if out_routes_filter_ref is not None:
          self.out_routes_filter_ref = out_routes_filter_ref
        if version is not None:
          self.version = version

    @property
    def id(self):
        """
        Gets the id of this EdgeBgpNeighbor.
        The unique id of this BGP neighbor. On updates, the id is required for the object, while for create a new id will be generated. This id is not a VCD URN. 

        :return: The id of this EdgeBgpNeighbor.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeBgpNeighbor.
        The unique id of this BGP neighbor. On updates, the id is required for the object, while for create a new id will be generated. This id is not a VCD URN. 

        :param id: The id of this EdgeBgpNeighbor.
        :type: str
        """

        self._id = id

    @property
    def neighbor_address(self):
        """
        Gets the neighbor_address of this EdgeBgpNeighbor.
        The IP address of the BGP neighbor. Both IPv4 and IPv6 formats are supported.

        :return: The neighbor_address of this EdgeBgpNeighbor.
        :rtype: str
        """
        return self._neighbor_address

    @neighbor_address.setter
    def neighbor_address(self, neighbor_address):
        """
        Sets the neighbor_address of this EdgeBgpNeighbor.
        The IP address of the BGP neighbor. Both IPv4 and IPv6 formats are supported.

        :param neighbor_address: The neighbor_address of this EdgeBgpNeighbor.
        :type: str
        """
        if neighbor_address is None:
            raise ValueError("Invalid value for `neighbor_address`, must not be `None`")

        self._neighbor_address = neighbor_address

    @property
    def remote_as_number(self):
        """
        Gets the remote_as_number of this EdgeBgpNeighbor.
        The remote AS number of a BGP neighbor in ASPLAIN format.

        :return: The remote_as_number of this EdgeBgpNeighbor.
        :rtype: str
        """
        return self._remote_as_number

    @remote_as_number.setter
    def remote_as_number(self, remote_as_number):
        """
        Sets the remote_as_number of this EdgeBgpNeighbor.
        The remote AS number of a BGP neighbor in ASPLAIN format.

        :param remote_as_number: The remote_as_number of this EdgeBgpNeighbor.
        :type: str
        """
        if remote_as_number is None:
            raise ValueError("Invalid value for `remote_as_number`, must not be `None`")

        self._remote_as_number = remote_as_number

    @property
    def keep_alive_timer(self):
        """
        Gets the keep_alive_timer of this EdgeBgpNeighbor.
        Specifies the time interval (in seconds) between keep alive messages sent to peer.

        :return: The keep_alive_timer of this EdgeBgpNeighbor.
        :rtype: int
        """
        return self._keep_alive_timer

    @keep_alive_timer.setter
    def keep_alive_timer(self, keep_alive_timer):
        """
        Sets the keep_alive_timer of this EdgeBgpNeighbor.
        Specifies the time interval (in seconds) between keep alive messages sent to peer.

        :param keep_alive_timer: The keep_alive_timer of this EdgeBgpNeighbor.
        :type: int
        """
        if keep_alive_timer is not None and keep_alive_timer > 65535:
            raise ValueError("Invalid value for `keep_alive_timer`, must be a value less than or equal to `65535`")
        if keep_alive_timer is not None and keep_alive_timer < 1:
            raise ValueError("Invalid value for `keep_alive_timer`, must be a value greater than or equal to `1`")

        self._keep_alive_timer = keep_alive_timer

    @property
    def hold_down_timer(self):
        """
        Gets the hold_down_timer of this EdgeBgpNeighbor.
        Specifies the time interval (in seconds) before declaring a peer dead.

        :return: The hold_down_timer of this EdgeBgpNeighbor.
        :rtype: int
        """
        return self._hold_down_timer

    @hold_down_timer.setter
    def hold_down_timer(self, hold_down_timer):
        """
        Sets the hold_down_timer of this EdgeBgpNeighbor.
        Specifies the time interval (in seconds) before declaring a peer dead.

        :param hold_down_timer: The hold_down_timer of this EdgeBgpNeighbor.
        :type: int
        """
        if hold_down_timer is not None and hold_down_timer > 65535:
            raise ValueError("Invalid value for `hold_down_timer`, must be a value less than or equal to `65535`")
        if hold_down_timer is not None and hold_down_timer < 1:
            raise ValueError("Invalid value for `hold_down_timer`, must be a value greater than or equal to `1`")

        self._hold_down_timer = hold_down_timer

    @property
    def graceful_restart_mode(self):
        """
        Gets the graceful_restart_mode of this EdgeBgpNeighbor.
        Currently configured graceful restart configuration mode. Default is HELPER_ONLY.

        :return: The graceful_restart_mode of this EdgeBgpNeighbor.
        :rtype: GracefulRestartModeTypes
        """
        return self._graceful_restart_mode

    @graceful_restart_mode.setter
    def graceful_restart_mode(self, graceful_restart_mode):
        """
        Sets the graceful_restart_mode of this EdgeBgpNeighbor.
        Currently configured graceful restart configuration mode. Default is HELPER_ONLY.

        :param graceful_restart_mode: The graceful_restart_mode of this EdgeBgpNeighbor.
        :type: GracefulRestartModeTypes
        """

        self._graceful_restart_mode = graceful_restart_mode

    @property
    def bfd(self):
        """
        Gets the bfd of this EdgeBgpNeighbor.
        Specifies the BFD configuration for failure detection. Not specifying a value results in default bahavior. 

        :return: The bfd of this EdgeBgpNeighbor.
        :rtype: EdgeBgpBfdConfig
        """
        return self._bfd

    @bfd.setter
    def bfd(self, bfd):
        """
        Sets the bfd of this EdgeBgpNeighbor.
        Specifies the BFD configuration for failure detection. Not specifying a value results in default bahavior. 

        :param bfd: The bfd of this EdgeBgpNeighbor.
        :type: EdgeBgpBfdConfig
        """

        self._bfd = bfd

    @property
    def allow_as_in(self):
        """
        Gets the allow_as_in of this EdgeBgpNeighbor.
        A flag indicating whether AllowAS-in is enabled or not. This specifies whether BGP neighbors can receive routes with same AS. 

        :return: The allow_as_in of this EdgeBgpNeighbor.
        :rtype: bool
        """
        return self._allow_as_in

    @allow_as_in.setter
    def allow_as_in(self, allow_as_in):
        """
        Sets the allow_as_in of this EdgeBgpNeighbor.
        A flag indicating whether AllowAS-in is enabled or not. This specifies whether BGP neighbors can receive routes with same AS. 

        :param allow_as_in: The allow_as_in of this EdgeBgpNeighbor.
        :type: bool
        """

        self._allow_as_in = allow_as_in

    @property
    def neighbor_password(self):
        """
        Gets the neighbor_password of this EdgeBgpNeighbor.
        Password for BGP neighbor authentication. Empty string (\"\") clears existing password. Not specifying a value will be treated as \"no password\". 

        :return: The neighbor_password of this EdgeBgpNeighbor.
        :rtype: str
        """
        return self._neighbor_password

    @neighbor_password.setter
    def neighbor_password(self, neighbor_password):
        """
        Sets the neighbor_password of this EdgeBgpNeighbor.
        Password for BGP neighbor authentication. Empty string (\"\") clears existing password. Not specifying a value will be treated as \"no password\". 

        :param neighbor_password: The neighbor_password of this EdgeBgpNeighbor.
        :type: str
        """
        if neighbor_password is not None and len(neighbor_password) > 20:
            raise ValueError("Invalid value for `neighbor_password`, length must be less than or equal to `20`")

        self._neighbor_password = neighbor_password

    @property
    def ip_address_type_filtering(self):
        """
        Gets the ip_address_type_filtering of this EdgeBgpNeighbor.
        Specifies IP address type based filtering in each direction. Setting the value to 'DISABLED' will disable address family based filtering. 

        :return: The ip_address_type_filtering of this EdgeBgpNeighbor.
        :rtype: str
        """
        return self._ip_address_type_filtering

    @ip_address_type_filtering.setter
    def ip_address_type_filtering(self, ip_address_type_filtering):
        """
        Sets the ip_address_type_filtering of this EdgeBgpNeighbor.
        Specifies IP address type based filtering in each direction. Setting the value to 'DISABLED' will disable address family based filtering. 

        :param ip_address_type_filtering: The ip_address_type_filtering of this EdgeBgpNeighbor.
        :type: str
        """
        allowed_values = ["IPV4", "IPV6", "DISABLED"]
        if ip_address_type_filtering not in allowed_values:
            raise ValueError(
                "Invalid value for `ip_address_type_filtering` ({0}), must be one of {1}"
                .format(ip_address_type_filtering, allowed_values)
            )

        self._ip_address_type_filtering = ip_address_type_filtering

    @property
    def in_routes_filter_ref(self):
        """
        Gets the in_routes_filter_ref of this EdgeBgpNeighbor.
        Specifies route filtering configuration for the BGP neighbor in IN direction. It is the reference to the prefix list, indicating which routes to filter for IN direction. Not specifying a value will be treated as \"no IN route filters\". 

        :return: The in_routes_filter_ref of this EdgeBgpNeighbor.
        :rtype: ExtObjectReference
        """
        return self._in_routes_filter_ref

    @in_routes_filter_ref.setter
    def in_routes_filter_ref(self, in_routes_filter_ref):
        """
        Sets the in_routes_filter_ref of this EdgeBgpNeighbor.
        Specifies route filtering configuration for the BGP neighbor in IN direction. It is the reference to the prefix list, indicating which routes to filter for IN direction. Not specifying a value will be treated as \"no IN route filters\". 

        :param in_routes_filter_ref: The in_routes_filter_ref of this EdgeBgpNeighbor.
        :type: ExtObjectReference
        """

        self._in_routes_filter_ref = in_routes_filter_ref

    @property
    def out_routes_filter_ref(self):
        """
        Gets the out_routes_filter_ref of this EdgeBgpNeighbor.
        Specifies route filtering configuration for the BGP neighbor in OUT direction. It is the reference to the prefix list, indicating which routes to filter for OUT direction. Not specifying a value will be treated as \"no OUT route filters\". 

        :return: The out_routes_filter_ref of this EdgeBgpNeighbor.
        :rtype: ExtObjectReference
        """
        return self._out_routes_filter_ref

    @out_routes_filter_ref.setter
    def out_routes_filter_ref(self, out_routes_filter_ref):
        """
        Sets the out_routes_filter_ref of this EdgeBgpNeighbor.
        Specifies route filtering configuration for the BGP neighbor in OUT direction. It is the reference to the prefix list, indicating which routes to filter for OUT direction. Not specifying a value will be treated as \"no OUT route filters\". 

        :param out_routes_filter_ref: The out_routes_filter_ref of this EdgeBgpNeighbor.
        :type: ExtObjectReference
        """

        self._out_routes_filter_ref = out_routes_filter_ref

    @property
    def version(self):
        """
        Gets the version of this EdgeBgpNeighbor.

        :return: The version of this EdgeBgpNeighbor.
        :rtype: ObjectVersion
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this EdgeBgpNeighbor.

        :param version: The version of this EdgeBgpNeighbor.
        :type: ObjectVersion
        """

        self._version = version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, EdgeBgpNeighbor):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
