# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DistributedPortGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'backing_ref': 'BackingRef',
        'virtual_center': 'EntityReference',
        'vlan': 'str',
        'dv_switch': 'DvSwitch'
    }

    attribute_map = {
        'backing_ref': 'backingRef',
        'virtual_center': 'virtualCenter',
        'vlan': 'vlan',
        'dv_switch': 'dvSwitch'
    }

    def __init__(self, backing_ref=None, virtual_center=None, vlan=None, dv_switch=None):
        """
        DistributedPortGroup - a model defined in Swagger
        """

        self._backing_ref = None
        self._virtual_center = None
        self._vlan = None
        self._dv_switch = None

        if backing_ref is not None:
          self.backing_ref = backing_ref
        if virtual_center is not None:
          self.virtual_center = virtual_center
        if vlan is not None:
          self.vlan = vlan
        if dv_switch is not None:
          self.dv_switch = dv_switch

    @property
    def backing_ref(self):
        """
        Gets the backing_ref of this DistributedPortGroup.
        Contains the backing id and name of the distributed portgroup.

        :return: The backing_ref of this DistributedPortGroup.
        :rtype: BackingRef
        """
        return self._backing_ref

    @backing_ref.setter
    def backing_ref(self, backing_ref):
        """
        Sets the backing_ref of this DistributedPortGroup.
        Contains the backing id and name of the distributed portgroup.

        :param backing_ref: The backing_ref of this DistributedPortGroup.
        :type: BackingRef
        """

        self._backing_ref = backing_ref

    @property
    def virtual_center(self):
        """
        Gets the virtual_center of this DistributedPortGroup.
        The entity reference for the vCenter that contains this distributed portgroup.

        :return: The virtual_center of this DistributedPortGroup.
        :rtype: EntityReference
        """
        return self._virtual_center

    @virtual_center.setter
    def virtual_center(self, virtual_center):
        """
        Sets the virtual_center of this DistributedPortGroup.
        The entity reference for the vCenter that contains this distributed portgroup.

        :param virtual_center: The virtual_center of this DistributedPortGroup.
        :type: EntityReference
        """

        self._virtual_center = virtual_center

    @property
    def vlan(self):
        """
        Gets the vlan of this DistributedPortGroup.
        The VLAN associated with this distributed portgroup. This can be a single number or a numerical range(1-10).

        :return: The vlan of this DistributedPortGroup.
        :rtype: str
        """
        return self._vlan

    @vlan.setter
    def vlan(self, vlan):
        """
        Sets the vlan of this DistributedPortGroup.
        The VLAN associated with this distributed portgroup. This can be a single number or a numerical range(1-10).

        :param vlan: The vlan of this DistributedPortGroup.
        :type: str
        """

        self._vlan = vlan

    @property
    def dv_switch(self):
        """
        Gets the dv_switch of this DistributedPortGroup.
        The distributed virtual switch on which this distributed virtual portgroup was created.

        :return: The dv_switch of this DistributedPortGroup.
        :rtype: DvSwitch
        """
        return self._dv_switch

    @dv_switch.setter
    def dv_switch(self, dv_switch):
        """
        Sets the dv_switch of this DistributedPortGroup.
        The distributed virtual switch on which this distributed virtual portgroup was created.

        :param dv_switch: The dv_switch of this DistributedPortGroup.
        :type: DvSwitch
        """

        self._dv_switch = dv_switch

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DistributedPortGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
