# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DefinedEntityType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'nss': 'str',
        'version': 'str',
        'inherited_version': 'str',
        'external_id': 'str',
        'schema': 'dict(str, object)',
        'vendor': 'str',
        'interfaces': 'list[str]',
        'hooks': 'dict(str, object)',
        'readonly': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'nss': 'nss',
        'version': 'version',
        'inherited_version': 'inheritedVersion',
        'external_id': 'externalId',
        'schema': 'schema',
        'vendor': 'vendor',
        'interfaces': 'interfaces',
        'hooks': 'hooks',
        'readonly': 'readonly'
    }

    def __init__(self, id=None, name=None, description=None, nss=None, version=None, inherited_version=None, external_id=None, schema=None, vendor=None, interfaces=None, hooks=None, readonly=None):
        """
        DefinedEntityType - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._nss = None
        self._version = None
        self._inherited_version = None
        self._external_id = None
        self._schema = None
        self._vendor = None
        self._interfaces = None
        self._hooks = None
        self._readonly = None

        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if nss is not None:
          self.nss = nss
        if version is not None:
          self.version = version
        if inherited_version is not None:
          self.inherited_version = inherited_version
        if external_id is not None:
          self.external_id = external_id
        if schema is not None:
          self.schema = schema
        if vendor is not None:
          self.vendor = vendor
        if interfaces is not None:
          self.interfaces = interfaces
        if hooks is not None:
          self.hooks = hooks
        if readonly is not None:
          self.readonly = readonly

    @property
    def id(self):
        """
        Gets the id of this DefinedEntityType.
        The id of the defined entity type in URN format. 

        :return: The id of this DefinedEntityType.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DefinedEntityType.
        The id of the defined entity type in URN format. 

        :param id: The id of this DefinedEntityType.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this DefinedEntityType.
        The name of the defined entity type. 

        :return: The name of this DefinedEntityType.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DefinedEntityType.
        The name of the defined entity type. 

        :param name: The name of this DefinedEntityType.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this DefinedEntityType.
        Description of the defined entity type. 

        :return: The description of this DefinedEntityType.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DefinedEntityType.
        Description of the defined entity type. 

        :param description: The description of this DefinedEntityType.
        :type: str
        """

        self._description = description

    @property
    def nss(self):
        """
        Gets the nss of this DefinedEntityType.
        A unique namespace specific string. The combination of nss and version must be unique. 

        :return: The nss of this DefinedEntityType.
        :rtype: str
        """
        return self._nss

    @nss.setter
    def nss(self, nss):
        """
        Sets the nss of this DefinedEntityType.
        A unique namespace specific string. The combination of nss and version must be unique. 

        :param nss: The nss of this DefinedEntityType.
        :type: str
        """

        self._nss = nss

    @property
    def version(self):
        """
        Gets the version of this DefinedEntityType.
        The version of the defined entity type. The combination of nss and version must be unique. The version string must follow semantic versioning rules. 

        :return: The version of this DefinedEntityType.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this DefinedEntityType.
        The version of the defined entity type. The combination of nss and version must be unique. The version string must follow semantic versioning rules. 

        :param version: The version of this DefinedEntityType.
        :type: str
        """

        self._version = version

    @property
    def inherited_version(self):
        """
        Gets the inherited_version of this DefinedEntityType.
        To be used when creating a new version of a defined entity type. Specifies the version of the type that will be the template for the authorization configuration of a the new version. The Type ACLs and the access requirements of the Type Behaviors of the new version will be copied from those of the inherited version. If the value of this property is '0', then the new type version will not inherit another version and will have the default authorization settings, just like the first version of a new type. 

        :return: The inherited_version of this DefinedEntityType.
        :rtype: str
        """
        return self._inherited_version

    @inherited_version.setter
    def inherited_version(self, inherited_version):
        """
        Sets the inherited_version of this DefinedEntityType.
        To be used when creating a new version of a defined entity type. Specifies the version of the type that will be the template for the authorization configuration of a the new version. The Type ACLs and the access requirements of the Type Behaviors of the new version will be copied from those of the inherited version. If the value of this property is '0', then the new type version will not inherit another version and will have the default authorization settings, just like the first version of a new type. 

        :param inherited_version: The inherited_version of this DefinedEntityType.
        :type: str
        """

        self._inherited_version = inherited_version

    @property
    def external_id(self):
        """
        Gets the external_id of this DefinedEntityType.
        An external entity's id that this definition may apply to. 

        :return: The external_id of this DefinedEntityType.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this DefinedEntityType.
        An external entity's id that this definition may apply to. 

        :param external_id: The external_id of this DefinedEntityType.
        :type: str
        """

        self._external_id = external_id

    @property
    def schema(self):
        """
        Gets the schema of this DefinedEntityType.
        The JSON-Schema valid definition of the defined entity type. If no JSON Schema version is specified, version 4 will be assumed. 

        :return: The schema of this DefinedEntityType.
        :rtype: dict(str, object)
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """
        Sets the schema of this DefinedEntityType.
        The JSON-Schema valid definition of the defined entity type. If no JSON Schema version is specified, version 4 will be assumed. 

        :param schema: The schema of this DefinedEntityType.
        :type: dict(str, object)
        """

        self._schema = schema

    @property
    def vendor(self):
        """
        Gets the vendor of this DefinedEntityType.
        The vendor name. 

        :return: The vendor of this DefinedEntityType.
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """
        Sets the vendor of this DefinedEntityType.
        The vendor name. 

        :param vendor: The vendor of this DefinedEntityType.
        :type: str
        """

        self._vendor = vendor

    @property
    def interfaces(self):
        """
        Gets the interfaces of this DefinedEntityType.
        List of interface ids that this defined entity type is referenced by. 

        :return: The interfaces of this DefinedEntityType.
        :rtype: list[str]
        """
        return self._interfaces

    @interfaces.setter
    def interfaces(self, interfaces):
        """
        Sets the interfaces of this DefinedEntityType.
        List of interface ids that this defined entity type is referenced by. 

        :param interfaces: The interfaces of this DefinedEntityType.
        :type: list[str]
        """

        self._interfaces = interfaces

    @property
    def hooks(self):
        """
        Gets the hooks of this DefinedEntityType.
        A mapping defining which behaviors should be invoked upon specific lifecycle events, like PostCreate, PostUpdate, PreDelete. For example: \"hooks\": { \"PostCreate\": \"urn:vcloud:behavior-interface:postCreateHook:vendorA:containerCluster:1.0.0\" } 

        :return: The hooks of this DefinedEntityType.
        :rtype: dict(str, object)
        """
        return self._hooks

    @hooks.setter
    def hooks(self, hooks):
        """
        Sets the hooks of this DefinedEntityType.
        A mapping defining which behaviors should be invoked upon specific lifecycle events, like PostCreate, PostUpdate, PreDelete. For example: \"hooks\": { \"PostCreate\": \"urn:vcloud:behavior-interface:postCreateHook:vendorA:containerCluster:1.0.0\" } 

        :param hooks: The hooks of this DefinedEntityType.
        :type: dict(str, object)
        """

        self._hooks = hooks

    @property
    def readonly(self):
        """
        Gets the readonly of this DefinedEntityType.
        True if the entity type cannot be modified.

        :return: The readonly of this DefinedEntityType.
        :rtype: bool
        """
        return self._readonly

    @readonly.setter
    def readonly(self, readonly):
        """
        Sets the readonly of this DefinedEntityType.
        True if the entity type cannot be modified.

        :param readonly: The readonly of this DefinedEntityType.
        :type: bool
        """

        self._readonly = readonly

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DefinedEntityType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
