# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Connection(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'host': 'str',
        'port': 'int',
        'secure': 'bool',
        'timeout': 'int',
        'hostname_verification_algorithm': 'str',
        'proxy_connection': 'ProxyConnection'
    }

    attribute_map = {
        'host': 'host',
        'port': 'port',
        'secure': 'secure',
        'timeout': 'timeout',
        'hostname_verification_algorithm': 'hostnameVerificationAlgorithm',
        'proxy_connection': 'proxyConnection'
    }

    def __init__(self, host=None, port=None, secure=True, timeout=10, hostname_verification_algorithm=None, proxy_connection=None):
        """
        Connection - a model defined in Swagger
        """

        self._host = None
        self._port = None
        self._secure = None
        self._timeout = None
        self._hostname_verification_algorithm = None
        self._proxy_connection = None

        self.host = host
        self.port = port
        if secure is not None:
          self.secure = secure
        if timeout is not None:
          self.timeout = timeout
        if hostname_verification_algorithm is not None:
          self.hostname_verification_algorithm = hostname_verification_algorithm
        if proxy_connection is not None:
          self.proxy_connection = proxy_connection

    @property
    def host(self):
        """
        Gets the host of this Connection.
        The host (or IP address) to connect to.

        :return: The host of this Connection.
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """
        Sets the host of this Connection.
        The host (or IP address) to connect to.

        :param host: The host of this Connection.
        :type: str
        """
        if host is None:
            raise ValueError("Invalid value for `host`, must not be `None`")
        if host is not None and len(host) > 256:
            raise ValueError("Invalid value for `host`, length must be less than or equal to `256`")

        self._host = host

    @property
    def port(self):
        """
        Gets the port of this Connection.
        The port to use when connecting.

        :return: The port of this Connection.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this Connection.
        The port to use when connecting.

        :param port: The port of this Connection.
        :type: int
        """
        if port is None:
            raise ValueError("Invalid value for `port`, must not be `None`")

        self._port = port

    @property
    def secure(self):
        """
        Gets the secure of this Connection.
        If the connection should use https.

        :return: The secure of this Connection.
        :rtype: bool
        """
        return self._secure

    @secure.setter
    def secure(self, secure):
        """
        Sets the secure of this Connection.
        If the connection should use https.

        :param secure: The secure of this Connection.
        :type: bool
        """

        self._secure = secure

    @property
    def timeout(self):
        """
        Gets the timeout of this Connection.
        Maximum time (in seconds) any step in the test should wait for a response.

        :return: The timeout of this Connection.
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """
        Sets the timeout of this Connection.
        Maximum time (in seconds) any step in the test should wait for a response.

        :param timeout: The timeout of this Connection.
        :type: int
        """

        self._timeout = timeout

    @property
    def hostname_verification_algorithm(self):
        """
        Gets the hostname_verification_algorithm of this Connection.
        Endpoint/Hostname verification algorithm to be used during SSL/TLS/DTLS handshaking. Their values are as follows: <ul>   <li>     <em>HTTPS</em>: use https hostname verification algorithm as described in     <a href=\"https://datatracker.ietf.org/doc/html/rfc2818\">RFC2818</a>   </li>   <li>     <em>LDAPS</em>: use ldaps hostname verification algorithm as described in     <a href=\"https://datatracker.ietf.org/doc/html/rfc2830\">RFC2830</a>   </li> </ul> When this field is not set, the default value <em>null</em> indicates no hostname verification will be performed. 

        :return: The hostname_verification_algorithm of this Connection.
        :rtype: str
        """
        return self._hostname_verification_algorithm

    @hostname_verification_algorithm.setter
    def hostname_verification_algorithm(self, hostname_verification_algorithm):
        """
        Sets the hostname_verification_algorithm of this Connection.
        Endpoint/Hostname verification algorithm to be used during SSL/TLS/DTLS handshaking. Their values are as follows: <ul>   <li>     <em>HTTPS</em>: use https hostname verification algorithm as described in     <a href=\"https://datatracker.ietf.org/doc/html/rfc2818\">RFC2818</a>   </li>   <li>     <em>LDAPS</em>: use ldaps hostname verification algorithm as described in     <a href=\"https://datatracker.ietf.org/doc/html/rfc2830\">RFC2830</a>   </li> </ul> When this field is not set, the default value <em>null</em> indicates no hostname verification will be performed. 

        :param hostname_verification_algorithm: The hostname_verification_algorithm of this Connection.
        :type: str
        """

        self._hostname_verification_algorithm = hostname_verification_algorithm

    @property
    def proxy_connection(self):
        """
        Gets the proxy_connection of this Connection.

        :return: The proxy_connection of this Connection.
        :rtype: ProxyConnection
        """
        return self._proxy_connection

    @proxy_connection.setter
    def proxy_connection(self, proxy_connection):
        """
        Sets the proxy_connection of this Connection.

        :param proxy_connection: The proxy_connection of this Connection.
        :type: ProxyConnection
        """

        self._proxy_connection = proxy_connection

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Connection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
