# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class AuditTrailEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'event_id': 'str',
        'description': 'str',
        'operating_org': 'EntityReference',
        'user': 'EntityReference',
        'event_entity': 'EntityReference',
        'task_id': 'str',
        'task_cell_id': 'str',
        'cell_id': 'str',
        'event_type': 'str',
        'service_namespace': 'str',
        'event_status': 'str',
        'timestamp': 'datetime',
        'external': 'bool',
        'additional_properties': 'object'
    }

    attribute_map = {
        'event_id': 'eventId',
        'description': 'description',
        'operating_org': 'operatingOrg',
        'user': 'user',
        'event_entity': 'eventEntity',
        'task_id': 'taskId',
        'task_cell_id': 'taskCellId',
        'cell_id': 'cellId',
        'event_type': 'eventType',
        'service_namespace': 'serviceNamespace',
        'event_status': 'eventStatus',
        'timestamp': 'timestamp',
        'external': 'external',
        'additional_properties': 'additionalProperties'
    }

    def __init__(self, event_id=None, description=None, operating_org=None, user=None, event_entity=None, task_id=None, task_cell_id=None, cell_id=None, event_type=None, service_namespace=None, event_status=None, timestamp=None, external=None, additional_properties=None):
        """
        AuditTrailEvent - a model defined in Swagger
        """

        self._event_id = None
        self._description = None
        self._operating_org = None
        self._user = None
        self._event_entity = None
        self._task_id = None
        self._task_cell_id = None
        self._cell_id = None
        self._event_type = None
        self._service_namespace = None
        self._event_status = None
        self._timestamp = None
        self._external = None
        self._additional_properties = None

        if event_id is not None:
          self.event_id = event_id
        if description is not None:
          self.description = description
        if operating_org is not None:
          self.operating_org = operating_org
        if user is not None:
          self.user = user
        if event_entity is not None:
          self.event_entity = event_entity
        if task_id is not None:
          self.task_id = task_id
        if task_cell_id is not None:
          self.task_cell_id = task_cell_id
        if cell_id is not None:
          self.cell_id = cell_id
        if event_type is not None:
          self.event_type = event_type
        if service_namespace is not None:
          self.service_namespace = service_namespace
        if event_status is not None:
          self.event_status = event_status
        if timestamp is not None:
          self.timestamp = timestamp
        if external is not None:
          self.external = external
        if additional_properties is not None:
          self.additional_properties = additional_properties

    @property
    def event_id(self):
        """
        Gets the event_id of this AuditTrailEvent.

        :return: The event_id of this AuditTrailEvent.
        :rtype: str
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id):
        """
        Sets the event_id of this AuditTrailEvent.

        :param event_id: The event_id of this AuditTrailEvent.
        :type: str
        """

        self._event_id = event_id

    @property
    def description(self):
        """
        Gets the description of this AuditTrailEvent.

        :return: The description of this AuditTrailEvent.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AuditTrailEvent.

        :param description: The description of this AuditTrailEvent.
        :type: str
        """

        self._description = description

    @property
    def operating_org(self):
        """
        Gets the operating_org of this AuditTrailEvent.

        :return: The operating_org of this AuditTrailEvent.
        :rtype: EntityReference
        """
        return self._operating_org

    @operating_org.setter
    def operating_org(self, operating_org):
        """
        Sets the operating_org of this AuditTrailEvent.

        :param operating_org: The operating_org of this AuditTrailEvent.
        :type: EntityReference
        """

        self._operating_org = operating_org

    @property
    def user(self):
        """
        Gets the user of this AuditTrailEvent.

        :return: The user of this AuditTrailEvent.
        :rtype: EntityReference
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this AuditTrailEvent.

        :param user: The user of this AuditTrailEvent.
        :type: EntityReference
        """

        self._user = user

    @property
    def event_entity(self):
        """
        Gets the event_entity of this AuditTrailEvent.

        :return: The event_entity of this AuditTrailEvent.
        :rtype: EntityReference
        """
        return self._event_entity

    @event_entity.setter
    def event_entity(self, event_entity):
        """
        Sets the event_entity of this AuditTrailEvent.

        :param event_entity: The event_entity of this AuditTrailEvent.
        :type: EntityReference
        """

        self._event_entity = event_entity

    @property
    def task_id(self):
        """
        Gets the task_id of this AuditTrailEvent.

        :return: The task_id of this AuditTrailEvent.
        :rtype: str
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """
        Sets the task_id of this AuditTrailEvent.

        :param task_id: The task_id of this AuditTrailEvent.
        :type: str
        """

        self._task_id = task_id

    @property
    def task_cell_id(self):
        """
        Gets the task_cell_id of this AuditTrailEvent.

        :return: The task_cell_id of this AuditTrailEvent.
        :rtype: str
        """
        return self._task_cell_id

    @task_cell_id.setter
    def task_cell_id(self, task_cell_id):
        """
        Sets the task_cell_id of this AuditTrailEvent.

        :param task_cell_id: The task_cell_id of this AuditTrailEvent.
        :type: str
        """

        self._task_cell_id = task_cell_id

    @property
    def cell_id(self):
        """
        Gets the cell_id of this AuditTrailEvent.

        :return: The cell_id of this AuditTrailEvent.
        :rtype: str
        """
        return self._cell_id

    @cell_id.setter
    def cell_id(self, cell_id):
        """
        Sets the cell_id of this AuditTrailEvent.

        :param cell_id: The cell_id of this AuditTrailEvent.
        :type: str
        """

        self._cell_id = cell_id

    @property
    def event_type(self):
        """
        Gets the event_type of this AuditTrailEvent.

        :return: The event_type of this AuditTrailEvent.
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """
        Sets the event_type of this AuditTrailEvent.

        :param event_type: The event_type of this AuditTrailEvent.
        :type: str
        """

        self._event_type = event_type

    @property
    def service_namespace(self):
        """
        Gets the service_namespace of this AuditTrailEvent.

        :return: The service_namespace of this AuditTrailEvent.
        :rtype: str
        """
        return self._service_namespace

    @service_namespace.setter
    def service_namespace(self, service_namespace):
        """
        Sets the service_namespace of this AuditTrailEvent.

        :param service_namespace: The service_namespace of this AuditTrailEvent.
        :type: str
        """

        self._service_namespace = service_namespace

    @property
    def event_status(self):
        """
        Gets the event_status of this AuditTrailEvent.

        :return: The event_status of this AuditTrailEvent.
        :rtype: str
        """
        return self._event_status

    @event_status.setter
    def event_status(self, event_status):
        """
        Sets the event_status of this AuditTrailEvent.

        :param event_status: The event_status of this AuditTrailEvent.
        :type: str
        """

        self._event_status = event_status

    @property
    def timestamp(self):
        """
        Gets the timestamp of this AuditTrailEvent.

        :return: The timestamp of this AuditTrailEvent.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this AuditTrailEvent.

        :param timestamp: The timestamp of this AuditTrailEvent.
        :type: datetime
        """

        self._timestamp = timestamp

    @property
    def external(self):
        """
        Gets the external of this AuditTrailEvent.

        :return: The external of this AuditTrailEvent.
        :rtype: bool
        """
        return self._external

    @external.setter
    def external(self, external):
        """
        Sets the external of this AuditTrailEvent.

        :param external: The external of this AuditTrailEvent.
        :type: bool
        """

        self._external = external

    @property
    def additional_properties(self):
        """
        Gets the additional_properties of this AuditTrailEvent.

        :return: The additional_properties of this AuditTrailEvent.
        :rtype: object
        """
        return self._additional_properties

    @additional_properties.setter
    def additional_properties(self, additional_properties):
        """
        Sets the additional_properties of this AuditTrailEvent.

        :param additional_properties: The additional_properties of this AuditTrailEvent.
        :type: object
        """

        self._additional_properties = additional_properties

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AuditTrailEvent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
