# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class AdvisoryDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'target_id': 'str',
        'message': 'str',
        'priority': 'str',
        'display_start': 'datetime',
        'display_end': 'datetime',
        'source': 'str'
    }

    attribute_map = {
        'id': 'id',
        'target_id': 'targetId',
        'message': 'message',
        'priority': 'priority',
        'display_start': 'displayStart',
        'display_end': 'displayEnd',
        'source': 'source'
    }

    def __init__(self, id=None, target_id=None, message=None, priority='NOTICE', display_start=None, display_end=None, source=None):
        """
        AdvisoryDefinition - a model defined in Swagger
        """

        self._id = None
        self._target_id = None
        self._message = None
        self._priority = None
        self._display_start = None
        self._display_end = None
        self._source = None

        if id is not None:
          self.id = id
        if target_id is not None:
          self.target_id = target_id
        if message is not None:
          self.message = message
        if priority is not None:
          self.priority = priority
        if display_start is not None:
          self.display_start = display_start
        if display_end is not None:
          self.display_end = display_end
        if source is not None:
          self.source = source

    @property
    def id(self):
        """
        Gets the id of this AdvisoryDefinition.
        A unique identifier for the advisory (read-only).

        :return: The id of this AdvisoryDefinition.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AdvisoryDefinition.
        A unique identifier for the advisory (read-only).

        :param id: The id of this AdvisoryDefinition.
        :type: str
        """

        self._id = id

    @property
    def target_id(self):
        """
        Gets the target_id of this AdvisoryDefinition.
        The id reference to the target entity this advisory is for.

        :return: The target_id of this AdvisoryDefinition.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this AdvisoryDefinition.
        The id reference to the target entity this advisory is for.

        :param target_id: The target_id of this AdvisoryDefinition.
        :type: str
        """

        self._target_id = target_id

    @property
    def message(self):
        """
        Gets the message of this AdvisoryDefinition.
        A localized message for this advisory.

        :return: The message of this AdvisoryDefinition.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this AdvisoryDefinition.
        A localized message for this advisory.

        :param message: The message of this AdvisoryDefinition.
        :type: str
        """
        if message is not None and len(message) > 512:
            raise ValueError("Invalid value for `message`, length must be less than or equal to `512`")

        self._message = message

    @property
    def priority(self):
        """
        Gets the priority of this AdvisoryDefinition.
        Priority for an advisory that indicates the level of urgency. These priorities are listed in ascending sort order. <ul>   <li>     <em>MANDATORY</em>: A mandatory message which is always displayed;     these advisories cannot be snoozed or dismissed (see documentation     on displayStart and displayEnd)   </li>   <li>     <em>CRITICAL</em>: A high priority, potentially actionable message which can be     snoozed or dismissed   </li>   <li>     <em>IMPORTANT</em>: A potentially actionable message which can be snoozed or dismissed   </li>   <li>     <em>NOTICE</em>: An informational message which can be dismissed (but not snoozed)   </li> </ul> 

        :return: The priority of this AdvisoryDefinition.
        :rtype: str
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this AdvisoryDefinition.
        Priority for an advisory that indicates the level of urgency. These priorities are listed in ascending sort order. <ul>   <li>     <em>MANDATORY</em>: A mandatory message which is always displayed;     these advisories cannot be snoozed or dismissed (see documentation     on displayStart and displayEnd)   </li>   <li>     <em>CRITICAL</em>: A high priority, potentially actionable message which can be     snoozed or dismissed   </li>   <li>     <em>IMPORTANT</em>: A potentially actionable message which can be snoozed or dismissed   </li>   <li>     <em>NOTICE</em>: An informational message which can be dismissed (but not snoozed)   </li> </ul> 

        :param priority: The priority of this AdvisoryDefinition.
        :type: str
        """

        self._priority = priority

    @property
    def display_start(self):
        """
        Gets the display_start of this AdvisoryDefinition.
        The ISO-8601 timestamp from which this advisory is applicable. Defaults to the server's current time if unspecified. If permissible, users may update this value to a time in the future to snooze this advisory. 

        :return: The display_start of this AdvisoryDefinition.
        :rtype: datetime
        """
        return self._display_start

    @display_start.setter
    def display_start(self, display_start):
        """
        Sets the display_start of this AdvisoryDefinition.
        The ISO-8601 timestamp from which this advisory is applicable. Defaults to the server's current time if unspecified. If permissible, users may update this value to a time in the future to snooze this advisory. 

        :param display_start: The display_start of this AdvisoryDefinition.
        :type: datetime
        """

        self._display_start = display_start

    @property
    def display_end(self):
        """
        Gets the display_end of this AdvisoryDefinition.
        The ISO-8601 timestamp representing when this advisory is no longer applicable. If permissible, users may update this value to a time in the past to dismiss this advisory. The displayEnd timestamp must be >= displayStart. 

        :return: The display_end of this AdvisoryDefinition.
        :rtype: datetime
        """
        return self._display_end

    @display_end.setter
    def display_end(self, display_end):
        """
        Sets the display_end of this AdvisoryDefinition.
        The ISO-8601 timestamp representing when this advisory is no longer applicable. If permissible, users may update this value to a time in the past to dismiss this advisory. The displayEnd timestamp must be >= displayStart. 

        :param display_end: The display_end of this AdvisoryDefinition.
        :type: datetime
        """

        self._display_end = display_end

    @property
    def source(self):
        """
        Gets the source of this AdvisoryDefinition.
        Represents where the advisory is being generated from. This is a read-only field. Can be of type USER or INTERNAL. 

        :return: The source of this AdvisoryDefinition.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this AdvisoryDefinition.
        Represents where the advisory is being generated from. This is a read-only field. Can be of type USER or INTERNAL. 

        :param source: The source of this AdvisoryDefinition.
        :type: str
        """

        self._source = source

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AdvisoryDefinition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
