# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import models into model package
from .access_control_grant import AccessControlGrant
from .accessible_location import AccessibleLocation
from .advisory import Advisory
from .allocated_ip_address import AllocatedIpAddress
from .allocated_ip_address_allocation_type import AllocatedIpAddressAllocationType
from .allowed_origin import AllowedOrigin
from .application_port_list import ApplicationPortList
from .application_port_profile_scope_type import ApplicationPortProfileScopeType
from .application_ports_protocol_type import ApplicationPortsProtocolType
from .assigned_quota_policy import AssignedQuotaPolicy
from .association import Association
from .audit_trail_event import AuditTrailEvent
from .available_ip_pool_subnet import AvailableIpPoolSubnet
from .available_ip_pool_subnets import AvailableIpPoolSubnets
from .backing_network_type import BackingNetworkType
from .backing_ref import BackingRef
from .behavior import Behavior
from .behavior_access import BehaviorAccess
from .behavior_invocation import BehaviorInvocation
from .capability import Capability
from .capability_category import CapabilityCategory
from .capability_value_type import CapabilityValueType
from .cell import Cell
from .certificate_library_item import CertificateLibraryItem
from .common_nsx_t_router_fields import CommonNsxTRouterFields
from .config import Config
from .connection import Connection
from .connector_initiation_mode import ConnectorInitiationMode
from .constraint import Constraint
from .create_custom_entity_type_action import CreateCustomEntityTypeAction
from .custom_entities import CustomEntities
from .custom_entity import CustomEntity
from .custom_entity_type import CustomEntityType
from .custom_entity_type_action import CustomEntityTypeAction
from .custom_entity_type_actions import CustomEntityTypeActions
from .decorator import Decorator
from .defined_entity import DefinedEntity
from .defined_entity_type import DefinedEntityType
from .defined_interface import DefinedInterface
from .df_policy_type import DfPolicyType
from .dfw_policies import DfwPolicies
from .dfw_policy import DfwPolicy
from .dfw_rules import DfwRules
from .dh_group_type import DhGroupType
from .distributed_port_group import DistributedPortGroup
from .dpd_config import DpdConfig
from .dv_switch import DvSwitch
from .dvpg_properties import DvpgProperties
from .dvpg_property import DvpgProperty
from .edge_bgp_bfd_config import EdgeBgpBfdConfig
from .edge_bgp_config import EdgeBgpConfig
from .edge_bgp_graceful_restart_config import EdgeBgpGracefulRestartConfig
from .edge_bgp_neighbor import EdgeBgpNeighbor
from .edge_bgp_neighbors import EdgeBgpNeighbors
from .edge_cluster import EdgeCluster
from .edge_dns_config import EdgeDnsConfig
from .edge_gateway_backing import EdgeGatewayBacking
from .edge_gateway_load_balancer_config import EdgeGatewayLoadBalancerConfig
from .edge_gateway_subnets import EdgeGatewaySubnets
from .edge_gateway_type import EdgeGatewayType
from .edge_gateway_uplink import EdgeGatewayUplink
from .edge_ip_sec_vpn_tunnel import EdgeIpSecVpnTunnel
from .edge_ip_sec_vpn_tunnel_connection_properties import EdgeIpSecVpnTunnelConnectionProperties
from .edge_ip_sec_vpn_tunnel_statistics import EdgeIpSecVpnTunnelStatistics
from .edge_ip_sec_vpn_tunnel_status import EdgeIpSecVpnTunnelStatus
from .edge_l2_vpn_stretched_network import EdgeL2VpnStretchedNetwork
from .edge_l2_vpn_tunnel import EdgeL2VpnTunnel
from .edge_l2_vpn_tunnel_statistics import EdgeL2VpnTunnelStatistics
from .edge_l2_vpn_tunnel_status import EdgeL2VpnTunnelStatus
from .edge_load_balancer_analytic_metric import EdgeLoadBalancerAnalyticMetric
from .edge_load_balancer_analytic_metrics import EdgeLoadBalancerAnalyticMetrics
from .edge_load_balancer_analytic_report import EdgeLoadBalancerAnalyticReport
from .edge_load_balancer_analytic_reports import EdgeLoadBalancerAnalyticReports
from .edge_load_balancer_application_profile import EdgeLoadBalancerApplicationProfile
from .edge_load_balancer_health_monitor import EdgeLoadBalancerHealthMonitor
from .edge_load_balancer_metric_data import EdgeLoadBalancerMetricData
from .edge_load_balancer_metric_summary_stats import EdgeLoadBalancerMetricSummaryStats
from .edge_load_balancer_persistence_profile import EdgeLoadBalancerPersistenceProfile
from .edge_load_balancer_pool_member import EdgeLoadBalancerPoolMember
from .edge_load_balancer_service_port import EdgeLoadBalancerServicePort
from .edge_load_balancer_tcp_udp_profile import EdgeLoadBalancerTcpUdpProfile
from .edge_nat_rule import EdgeNatRule
from .edge_prefix_list import EdgePrefixList
from .edge_prefix_list_entry import EdgePrefixListEntry
from .edge_prefix_lists import EdgePrefixLists
from .egress_point import EgressPoint
from .egress_point_reference import EgressPointReference
from .egress_points import EgressPoints
from .email_settings import EmailSettings
from .entity_reference import EntityReference
from .entity_security_tags import EntitySecurityTags
from .entity_state import EntityState
from .error import Error
from .execution_context import ExecutionContext
from .execution_state import ExecutionState
from .execution_summary import ExecutionSummary
from .ext_object_reference import ExtObjectReference
from .extension_point import ExtensionPoint
from .extension_point_summary import ExtensionPointSummary
from .external_network_backing import ExternalNetworkBacking
from .external_network_backing_type import ExternalNetworkBackingType
from .external_network_backings import ExternalNetworkBackings
from .external_service import ExternalService
from .firewall_group_associated_vm import FirewallGroupAssociatedVM
from .firewall_group_scope import FirewallGroupScope
from .firewall_group_type import FirewallGroupType
from .firewall_rule import FirewallRule
from .firewall_rule_action import FirewallRuleAction
from .firewall_rule_direction import FirewallRuleDirection
from .firewall_rule_ip_protocol import FirewallRuleIpProtocol
from .gateway_edge_cluster_config import GatewayEdgeClusterConfig
from .gateway_edge_cluster_reference import GatewayEdgeClusterReference
from .gateway_used_ip_address import GatewayUsedIpAddress
from .gateway_used_ip_address_category import GatewayUsedIpAddressCategory
from .graceful_restart_mode_types import GracefulRestartModeTypes
from .hardware_versions import HardwareVersions
from .ike_config import IkeConfig
from .ike_digest_algorithm_type import IkeDigestAlgorithmType
from .ike_encryption_algorithm_type import IkeEncryptionAlgorithmType
from .ike_service_status import IkeServiceStatus
from .ike_status import IkeStatus
from .ike_version_type import IkeVersionType
from .ip_range import IpRange
from .ip_ranges import IpRanges
from .ldap_connection_test_result import LdapConnectionTestResult
from .ldap_group_attributes_type import LdapGroupAttributesType
from .ldap_settings import LdapSettings
from .ldap_settings_test_result import LdapSettingsTestResult
from .ldap_test_result import LdapTestResult
from .ldap_user_attributes_type import LdapUserAttributesType
from .link import Link
from .load_balancer_cloud_backing import LoadBalancerCloudBacking
from .load_balancer_controller import LoadBalancerController
from .load_balancer_service_engine_group_assignment import LoadBalancerServiceEngineGroupAssignment
from .load_balancer_service_engine_group_backing import LoadBalancerServiceEngineGroupBacking
from .local_endpoint import LocalEndpoint
from .logical_vm_group import LogicalVmGroup
from .nat_rule_type import NatRuleType
from .network import Network
from .network_context_profile_attribute import NetworkContextProfileAttribute
from .network_context_profile_attributes import NetworkContextProfileAttributes
from .network_context_profile_scope_type import NetworkContextProfileScopeType
from .network_context_profile_sub_attribute import NetworkContextProfileSubAttribute
from .network_pool_backing import NetworkPoolBacking
from .network_pool_backing_type import NetworkPoolBackingType
from .network_provider_context import NetworkProviderContext
from .networking_candidate_vdc import NetworkingCandidateVdc
from .networking_object_status import NetworkingObjectStatus
from .networking_object_status_type import NetworkingObjectStatusType
from .nsx_alb_cloud import NsxAlbCloud
from .nsx_alb_service_engine_group import NsxAlbServiceEngineGroup
from .nsx_alb_service_engine_groups import NsxAlbServiceEngineGroups
from .nsx_t_edge_cluster import NsxTEdgeCluster
from .nsx_t_edge_cluster_deployment_type import NsxTEdgeClusterDeploymentType
from .nsx_t_edge_cluster_node_type import NsxTEdgeClusterNodeType
from .nsx_t_edge_clusters import NsxTEdgeClusters
from .nsx_t_transport_zone import NsxTTransportZone
from .nsx_t_transport_zone_type import NsxTTransportZoneType
from .nsx_t_transport_zones import NsxTTransportZones
from .nsx_v_manager import NsxVManager
from .nsx_v_manager_settings import NsxVManagerSettings
from .nsx_v_transport_zone import NsxVTransportZone
from .nsx_v_transport_zone_type import NsxVTransportZoneType
from .nsx_v_transport_zones import NsxVTransportZones
from .nsxt_dns_forwarder_zone_config import NsxtDnsForwarderZoneConfig
from .object_version import ObjectVersion
from .org import Org
from .org_vdc import OrgVdc
from .org_vdc_network_additional_properties import OrgVdcNetworkAdditionalProperties
from .org_vdc_network_status import OrgVdcNetworkStatus
from .org_vdc_storage_policy import OrgVdcStoragePolicy
from .overall_status import OverallStatus
from .page import Page
from .parameter import Parameter
from .parameter_types import ParameterTypes
from .participating_vdc_reference import ParticipatingVdcReference
from .port_group import PortGroup
from .preference import Preference
from .preference_definition import PreferenceDefinition
from .presentation import Presentation
from .presentation_element import PresentationElement
from .presentation_execution import PresentationExecution
from .presentation_executions_list import PresentationExecutionsList
from .presentation_message_info import PresentationMessageInfo
from .probe_result import ProbeResult
from .provider_vdc import ProviderVdc
from .proxy import Proxy
from .proxy_configuration import ProxyConfiguration
from .proxy_connection import ProxyConnection
from .pvdc_compute_policy import PvdcComputePolicy
from .pvdc_compute_policy2 import PvdcComputePolicy2
from .pvdc_storage_policy import PvdcStoragePolicy
from .quota_policy import QuotaPolicy
from .quota_pool_definition import QuotaPoolDefinition
from .quotas import Quotas
from .quotas_quota_pools import QuotasQuotaPools
from .relations import Relations
from .remote_endpoint import RemoteEndpoint
from .resource_pool import ResourcePool
from .resource_pool_kubernetes_config import ResourcePoolKubernetesConfig
from .right import Right
from .rights_category_node import RightsCategoryNode
from .rights_count import RightsCount
from .rights_mapping import RightsMapping
from .route_advertisement import RouteAdvertisement
from .router_component_health import RouterComponentHealth
from .router_component_status import RouterComponentStatus
from .router_connection import RouterConnection
from .router_dns_config import RouterDnsConfig
from .router_health_report import RouterHealthReport
from .slaac_dns_config import SLAACDnsConfig
from .slaac_profile import SLAACProfile
from .sddc import Sddc
from .sddc_endpoint import SddcEndpoint
from .sddc_proxy import SddcProxy
from .sddc_stat import SddcStat
from .sddc_stats import SddcStats
from .security_tag import SecurityTag
from .security_tag_value import SecurityTagValue
from .security_tagged_entity import SecurityTaggedEntity
from .service import Service
from .service_app import ServiceApp
from .service_app_scope import ServiceAppScope
from .service_item import ServiceItem
from .services_edge_cluster import ServicesEdgeCluster
from .session import Session
from .smtp_server_spec import SmtpServerSpec
from .ssl_settings import SslSettings
from .storage_container import StorageContainer
from .storage_policy_settings import StoragePolicySettings
from .storage_policy_supported_entity_type import StoragePolicySupportedEntityType
from .storage_profile import StorageProfile
from .subnet import Subnet
from .subnets import Subnets
from .supported_constraints import SupportedConstraints
from .supported_decorators import SupportedDecorators
from .supported_hardware_version import SupportedHardwareVersion
from .supported_presentation_elements import SupportedPresentationElements
from .test_email_request import TestEmailRequest
from .test_result import TestResult
from .thumbprint_and_algorithm import ThumbprintAndAlgorithm
from .tier0_routers import Tier0Routers
from .token import Token
from .token_parameters import TokenParameters
from .trusted_certificate import TrustedCertificate
from .tunnel_config import TunnelConfig
from .tunnel_digest_algorithm_type import TunnelDigestAlgorithmType
from .tunnel_encryption_algorithm_type import TunnelEncryptionAlgorithmType
from .tunnel_status import TunnelStatus
from .typed_value import TypedValue
from .ui_branding import UiBranding
from .ui_branding_menu_item import UiBrandingMenuItem
from .ui_plugin_metadata import UiPluginMetadata
from .ui_theme import UiTheme
from .universal_egress_routes import UniversalEgressRoutes
from .universal_route import UniversalRoute
from .universal_router import UniversalRouter
from .universal_router_dhcp_config import UniversalRouterDhcpConfig
from .universal_router_dhcp_server import UniversalRouterDhcpServer
from .universal_routers import UniversalRouters
from .universal_routes import UniversalRoutes
from .universal_routing_status import UniversalRoutingStatus
from .unmanaged_virtual_machine import UnmanagedVirtualMachine
from .upload_metadata_response import UploadMetadataResponse
from .upload_spec import UploadSpec
from .url import Url
from .used_ip_address import UsedIpAddress
from .used_ip_address_allocation_type import UsedIpAddressAllocationType
from .user import User
from .user_group import UserGroup
from .v_center_server import VCenterServer
from .v_center_server_metrics import VCenterServerMetrics
from .vro_service_info import VROServiceInfo
from .vcd_user import VcdUser
from .vdc_compute_policy import VdcComputePolicy
from .vdc_compute_policy2 import VdcComputePolicy2
from .vdc_compute_policy_metrics import VdcComputePolicyMetrics
from .vdc_group import VdcGroup
from .vdc_group_entity_status import VdcGroupEntityStatus
from .vdc_group_settings import VdcGroupSettings
from .vdc_network_connection_type import VdcNetworkConnectionType
from .vdc_network_dhcp_config import VdcNetworkDhcpConfig
from .vdc_network_dhcp_pool import VdcNetworkDhcpPool
from .vdc_network_fence_type import VdcNetworkFenceType
from .vdc_network_profile import VdcNetworkProfile
from .vdc_vpn_group import VdcVpnGroup
from .vdc_vpn_group_member import VdcVpnGroupMember
from .virtual_machine_class import VirtualMachineClass
from .vlan_id_range import VlanIdRange
from .vlan_id_ranges import VlanIdRanges
from .vm_criteria import VmCriteria
from .vm_criteria_rule import VmCriteriaRule
from .vmc_sddc import VmcSddc
from .vro_remote_inventory_item import VroRemoteInventoryItem
from .vro_remote_item import VroRemoteItem
from .vro_remote_items import VroRemoteItems
from .vro_remote_plugin_item import VroRemotePluginItem
from .vro_remote_plugin_items import VroRemotePluginItems
from .vro_remote_plugin_type import VroRemotePluginType
from .vro_remote_plugin_types import VroRemotePluginTypes
from .vro_remote_workflow_item import VroRemoteWorkflowItem
from .ws_attribute import WsAttribute
from .ws_parameter import WsParameter
from .ws_workflow_execution import WsWorkflowExecution
from .access_control_grants import AccessControlGrants
from .access_level import AccessLevel
from .access_levels import AccessLevels
from .accessible_locations import AccessibleLocations
from .advisories import Advisories
from .advisory_definition import AdvisoryDefinition
from .advisory_definitions import AdvisoryDefinitions
from .allocated_ip_addresses import AllocatedIpAddresses
from .allowed_origins import AllowedOrigins
from .application_port_profile import ApplicationPortProfile
from .application_port_profiles import ApplicationPortProfiles
from .array_param import ArrayParam
from .audit_trail_events import AuditTrailEvents
from .behavior_accesses import BehaviorAccesses
from .behaviors import Behaviors
from .boolean_param import BooleanParam
from .capabilities import Capabilities
from .cells import Cells
from .certificate_library_items import CertificateLibraryItems
from .certificates import Certificates
from .chooser import Chooser
from .composite_type import CompositeType
from .composite_value import CompositeValue
from .configs import Configs
from .cross_vdc_network import CrossVdcNetwork
from .cross_vdc_networks import CrossVdcNetworks
from .custom_entity_types import CustomEntityTypes
from .custom_validator import CustomValidator
from .date_param import DateParam
from .defined_entities import DefinedEntities
from .defined_entity_types import DefinedEntityTypes
from .defined_interfaces import DefinedInterfaces
from .dfw_rule import DfwRule
from .distributed_port_groups import DistributedPortGroups
from .drop_down import DropDown
from .dv_switches import DvSwitches
from .edge_clusters import EdgeClusters
from .edge_firewall_rule import EdgeFirewallRule
from .edge_firewall_rules import EdgeFirewallRules
from .edge_gateway import EdgeGateway
from .edge_gateway_subnet import EdgeGatewaySubnet
from .edge_gateways import EdgeGateways
from .edge_ip_sec_vpn_tunnels import EdgeIpSecVpnTunnels
from .edge_l2_vpn_tunnels import EdgeL2VpnTunnels
from .edge_load_balancer_pool_common_properties import EdgeLoadBalancerPoolCommonProperties
from .edge_load_balancer_pool_summaries import EdgeLoadBalancerPoolSummaries
from .edge_load_balancer_virtual_service_common_properties import EdgeLoadBalancerVirtualServiceCommonProperties
from .edge_load_balancer_virtual_service_summaries import EdgeLoadBalancerVirtualServiceSummaries
from .edge_nat_rules import EdgeNatRules
from .encrypted_string import EncryptedString
from .enforcing_quota_policy import EnforcingQuotaPolicy
from .entity_references import EntityReferences
from .external_network import ExternalNetwork
from .external_networks import ExternalNetworks
from .external_services import ExternalServices
from .field import Field
from .firewall_group_associated_v_ms import FirewallGroupAssociatedVMs
from .firewall_group_summary import FirewallGroupSummary
from .firewall_groups import FirewallGroups
from .gateway_used_ip_addresses import GatewayUsedIpAddresses
from .global_roles import GlobalRoles
from .group import Group
from .key_value_pair import KeyValuePair
from .load_balancer_cloud import LoadBalancerCloud
from .load_balancer_clouds import LoadBalancerClouds
from .load_balancer_controllers import LoadBalancerControllers
from .load_balancer_service_engine_group import LoadBalancerServiceEngineGroup
from .load_balancer_service_engine_group_assignments import LoadBalancerServiceEngineGroupAssignments
from .load_balancer_service_engine_groups import LoadBalancerServiceEngineGroups
from .logical_vm_groups import LogicalVmGroups
from .mandatory import Mandatory
from .mime_attachment import MimeAttachment
from .multi_line import MultiLine
from .network_context_profile import NetworkContextProfile
from .network_context_profiles import NetworkContextProfiles
from .network_pool_summary import NetworkPoolSummary
from .network_pools_summary import NetworkPoolsSummary
from .networking_candidate_vdcs import NetworkingCandidateVdcs
from .nsx_alb_clouds import NsxAlbClouds
from .number_format import NumberFormat
from .number_param import NumberParam
from .number_range import NumberRange
from .org_vdc_storage_policies import OrgVdcStoragePolicies
from .org_vdcs import OrgVdcs
from .orgs import Orgs
from .port_groups import PortGroups
from .preference_definitions import PreferenceDefinitions
from .preferences import Preferences
from .properties import Properties
from .provider_vdcs import ProviderVdcs
from .proxies import Proxies
from .proxy_configurations import ProxyConfigurations
from .publishable_rights_mapping import PublishableRightsMapping
from .pvdc_compute_policies import PvdcComputePolicies
from .pvdc_compute_policies2 import PvdcComputePolicies2
from .pvdc_storage_policies import PvdcStoragePolicies
from .quota_policies import QuotaPolicies
from .refresh_on_change import RefreshOnChange
from .regex import Regex
from .regexp import Regexp
from .resource_pools import ResourcePools
from .restrict_duplicates import RestrictDuplicates
from .rights import Rights
from .rights_bundles import RightsBundles
from .rights_category_nodes import RightsCategoryNodes
from .role import Role
from .roles import Roles
from .sddc_endpoints import SddcEndpoints
from .sddc_proxies import SddcProxies
from .sddcs import Sddcs
from .sdk_object import SdkObject
from .secure_string import SecureString
from .security_tag_values import SecurityTagValues
from .security_tagged_entities import SecurityTaggedEntities
from .service_apps import ServiceApps
from .service_items import ServiceItems
from .services import Services
from .sessions import Sessions
from .step_info import StepInfo
from .storage_containers import StorageContainers
from .storage_policy_supported_entity_types import StoragePolicySupportedEntityTypes
from .storage_profiles import StorageProfiles
from .string_param import StringParam
from .tier0_router import Tier0Router
from .tokens import Tokens
from .ui_plugin_metadata_response import UiPluginMetadataResponse
from .unmanaged_virtual_machines import UnmanagedVirtualMachines
from .used_ip_addresses import UsedIpAddresses
from .user_groups import UserGroups
from .v_center_servers import VCenterServers
from .vcd_users import VcdUsers
from .vdc_compute_policies import VdcComputePolicies
from .vdc_compute_policies2 import VdcComputePolicies2
from .vdc_groups import VdcGroups
from .vdc_network import VdcNetwork
from .vdc_networks import VdcNetworks
from .vdc_vpn_groups import VdcVpnGroups
from .virtual_machine_classes import VirtualMachineClasses
from .vmc_sddcs import VmcSddcs
from .vro_remote_workflow_items import VroRemoteWorkflowItems
from .vro_workflow_service_item import VroWorkflowServiceItem
from .edge_load_balancer_pool import EdgeLoadBalancerPool
from .edge_load_balancer_pool_summary import EdgeLoadBalancerPoolSummary
from .edge_load_balancer_virtual_service import EdgeLoadBalancerVirtualService
from .edge_load_balancer_virtual_service_summary import EdgeLoadBalancerVirtualServiceSummary
from .firewall_group_details import FirewallGroupDetails
from .global_role import GlobalRole
from .network_pool import NetworkPool
from .primary_field import PrimaryField
from .rights_bundle import RightsBundle
