# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class VroWorkflowExecutionApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def cancel_workflow_execution(self, workflow_id, execution_id, **kwargs):
        """
        Cancel workflow run
        Cancels a workflow run
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cancel_workflow_execution(workflow_id, execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str execution_id: executionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.cancel_workflow_execution_with_http_info(workflow_id, execution_id, **kwargs)
        else:
            (data) = self.cancel_workflow_execution_with_http_info(workflow_id, execution_id, **kwargs)
            return data

    def cancel_workflow_execution_with_http_info(self, workflow_id, execution_id, **kwargs):
        """
        Cancel workflow run
        Cancels a workflow run
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cancel_workflow_execution_with_http_info(workflow_id, execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str execution_id: executionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'execution_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_workflow_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `cancel_workflow_execution`")
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params) or (params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `cancel_workflow_execution`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/executions/{executionId}/state', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_workflow_execution(self, workflow_id, execution_id, **kwargs):
        """
        Delete workflow run
        Deletes a specific workflow run
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workflow_execution(workflow_id, execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str execution_id: executionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_workflow_execution_with_http_info(workflow_id, execution_id, **kwargs)
        else:
            (data) = self.delete_workflow_execution_with_http_info(workflow_id, execution_id, **kwargs)
            return data

    def delete_workflow_execution_with_http_info(self, workflow_id, execution_id, **kwargs):
        """
        Delete workflow run
        Deletes a specific workflow run
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workflow_execution_with_http_info(workflow_id, execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str execution_id: executionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'execution_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workflow_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `delete_workflow_execution`")
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params) or (params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `delete_workflow_execution`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/executions/{executionId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_all_workflow_executions(self, workflow_id, **kwargs):
        """
        Get all executions
        Retrieves all workflow runs for a given workflow
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_workflow_executions(workflow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :return: PresentationExecutionsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_all_workflow_executions_with_http_info(workflow_id, **kwargs)
        else:
            (data) = self.get_all_workflow_executions_with_http_info(workflow_id, **kwargs)
            return data

    def get_all_workflow_executions_with_http_info(self, workflow_id, **kwargs):
        """
        Get all executions
        Retrieves all workflow runs for a given workflow
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_workflow_executions_with_http_info(workflow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :return: PresentationExecutionsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_workflow_executions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_all_workflow_executions`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/executions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PresentationExecutionsList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_parameter_types(self, **kwargs):
        """
        This endpoint will not produce results. It is a placeholder to enforce code generation of ParameterTypes.
        This endpoint will not produce results. It is a placeholder to enforce code generation of ParameterTypes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_parameter_types(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ParameterTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_parameter_types_with_http_info(**kwargs)
        else:
            (data) = self.get_parameter_types_with_http_info(**kwargs)
            return data

    def get_parameter_types_with_http_info(self, **kwargs):
        """
        This endpoint will not produce results. It is a placeholder to enforce code generation of ParameterTypes.
        This endpoint will not produce results. It is a placeholder to enforce code generation of ParameterTypes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_parameter_types_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ParameterTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_parameter_types" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/parameterTypes', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ParameterTypes',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_supported_decorators(self, **kwargs):
        """
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedDecorators.
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedDecorators.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_supported_decorators(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SupportedDecorators
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_supported_decorators_with_http_info(**kwargs)
        else:
            (data) = self.get_supported_decorators_with_http_info(**kwargs)
            return data

    def get_supported_decorators_with_http_info(self, **kwargs):
        """
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedDecorators.
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedDecorators.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_supported_decorators_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SupportedDecorators
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_supported_decorators" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/decorators', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SupportedDecorators',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_supported_presentation_elements(self, **kwargs):
        """
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedPresentationElements.
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedPresentationElements.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_supported_presentation_elements(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SupportedPresentationElements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_supported_presentation_elements_with_http_info(**kwargs)
        else:
            (data) = self.get_supported_presentation_elements_with_http_info(**kwargs)
            return data

    def get_supported_presentation_elements_with_http_info(self, **kwargs):
        """
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedPresentationElements.
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedPresentationElements.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_supported_presentation_elements_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SupportedPresentationElements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_supported_presentation_elements" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/presentationElements', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SupportedPresentationElements',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_supportedconstraints(self, **kwargs):
        """
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedConstraints.
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedConstraints.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_supportedconstraints(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SupportedConstraints
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_supportedconstraints_with_http_info(**kwargs)
        else:
            (data) = self.get_supportedconstraints_with_http_info(**kwargs)
            return data

    def get_supportedconstraints_with_http_info(self, **kwargs):
        """
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedConstraints.
        This endpoint will not produce results. It is a placeholder to enforce code generation of SupportedConstraints.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_supportedconstraints_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SupportedConstraints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_supportedconstraints" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/constraints', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SupportedConstraints',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_workflow_execution(self, workflow_id, execution_id, **kwargs):
        """
        Get workflow execution
        Retrieves a workflow run for a given workflow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workflow_execution(workflow_id, execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str execution_id: executionId (required)
        :return: WsWorkflowExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_workflow_execution_with_http_info(workflow_id, execution_id, **kwargs)
        else:
            (data) = self.get_workflow_execution_with_http_info(workflow_id, execution_id, **kwargs)
            return data

    def get_workflow_execution_with_http_info(self, workflow_id, execution_id, **kwargs):
        """
        Get workflow execution
        Retrieves a workflow run for a given workflow.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workflow_execution_with_http_info(workflow_id, execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str execution_id: executionId (required)
        :return: WsWorkflowExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'execution_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_workflow_execution`")
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params) or (params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_workflow_execution`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/executions/{executionId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='WsWorkflowExecution',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_workflow_execution_state(self, workflow_id, execution_id, **kwargs):
        """
        Get workflow execution state
        Retrieves the current state for a requested workflow run
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workflow_execution_state(workflow_id, execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str execution_id: executionId (required)
        :return: ExecutionState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_workflow_execution_state_with_http_info(workflow_id, execution_id, **kwargs)
        else:
            (data) = self.get_workflow_execution_state_with_http_info(workflow_id, execution_id, **kwargs)
            return data

    def get_workflow_execution_state_with_http_info(self, workflow_id, execution_id, **kwargs):
        """
        Get workflow execution state
        Retrieves the current state for a requested workflow run
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workflow_execution_state_with_http_info(workflow_id, execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param str execution_id: executionId (required)
        :return: ExecutionState
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'execution_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_execution_state" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_workflow_execution_state`")
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params) or (params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_workflow_execution_state`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/executions/{executionId}/state', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExecutionState',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def start_workflow_execution(self, workflow_id, execution_context, **kwargs):
        """
        Start workflow execution
        Instantiates a workflow run, by using the passed parameters. The workflow run is asynchronous, so the call returns a pointer to a task that can be used to track the workflow run. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.start_workflow_execution(workflow_id, execution_context, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param ExecutionContext execution_context: executionContext (required)
        :return: WsWorkflowExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.start_workflow_execution_with_http_info(workflow_id, execution_context, **kwargs)
        else:
            (data) = self.start_workflow_execution_with_http_info(workflow_id, execution_context, **kwargs)
            return data

    def start_workflow_execution_with_http_info(self, workflow_id, execution_context, **kwargs):
        """
        Start workflow execution
        Instantiates a workflow run, by using the passed parameters. The workflow run is asynchronous, so the call returns a pointer to a task that can be used to track the workflow run. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.start_workflow_execution_with_http_info(workflow_id, execution_context, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workflow_id: workflowId (required)
        :param ExecutionContext execution_context: executionContext (required)
        :return: WsWorkflowExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'execution_context']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_workflow_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if ('workflow_id' not in params) or (params['workflow_id'] is None):
            raise ValueError("Missing the required parameter `workflow_id` when calling `start_workflow_execution`")
        # verify the required parameter 'execution_context' is set
        if ('execution_context' not in params) or (params['execution_context'] is None):
            raise ValueError("Missing the required parameter `execution_context` when calling `start_workflow_execution`")


        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'execution_context' in params:
            body_params = params['execution_context']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/workflows/{workflowId}/executions', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='WsWorkflowExecution',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
