# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class VrealizeBrowseApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def browse_sdk_objects(self, vro_id, target, browse_paths, **kwargs):
        """
        Browse remote vRealize Orchestrator inventory
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.browse_sdk_objects(vro_id, target, browse_paths, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vro_id: The ID of the server to browse inventory items on (required)
        :param str target: The 'plugin[:type]' to serve as the starting point for the browsing (required)
        :param str browse_paths: Inventory search path to identify the VRO inventory node to get contents of (required)
        :return: VroRemoteItems
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.browse_sdk_objects_with_http_info(vro_id, target, browse_paths, **kwargs)
        else:
            (data) = self.browse_sdk_objects_with_http_info(vro_id, target, browse_paths, **kwargs)
            return data

    def browse_sdk_objects_with_http_info(self, vro_id, target, browse_paths, **kwargs):
        """
        Browse remote vRealize Orchestrator inventory
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.browse_sdk_objects_with_http_info(vro_id, target, browse_paths, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vro_id: The ID of the server to browse inventory items on (required)
        :param str target: The 'plugin[:type]' to serve as the starting point for the browsing (required)
        :param str browse_paths: Inventory search path to identify the VRO inventory node to get contents of (required)
        :return: VroRemoteItems
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vro_id', 'target', 'browse_paths']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method browse_sdk_objects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vro_id' is set
        if ('vro_id' not in params) or (params['vro_id'] is None):
            raise ValueError("Missing the required parameter `vro_id` when calling `browse_sdk_objects`")
        # verify the required parameter 'target' is set
        if ('target' not in params) or (params['target'] is None):
            raise ValueError("Missing the required parameter `target` when calling `browse_sdk_objects`")
        # verify the required parameter 'browse_paths' is set
        if ('browse_paths' not in params) or (params['browse_paths'] is None):
            raise ValueError("Missing the required parameter `browse_paths` when calling `browse_sdk_objects`")


        collection_formats = {}

        path_params = {}
        if 'vro_id' in params:
            path_params['vroId'] = params['vro_id']
        if 'target' in params:
            path_params['target'] = params['target']
        if 'browse_paths' in params:
            path_params['browsePaths'] = params['browse_paths']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/vro/servers/{vroId}/sdkObjects/{target}/{browsePaths:.+}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VroRemoteItems',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_plugin_list(self, vro_id, **kwargs):
        """
        Browse remote vRealize Orchestrator inventory
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_plugin_list(vro_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vro_id: The ID of the server to browse inventory items on (required)
        :return: VroRemotePluginItems
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_plugin_list_with_http_info(vro_id, **kwargs)
        else:
            (data) = self.get_plugin_list_with_http_info(vro_id, **kwargs)
            return data

    def get_plugin_list_with_http_info(self, vro_id, **kwargs):
        """
        Browse remote vRealize Orchestrator inventory
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_plugin_list_with_http_info(vro_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vro_id: The ID of the server to browse inventory items on (required)
        :return: VroRemotePluginItems
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vro_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plugin_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vro_id' is set
        if ('vro_id' not in params) or (params['vro_id'] is None):
            raise ValueError("Missing the required parameter `vro_id` when calling `get_plugin_list`")


        collection_formats = {}

        path_params = {}
        if 'vro_id' in params:
            path_params['vroId'] = params['vro_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/vro/servers/{vroId}/entityTypes', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VroRemotePluginItems',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_plugin_type_list(self, vro_id, plugin_name, **kwargs):
        """
        Browse remote vRealize Orchestrator inventory
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_plugin_type_list(vro_id, plugin_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vro_id: The ID of the server to browse inventory items on (required)
        :param str plugin_name: Inventory search path to identify the VRO inventory node to get contents of (required)
        :return: VroRemotePluginTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_plugin_type_list_with_http_info(vro_id, plugin_name, **kwargs)
        else:
            (data) = self.get_plugin_type_list_with_http_info(vro_id, plugin_name, **kwargs)
            return data

    def get_plugin_type_list_with_http_info(self, vro_id, plugin_name, **kwargs):
        """
        Browse remote vRealize Orchestrator inventory
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_plugin_type_list_with_http_info(vro_id, plugin_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vro_id: The ID of the server to browse inventory items on (required)
        :param str plugin_name: Inventory search path to identify the VRO inventory node to get contents of (required)
        :return: VroRemotePluginTypes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vro_id', 'plugin_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plugin_type_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vro_id' is set
        if ('vro_id' not in params) or (params['vro_id'] is None):
            raise ValueError("Missing the required parameter `vro_id` when calling `get_plugin_type_list`")
        # verify the required parameter 'plugin_name' is set
        if ('plugin_name' not in params) or (params['plugin_name'] is None):
            raise ValueError("Missing the required parameter `plugin_name` when calling `get_plugin_type_list`")


        collection_formats = {}

        path_params = {}
        if 'vro_id' in params:
            path_params['vroId'] = params['vro_id']
        if 'plugin_name' in params:
            path_params['pluginName'] = params['plugin_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/vro/servers/{vroId}/entityTypes/{pluginName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VroRemotePluginTypes',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_remote_inventory(self, vro_id, any, **kwargs):
        """
        Browse remote vRealize Orchestrator inventory
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_remote_inventory(vro_id, any, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vro_id: The ID of the server to browse inventory items on (required)
        :param str any: Inventory search path to identify the VRO inventory node to get contents of (required)
        :return: VroRemoteInventoryItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_remote_inventory_with_http_info(vro_id, any, **kwargs)
        else:
            (data) = self.get_remote_inventory_with_http_info(vro_id, any, **kwargs)
            return data

    def get_remote_inventory_with_http_info(self, vro_id, any, **kwargs):
        """
        Browse remote vRealize Orchestrator inventory
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_remote_inventory_with_http_info(vro_id, any, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vro_id: The ID of the server to browse inventory items on (required)
        :param str any: Inventory search path to identify the VRO inventory node to get contents of (required)
        :return: VroRemoteInventoryItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vro_id', 'any']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_remote_inventory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vro_id' is set
        if ('vro_id' not in params) or (params['vro_id'] is None):
            raise ValueError("Missing the required parameter `vro_id` when calling `get_remote_inventory`")
        # verify the required parameter 'any' is set
        if ('any' not in params) or (params['any'] is None):
            raise ValueError("Missing the required parameter `any` when calling `get_remote_inventory`")


        collection_formats = {}

        path_params = {}
        if 'vro_id' in params:
            path_params['vroId'] = params['vro_id']
        if 'any' in params:
            path_params['any'] = params['any']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/vro/servers/{vroId}/inventory{any:.*}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VroRemoteInventoryItem',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def search_sdk_objects(self, vro_id, target, **kwargs):
        """
        Browse remote vRealize Orchestrator inventory
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_sdk_objects(vro_id, target, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vro_id: The ID of the server to browse inventory items on (required)
        :param str target: The 'plugin[:type]' to serve as the starting point for the browsing (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: VroRemoteItems
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.search_sdk_objects_with_http_info(vro_id, target, **kwargs)
        else:
            (data) = self.search_sdk_objects_with_http_info(vro_id, target, **kwargs)
            return data

    def search_sdk_objects_with_http_info(self, vro_id, target, **kwargs):
        """
        Browse remote vRealize Orchestrator inventory
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.search_sdk_objects_with_http_info(vro_id, target, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vro_id: The ID of the server to browse inventory items on (required)
        :param str target: The 'plugin[:type]' to serve as the starting point for the browsing (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: VroRemoteItems
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vro_id', 'target', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_sdk_objects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vro_id' is set
        if ('vro_id' not in params) or (params['vro_id'] is None):
            raise ValueError("Missing the required parameter `vro_id` when calling `search_sdk_objects`")
        # verify the required parameter 'target' is set
        if ('target' not in params) or (params['target'] is None):
            raise ValueError("Missing the required parameter `target` when calling `search_sdk_objects`")


        collection_formats = {}

        path_params = {}
        if 'vro_id' in params:
            path_params['vroId'] = params['vro_id']
        if 'target' in params:
            path_params['target'] = params['target']

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/vro/servers/{vroId}/sdkObjects/{target}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VroRemoteItems',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
