# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class VdcComputePolicies2Api(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_vdc_compute_policy_to_vdcs(self, vdc_refs, vdc_compute_policy_id, **kwargs):
        """
        Assign this organization VDC compute policy to list of VDCs.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_vdc_compute_policy_to_vdcs(vdc_refs, vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[EntityReference] vdc_refs: (required)
        :param str vdc_compute_policy_id: (required)
        :return: list[EntityReference]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_vdc_compute_policy_to_vdcs_with_http_info(vdc_refs, vdc_compute_policy_id, **kwargs)
        else:
            (data) = self.add_vdc_compute_policy_to_vdcs_with_http_info(vdc_refs, vdc_compute_policy_id, **kwargs)
            return data

    def add_vdc_compute_policy_to_vdcs_with_http_info(self, vdc_refs, vdc_compute_policy_id, **kwargs):
        """
        Assign this organization VDC compute policy to list of VDCs.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_vdc_compute_policy_to_vdcs_with_http_info(vdc_refs, vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[EntityReference] vdc_refs: (required)
        :param str vdc_compute_policy_id: (required)
        :return: list[EntityReference]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vdc_refs', 'vdc_compute_policy_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_vdc_compute_policy_to_vdcs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vdc_refs' is set
        if ('vdc_refs' not in params) or (params['vdc_refs'] is None):
            raise ValueError("Missing the required parameter `vdc_refs` when calling `add_vdc_compute_policy_to_vdcs`")
        # verify the required parameter 'vdc_compute_policy_id' is set
        if ('vdc_compute_policy_id' not in params) or (params['vdc_compute_policy_id'] is None):
            raise ValueError("Missing the required parameter `vdc_compute_policy_id` when calling `add_vdc_compute_policy_to_vdcs`")


        collection_formats = {}

        path_params = {}
        if 'vdc_compute_policy_id' in params:
            path_params['vdcComputePolicyId'] = params['vdc_compute_policy_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'vdc_refs' in params:
            body_params = params['vdc_refs']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/2.0.0/vdcComputePolicies/{vdcComputePolicyId}/vdcs', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[EntityReference]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_vdc_compute_policy(self, new_vdc_compute_policy_params, **kwargs):
        """
        Creates a new organization VDC compute policy
        Creates a new VDC compute policy. if PolicyType is VdcKubernetesPolicy, then the response is a 202 with task URL in location header. For VdcVmPolicy type, the response is 201 with created policy in response body. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_vdc_compute_policy(new_vdc_compute_policy_params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param VdcComputePolicy2 new_vdc_compute_policy_params: (required)
        :return: VdcComputePolicy2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_vdc_compute_policy_with_http_info(new_vdc_compute_policy_params, **kwargs)
        else:
            (data) = self.create_vdc_compute_policy_with_http_info(new_vdc_compute_policy_params, **kwargs)
            return data

    def create_vdc_compute_policy_with_http_info(self, new_vdc_compute_policy_params, **kwargs):
        """
        Creates a new organization VDC compute policy
        Creates a new VDC compute policy. if PolicyType is VdcKubernetesPolicy, then the response is a 202 with task URL in location header. For VdcVmPolicy type, the response is 201 with created policy in response body. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_vdc_compute_policy_with_http_info(new_vdc_compute_policy_params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param VdcComputePolicy2 new_vdc_compute_policy_params: (required)
        :return: VdcComputePolicy2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['new_vdc_compute_policy_params']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_vdc_compute_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'new_vdc_compute_policy_params' is set
        if ('new_vdc_compute_policy_params' not in params) or (params['new_vdc_compute_policy_params'] is None):
            raise ValueError("Missing the required parameter `new_vdc_compute_policy_params` when calling `create_vdc_compute_policy`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_vdc_compute_policy_params' in params:
            body_params = params['new_vdc_compute_policy_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/2.0.0/vdcComputePolicies', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VdcComputePolicy2',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_vdc_compute_policy(self, vdc_compute_policy_id, **kwargs):
        """
        Delete specified organization VDC compute policy.
        Deletes vDC compute policy. if PolicyType is VdcKubernetesPolicy, then the response is a 202 with task URL in location header, else 204 is returned. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_vdc_compute_policy(vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vdc_compute_policy_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_vdc_compute_policy_with_http_info(vdc_compute_policy_id, **kwargs)
        else:
            (data) = self.delete_vdc_compute_policy_with_http_info(vdc_compute_policy_id, **kwargs)
            return data

    def delete_vdc_compute_policy_with_http_info(self, vdc_compute_policy_id, **kwargs):
        """
        Delete specified organization VDC compute policy.
        Deletes vDC compute policy. if PolicyType is VdcKubernetesPolicy, then the response is a 202 with task URL in location header, else 204 is returned. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_vdc_compute_policy_with_http_info(vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vdc_compute_policy_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vdc_compute_policy_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_vdc_compute_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vdc_compute_policy_id' is set
        if ('vdc_compute_policy_id' not in params) or (params['vdc_compute_policy_id'] is None):
            raise ValueError("Missing the required parameter `vdc_compute_policy_id` when calling `delete_vdc_compute_policy`")


        collection_formats = {}

        path_params = {}
        if 'vdc_compute_policy_id' in params:
            path_params['vdcComputePolicyId'] = params['vdc_compute_policy_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/2.0.0/vdcComputePolicies/{vdcComputePolicyId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_vdc_compute_policy(self, vdc_compute_policy_id, **kwargs):
        """
        Get specified organization VDC compute policy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_vdc_compute_policy(vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vdc_compute_policy_id: (required)
        :return: VdcComputePolicy2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_vdc_compute_policy_with_http_info(vdc_compute_policy_id, **kwargs)
        else:
            (data) = self.get_vdc_compute_policy_with_http_info(vdc_compute_policy_id, **kwargs)
            return data

    def get_vdc_compute_policy_with_http_info(self, vdc_compute_policy_id, **kwargs):
        """
        Get specified organization VDC compute policy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_vdc_compute_policy_with_http_info(vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vdc_compute_policy_id: (required)
        :return: VdcComputePolicy2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vdc_compute_policy_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vdc_compute_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vdc_compute_policy_id' is set
        if ('vdc_compute_policy_id' not in params) or (params['vdc_compute_policy_id'] is None):
            raise ValueError("Missing the required parameter `vdc_compute_policy_id` when calling `get_vdc_compute_policy`")


        collection_formats = {}

        path_params = {}
        if 'vdc_compute_policy_id' in params:
            path_params['vdcComputePolicyId'] = params['vdc_compute_policy_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/2.0.0/vdcComputePolicies/{vdcComputePolicyId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VdcComputePolicy2',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_vdc_compute_policy_metrics(self, vdc_compute_policy_id, **kwargs):
        """
        Get specified organization VDC compute policy metrics.
        Returns metrics for the given compute policy. Returns 400 if the policyType does not support metrics. For example, if type of the policy is VdcVmPolicy, then this API returns a 400 BadRequest response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_vdc_compute_policy_metrics(vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vdc_compute_policy_id: (required)
        :return: VdcComputePolicyMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_vdc_compute_policy_metrics_with_http_info(vdc_compute_policy_id, **kwargs)
        else:
            (data) = self.get_vdc_compute_policy_metrics_with_http_info(vdc_compute_policy_id, **kwargs)
            return data

    def get_vdc_compute_policy_metrics_with_http_info(self, vdc_compute_policy_id, **kwargs):
        """
        Get specified organization VDC compute policy metrics.
        Returns metrics for the given compute policy. Returns 400 if the policyType does not support metrics. For example, if type of the policy is VdcVmPolicy, then this API returns a 400 BadRequest response. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_vdc_compute_policy_metrics_with_http_info(vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vdc_compute_policy_id: (required)
        :return: VdcComputePolicyMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vdc_compute_policy_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vdc_compute_policy_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vdc_compute_policy_id' is set
        if ('vdc_compute_policy_id' not in params) or (params['vdc_compute_policy_id'] is None):
            raise ValueError("Missing the required parameter `vdc_compute_policy_id` when calling `get_vdc_compute_policy_metrics`")


        collection_formats = {}

        path_params = {}
        if 'vdc_compute_policy_id' in params:
            path_params['vdcComputePolicyId'] = params['vdc_compute_policy_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/2.0.0/vdcComputePolicies/{vdcComputePolicyId}/metrics', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VdcComputePolicyMetrics',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_vdc_compute_policy_vdcs(self, vdc_compute_policy_id, **kwargs):
        """
        Get orgatization VDCs this VDC compute policy has been assigned/published to
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_vdc_compute_policy_vdcs(vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vdc_compute_policy_id: (required)
        :return: list[EntityReference]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_vdc_compute_policy_vdcs_with_http_info(vdc_compute_policy_id, **kwargs)
        else:
            (data) = self.get_vdc_compute_policy_vdcs_with_http_info(vdc_compute_policy_id, **kwargs)
            return data

    def get_vdc_compute_policy_vdcs_with_http_info(self, vdc_compute_policy_id, **kwargs):
        """
        Get orgatization VDCs this VDC compute policy has been assigned/published to
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_vdc_compute_policy_vdcs_with_http_info(vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str vdc_compute_policy_id: (required)
        :return: list[EntityReference]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vdc_compute_policy_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vdc_compute_policy_vdcs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vdc_compute_policy_id' is set
        if ('vdc_compute_policy_id' not in params) or (params['vdc_compute_policy_id'] is None):
            raise ValueError("Missing the required parameter `vdc_compute_policy_id` when calling `get_vdc_compute_policy_vdcs`")


        collection_formats = {}

        path_params = {}
        if 'vdc_compute_policy_id' in params:
            path_params['vdcComputePolicyId'] = params['vdc_compute_policy_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/2.0.0/vdcComputePolicies/{vdcComputePolicyId}/vdcs', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[EntityReference]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_vdc_compute_policies(self, page, page_size, **kwargs):
        """
        Get list of organization VDC compute policies.
        Get list of organization VDC compute policy. <br> Results can be filtered by: <ul>   <li> id   <li> name   <li> pvdcId   <li> isSizingOnly   <li> policyType   <li> vdc.id   <li> pvdcComputePolicy.id   <li> publishableToVdc   <li> pvdc   <li> isAutoGenerated   <li> _context  <ul> <br> Supported contexts are: Org VDC Urn ID (_context==orgVdcUrn) - | <br> Returns all the VDC compute policies which are available to a specific Org VDC. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_vdc_compute_policies(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: VdcComputePolicies2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_vdc_compute_policies_with_http_info(page, page_size, **kwargs)
        else:
            (data) = self.query_vdc_compute_policies_with_http_info(page, page_size, **kwargs)
            return data

    def query_vdc_compute_policies_with_http_info(self, page, page_size, **kwargs):
        """
        Get list of organization VDC compute policies.
        Get list of organization VDC compute policy. <br> Results can be filtered by: <ul>   <li> id   <li> name   <li> pvdcId   <li> isSizingOnly   <li> policyType   <li> vdc.id   <li> pvdcComputePolicy.id   <li> publishableToVdc   <li> pvdc   <li> isAutoGenerated   <li> _context  <ul> <br> Supported contexts are: Org VDC Urn ID (_context==orgVdcUrn) - | <br> Returns all the VDC compute policies which are available to a specific Org VDC. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_vdc_compute_policies_with_http_info(page, page_size, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: VdcComputePolicies2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_vdc_compute_policies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `query_vdc_compute_policies`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `query_vdc_compute_policies`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `query_vdc_compute_policies`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_vdc_compute_policies`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_vdc_compute_policies`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/2.0.0/vdcComputePolicies', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VdcComputePolicies2',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def query_virtual_machine_classes(self, page, page_size, vdc_compute_policy_id, **kwargs):
        """
        Get a list of Virtual Machine Classes associated with this policy.
        Get a list of Virtual Machine Classes associated with this policy. Returns 400 if policy type is anything but VdcKubernetesPolicy. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_virtual_machine_classes(page, page_size, vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str vdc_compute_policy_id: (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: VirtualMachineClasses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.query_virtual_machine_classes_with_http_info(page, page_size, vdc_compute_policy_id, **kwargs)
        else:
            (data) = self.query_virtual_machine_classes_with_http_info(page, page_size, vdc_compute_policy_id, **kwargs)
            return data

    def query_virtual_machine_classes_with_http_info(self, page, page_size, vdc_compute_policy_id, **kwargs):
        """
        Get a list of Virtual Machine Classes associated with this policy.
        Get a list of Virtual Machine Classes associated with this policy. Returns 400 if policy type is anything but VdcKubernetesPolicy. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.query_virtual_machine_classes_with_http_info(page, page_size, vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str vdc_compute_policy_id: (required)
        :param str filter: Filter for a query.  FIQL format.
        :param str sort_asc: Field to use for ascending sort
        :param str sort_desc: Field to use for descending sort
        :return: VirtualMachineClasses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'vdc_compute_policy_id', 'filter', 'sort_asc', 'sort_desc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_virtual_machine_classes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `query_virtual_machine_classes`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `query_virtual_machine_classes`")
        # verify the required parameter 'vdc_compute_policy_id' is set
        if ('vdc_compute_policy_id' not in params) or (params['vdc_compute_policy_id'] is None):
            raise ValueError("Missing the required parameter `vdc_compute_policy_id` when calling `query_virtual_machine_classes`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `query_virtual_machine_classes`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_virtual_machine_classes`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `query_virtual_machine_classes`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'vdc_compute_policy_id' in params:
            path_params['vdcComputePolicyId'] = params['vdc_compute_policy_id']

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))
        if 'sort_desc' in params:
            query_params.append(('sortDesc', params['sort_desc']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/2.0.0/vdcComputePolicies/{vdcComputePolicyId}/virtualMachineClasses', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VirtualMachineClasses',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_vdc_compute_policy(self, update_vdc_compute_policy_params, vdc_compute_policy_id, **kwargs):
        """
        Update specified organization VDC compute policy
        Updates vDC compute policy. if PolicyType is VdcKubernetesPolicy, then the response is a 202 with task URL in location header. For VdcVmPolicy type, the response is 200 with updated policy in response body. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_vdc_compute_policy(update_vdc_compute_policy_params, vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param VdcComputePolicy2 update_vdc_compute_policy_params: (required)
        :param str vdc_compute_policy_id: (required)
        :return: VdcComputePolicy2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_vdc_compute_policy_with_http_info(update_vdc_compute_policy_params, vdc_compute_policy_id, **kwargs)
        else:
            (data) = self.update_vdc_compute_policy_with_http_info(update_vdc_compute_policy_params, vdc_compute_policy_id, **kwargs)
            return data

    def update_vdc_compute_policy_with_http_info(self, update_vdc_compute_policy_params, vdc_compute_policy_id, **kwargs):
        """
        Update specified organization VDC compute policy
        Updates vDC compute policy. if PolicyType is VdcKubernetesPolicy, then the response is a 202 with task URL in location header. For VdcVmPolicy type, the response is 200 with updated policy in response body. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_vdc_compute_policy_with_http_info(update_vdc_compute_policy_params, vdc_compute_policy_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param VdcComputePolicy2 update_vdc_compute_policy_params: (required)
        :param str vdc_compute_policy_id: (required)
        :return: VdcComputePolicy2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['update_vdc_compute_policy_params', 'vdc_compute_policy_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vdc_compute_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'update_vdc_compute_policy_params' is set
        if ('update_vdc_compute_policy_params' not in params) or (params['update_vdc_compute_policy_params'] is None):
            raise ValueError("Missing the required parameter `update_vdc_compute_policy_params` when calling `update_vdc_compute_policy`")
        # verify the required parameter 'vdc_compute_policy_id' is set
        if ('vdc_compute_policy_id' not in params) or (params['vdc_compute_policy_id'] is None):
            raise ValueError("Missing the required parameter `vdc_compute_policy_id` when calling `update_vdc_compute_policy`")


        collection_formats = {}

        path_params = {}
        if 'vdc_compute_policy_id' in params:
            path_params['vdcComputePolicyId'] = params['vdc_compute_policy_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_vdc_compute_policy_params' in params:
            body_params = params['update_vdc_compute_policy_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/2.0.0/vdcComputePolicies/{vdcComputePolicyId}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VdcComputePolicy2',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
