# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class EdgeGatewayLoadBalancerAnalyticsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_load_balancer_analytic_reports(self, **kwargs):
        """
        Retrieves analytics for a specific load balancer.  Metrics are specified in the filter query along with time period and series resolution.  Up to 5 metric series can be specified per report.  All reports will span the same time period.  Report filters are encapsulated in a fiql filter query parameter. Sample filter:   <code>filter=(componentId==urn:vcloud:virtualservice:7d38ad7f-cd93-4501-8c40-6f61650ccda0;         metric==l4_server.avg_total_rtt;metric==l7_server.avg_application_response_time;step==500;limit==100)</code> Supported filters are:   <ul>   <li>componentId.  The URN of the virtual service or pool for which metrics will be gathered.  Only one should be specified.   This is required.   <li>metric.  One or more metrics of interest.  <code>filter=(metric==l4_server.avg_total_rtt;metric==l7_server.avg_application_response_time)</code> -   This is required.  Supported metrics can be found at the analytics/supportedMetrics endpoint.   <li>step.  The time resolution of the report, in seconds.   This is required.  Minimum supported resolution is 300 seconds (5 minutes).   <li>limit.  Optional.  The number of data points to be returned.   This is optional.  Defaults to 59 where it can't be calculated.   <li>startTime.  Start time of the series.   This is optional.  Must be in ISO 8601 format (i.e. 2020-07-24T00:00:00).  If not provided, start time is calculated from the step and end time.   <li>endTime.  End period of the series.   This is optional.  Must be in ISO 8601 format (i.e. 2020-07-24T00:00:00). Defaults to the time of latest collected data point.   </ul> This feature requires additional licensing. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_load_balancer_analytic_reports(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: Filter for a query.  FIQL format.
        :return: EdgeLoadBalancerAnalyticReports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_load_balancer_analytic_reports_with_http_info(**kwargs)
        else:
            (data) = self.get_load_balancer_analytic_reports_with_http_info(**kwargs)
            return data

    def get_load_balancer_analytic_reports_with_http_info(self, **kwargs):
        """
        Retrieves analytics for a specific load balancer.  Metrics are specified in the filter query along with time period and series resolution.  Up to 5 metric series can be specified per report.  All reports will span the same time period.  Report filters are encapsulated in a fiql filter query parameter. Sample filter:   <code>filter=(componentId==urn:vcloud:virtualservice:7d38ad7f-cd93-4501-8c40-6f61650ccda0;         metric==l4_server.avg_total_rtt;metric==l7_server.avg_application_response_time;step==500;limit==100)</code> Supported filters are:   <ul>   <li>componentId.  The URN of the virtual service or pool for which metrics will be gathered.  Only one should be specified.   This is required.   <li>metric.  One or more metrics of interest.  <code>filter=(metric==l4_server.avg_total_rtt;metric==l7_server.avg_application_response_time)</code> -   This is required.  Supported metrics can be found at the analytics/supportedMetrics endpoint.   <li>step.  The time resolution of the report, in seconds.   This is required.  Minimum supported resolution is 300 seconds (5 minutes).   <li>limit.  Optional.  The number of data points to be returned.   This is optional.  Defaults to 59 where it can't be calculated.   <li>startTime.  Start time of the series.   This is optional.  Must be in ISO 8601 format (i.e. 2020-07-24T00:00:00).  If not provided, start time is calculated from the step and end time.   <li>endTime.  End period of the series.   This is optional.  Must be in ISO 8601 format (i.e. 2020-07-24T00:00:00). Defaults to the time of latest collected data point.   </ul> This feature requires additional licensing. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_load_balancer_analytic_reports_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: Filter for a query.  FIQL format.
        :return: EdgeLoadBalancerAnalyticReports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_load_balancer_analytic_reports" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/loadBalancer/analyticReports', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EdgeLoadBalancerAnalyticReports',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_load_balancer_supported_analytic_metrics(self, **kwargs):
        """
        Retrieves all the supported metrics for load balancer analytic reports.  These metrics can be used to create runtime reports of load balancer virtual services and pools. Supported filters are: <ul>   <li>componentId.  The URN of the load balancer virtual service or pool for which we want supported metrics. Only one should be specified.   This is required. </ul> This feature requires additional licensing. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_load_balancer_supported_analytic_metrics(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: Filter for a query.  FIQL format.
        :return: EdgeLoadBalancerAnalyticMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_load_balancer_supported_analytic_metrics_with_http_info(**kwargs)
        else:
            (data) = self.get_load_balancer_supported_analytic_metrics_with_http_info(**kwargs)
            return data

    def get_load_balancer_supported_analytic_metrics_with_http_info(self, **kwargs):
        """
        Retrieves all the supported metrics for load balancer analytic reports.  These metrics can be used to create runtime reports of load balancer virtual services and pools. Supported filters are: <ul>   <li>componentId.  The URN of the load balancer virtual service or pool for which we want supported metrics. Only one should be specified.   This is required. </ul> This feature requires additional licensing. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_load_balancer_supported_analytic_metrics_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: Filter for a query.  FIQL format.
        :return: EdgeLoadBalancerAnalyticMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_load_balancer_supported_analytic_metrics" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/loadBalancer/analyticReports/supportedMetrics', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='EdgeLoadBalancerAnalyticMetrics',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
