# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class DefinedInterfaceBehaviorsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_defined_entity_type_access(self, definition, id, **kwargs):
        """
        Adds an access control configuration of an entity type's behavior
        Adds an access control configuration of an entity type's behavior
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_defined_entity_type_access(definition, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BehaviorAccess definition: (required)
        :param str id: (required)
        :return: BehaviorAccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_defined_entity_type_access_with_http_info(definition, id, **kwargs)
        else:
            (data) = self.add_defined_entity_type_access_with_http_info(definition, id, **kwargs)
            return data

    def add_defined_entity_type_access_with_http_info(self, definition, id, **kwargs):
        """
        Adds an access control configuration of an entity type's behavior
        Adds an access control configuration of an entity type's behavior
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_defined_entity_type_access_with_http_info(definition, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BehaviorAccess definition: (required)
        :param str id: (required)
        :return: BehaviorAccess
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['definition', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_defined_entity_type_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'definition' is set
        if ('definition' not in params) or (params['definition'] is None):
            raise ValueError("Missing the required parameter `definition` when calling `add_defined_entity_type_access`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_defined_entity_type_access`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'definition' in params:
            body_params = params['definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/entityTypes/{id}/behaviorAccessControls', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BehaviorAccess',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_interface_behavior(self, behavior, id, **kwargs):
        """
        Add a new interface Behavior if the Interface is not in use
        Add a new Behavior to the Interface. Only allowed if the Interface is not in use. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_interface_behavior(behavior, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Behavior behavior: (required)
        :param str id: (required)
        :return: Behavior
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_interface_behavior_with_http_info(behavior, id, **kwargs)
        else:
            (data) = self.add_interface_behavior_with_http_info(behavior, id, **kwargs)
            return data

    def add_interface_behavior_with_http_info(self, behavior, id, **kwargs):
        """
        Add a new interface Behavior if the Interface is not in use
        Add a new Behavior to the Interface. Only allowed if the Interface is not in use. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_interface_behavior_with_http_info(behavior, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Behavior behavior: (required)
        :param str id: (required)
        :return: Behavior
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['behavior', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_interface_behavior" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'behavior' is set
        if ('behavior' not in params) or (params['behavior'] is None):
            raise ValueError("Missing the required parameter `behavior` when calling `add_interface_behavior`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_interface_behavior`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'behavior' in params:
            body_params = params['behavior']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/interfaces/{id}/behaviors', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Behavior',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_interface_behavior(self, id, behavior_id, **kwargs):
        """
        Remove a Behavior from the Defined Interface.
        Remove a Behavior from the Defined Interface. The Behaviors can be specified by ID or by name. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_interface_behavior(id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_interface_behavior_with_http_info(id, behavior_id, **kwargs)
        else:
            (data) = self.delete_interface_behavior_with_http_info(id, behavior_id, **kwargs)
            return data

    def delete_interface_behavior_with_http_info(self, id, behavior_id, **kwargs):
        """
        Remove a Behavior from the Defined Interface.
        Remove a Behavior from the Defined Interface. The Behaviors can be specified by ID or by name. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_interface_behavior_with_http_info(id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'behavior_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_interface_behavior" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_interface_behavior`")
        # verify the required parameter 'behavior_id' is set
        if ('behavior_id' not in params) or (params['behavior_id'] is None):
            raise ValueError("Missing the required parameter `behavior_id` when calling `delete_interface_behavior`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'behavior_id' in params:
            path_params['behaviorId'] = params['behavior_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/interfaces/{id}/behaviors/{behaviorId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_defined_entity_type_access(self, page, page_size, id, **kwargs):
        """
        Gets the access control configuration of the entity type's behaviors
        Gets the access control configuration of the entity type's behaviors
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_defined_entity_type_access(page, page_size, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str id: (required)
        :return: BehaviorAccesses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_defined_entity_type_access_with_http_info(page, page_size, id, **kwargs)
        else:
            (data) = self.get_defined_entity_type_access_with_http_info(page, page_size, id, **kwargs)
            return data

    def get_defined_entity_type_access_with_http_info(self, page, page_size, id, **kwargs):
        """
        Gets the access control configuration of the entity type's behaviors
        Gets the access control configuration of the entity type's behaviors
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_defined_entity_type_access_with_http_info(page, page_size, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str id: (required)
        :return: BehaviorAccesses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_defined_entity_type_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_defined_entity_type_access`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_defined_entity_type_access`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_defined_entity_type_access`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_defined_entity_type_access`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_defined_entity_type_access`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_defined_entity_type_access`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/entityTypes/{id}/behaviorAccessControls', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BehaviorAccesses',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_defined_entity_type_behaviors(self, page, page_size, id, **kwargs):
        """
        Get the Behaviors of the Defined Entity Type.
        Retrieve the Behaviors of the specified Defined Entity Type. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_defined_entity_type_behaviors(page, page_size, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str id: (required)
        :return: Behaviors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_defined_entity_type_behaviors_with_http_info(page, page_size, id, **kwargs)
        else:
            (data) = self.get_defined_entity_type_behaviors_with_http_info(page, page_size, id, **kwargs)
            return data

    def get_defined_entity_type_behaviors_with_http_info(self, page, page_size, id, **kwargs):
        """
        Get the Behaviors of the Defined Entity Type.
        Retrieve the Behaviors of the specified Defined Entity Type. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_defined_entity_type_behaviors_with_http_info(page, page_size, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str id: (required)
        :return: Behaviors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_defined_entity_type_behaviors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_defined_entity_type_behaviors`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_defined_entity_type_behaviors`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_defined_entity_type_behaviors`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_defined_entity_type_behaviors`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_defined_entity_type_behaviors`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_defined_entity_type_behaviors`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/entityTypes/{id}/behaviors', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Behaviors',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_interface_behavior(self, id, behavior_id, **kwargs):
        """
        Get a Behavior in the Defined Interface.
        Retrieve a specific Behavior in the specified Defined Interface. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_interface_behavior(id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: Behavior
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_interface_behavior_with_http_info(id, behavior_id, **kwargs)
        else:
            (data) = self.get_interface_behavior_with_http_info(id, behavior_id, **kwargs)
            return data

    def get_interface_behavior_with_http_info(self, id, behavior_id, **kwargs):
        """
        Get a Behavior in the Defined Interface.
        Retrieve a specific Behavior in the specified Defined Interface. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_interface_behavior_with_http_info(id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: Behavior
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'behavior_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_interface_behavior" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_interface_behavior`")
        # verify the required parameter 'behavior_id' is set
        if ('behavior_id' not in params) or (params['behavior_id'] is None):
            raise ValueError("Missing the required parameter `behavior_id` when calling `get_interface_behavior`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'behavior_id' in params:
            path_params['behaviorId'] = params['behavior_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/interfaces/{id}/behaviors/{behaviorId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Behavior',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_interface_behaviors(self, page, page_size, id, **kwargs):
        """
        Get the Behaviors of the Defined Interface.
        Retrieve the Behaviors of the specified Defined Interface. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_interface_behaviors(page, page_size, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str id: (required)
        :return: Behaviors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_interface_behaviors_with_http_info(page, page_size, id, **kwargs)
        else:
            (data) = self.get_interface_behaviors_with_http_info(page, page_size, id, **kwargs)
            return data

    def get_interface_behaviors_with_http_info(self, page, page_size, id, **kwargs):
        """
        Get the Behaviors of the Defined Interface.
        Retrieve the Behaviors of the specified Defined Interface. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_interface_behaviors_with_http_info(page, page_size, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page: Page to fetch, zero offset. (required)
        :param int page_size: Results per page to fetch. (required)
        :param str id: (required)
        :return: Behaviors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_interface_behaviors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'page' is set
        if ('page' not in params) or (params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `get_interface_behaviors`")
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params) or (params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_interface_behaviors`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_interface_behaviors`")

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_interface_behaviors`, must be a value greater than or equal to `1`")
        if 'page_size' in params and params['page_size'] > 128:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_interface_behaviors`, must be a value less than or equal to `128`")
        if 'page_size' in params and params['page_size'] < 0:
            raise ValueError("Invalid value for parameter `page_size` when calling `get_interface_behaviors`, must be a value greater than or equal to `0`")

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/interfaces/{id}/behaviors', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Behaviors',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_type_behavior(self, id, behavior_id, **kwargs):
        """
        Get a Behavior in the Defined Type
        Retrieve a specific Behavior in the Defined Type. The Behavior must be specified by ID. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_type_behavior(id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: Behavior
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_type_behavior_with_http_info(id, behavior_id, **kwargs)
        else:
            (data) = self.get_type_behavior_with_http_info(id, behavior_id, **kwargs)
            return data

    def get_type_behavior_with_http_info(self, id, behavior_id, **kwargs):
        """
        Get a Behavior in the Defined Type
        Retrieve a specific Behavior in the Defined Type. The Behavior must be specified by ID. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_type_behavior_with_http_info(id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: Behavior
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'behavior_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_type_behavior" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_type_behavior`")
        # verify the required parameter 'behavior_id' is set
        if ('behavior_id' not in params) or (params['behavior_id'] is None):
            raise ValueError("Missing the required parameter `behavior_id` when calling `get_type_behavior`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'behavior_id' in params:
            path_params['behaviorId'] = params['behavior_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/entityTypes/{id}/behaviors/{behaviorId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Behavior',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def invoke_defined_entity_behavior(self, id, behavior_id, **kwargs):
        """
        Invokes a behavior on a defined entity
        Invokes a behavior on a defined entity. The contract of the behavior is specified in the behavior description. If an Activity behavior is invoked with an 'operationId' in the invocation metadata, then another invocation of the behavior with the same 'operationId' will be ignored within the next 1 hour. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.invoke_defined_entity_behavior(id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param str behavior_id: (required)
        :param BehaviorInvocation invocation:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.invoke_defined_entity_behavior_with_http_info(id, behavior_id, **kwargs)
        else:
            (data) = self.invoke_defined_entity_behavior_with_http_info(id, behavior_id, **kwargs)
            return data

    def invoke_defined_entity_behavior_with_http_info(self, id, behavior_id, **kwargs):
        """
        Invokes a behavior on a defined entity
        Invokes a behavior on a defined entity. The contract of the behavior is specified in the behavior description. If an Activity behavior is invoked with an 'operationId' in the invocation metadata, then another invocation of the behavior with the same 'operationId' will be ignored within the next 1 hour. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.invoke_defined_entity_behavior_with_http_info(id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param str behavior_id: (required)
        :param BehaviorInvocation invocation:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'behavior_id', 'invocation']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invoke_defined_entity_behavior" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `invoke_defined_entity_behavior`")
        # verify the required parameter 'behavior_id' is set
        if ('behavior_id' not in params) or (params['behavior_id'] is None):
            raise ValueError("Missing the required parameter `behavior_id` when calling `invoke_defined_entity_behavior`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'behavior_id' in params:
            path_params['behaviorId'] = params['behavior_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invocation' in params:
            body_params = params['invocation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/entities/{id}/behaviors/{behaviorId}/invocations', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def remove_behavior_override(self, id, behavior_id, **kwargs):
        """
        Remove a Behavior override from the Defined Entity Type.
        Remove a Behavior override in the Defined Entity Type. The Behavior must be specified by ID. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_behavior_override(id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_behavior_override_with_http_info(id, behavior_id, **kwargs)
        else:
            (data) = self.remove_behavior_override_with_http_info(id, behavior_id, **kwargs)
            return data

    def remove_behavior_override_with_http_info(self, id, behavior_id, **kwargs):
        """
        Remove a Behavior override from the Defined Entity Type.
        Remove a Behavior override in the Defined Entity Type. The Behavior must be specified by ID. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_behavior_override_with_http_info(id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'behavior_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_behavior_override" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_behavior_override`")
        # verify the required parameter 'behavior_id' is set
        if ('behavior_id' not in params) or (params['behavior_id'] is None):
            raise ValueError("Missing the required parameter `behavior_id` when calling `remove_behavior_override`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'behavior_id' in params:
            path_params['behaviorId'] = params['behavior_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/entityTypes/{id}/behaviors/{behaviorId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def set_defined_entity_type_access(self, definition, id, **kwargs):
        """
        Sets the access control configuration of the entity type's behaviors
        Sets the access control configuration of the entity type's behaviors
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.set_defined_entity_type_access(definition, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BehaviorAccesses definition: (required)
        :param str id: (required)
        :return: BehaviorAccesses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.set_defined_entity_type_access_with_http_info(definition, id, **kwargs)
        else:
            (data) = self.set_defined_entity_type_access_with_http_info(definition, id, **kwargs)
            return data

    def set_defined_entity_type_access_with_http_info(self, definition, id, **kwargs):
        """
        Sets the access control configuration of the entity type's behaviors
        Sets the access control configuration of the entity type's behaviors
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.set_defined_entity_type_access_with_http_info(definition, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BehaviorAccesses definition: (required)
        :param str id: (required)
        :return: BehaviorAccesses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['definition', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_defined_entity_type_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'definition' is set
        if ('definition' not in params) or (params['definition'] is None):
            raise ValueError("Missing the required parameter `definition` when calling `set_defined_entity_type_access`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `set_defined_entity_type_access`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'definition' in params:
            body_params = params['definition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/entityTypes/{id}/behaviorAccessControls', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='BehaviorAccesses',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_interface_behavior(self, behavior, id, behavior_id, **kwargs):
        """
        Update the execution of the specified Behavior in the Defined Interface
        Update the execution of the specified Behavior in the Defined Interface. The Behaviors can be specified by ID or by name. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_interface_behavior(behavior, id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Behavior behavior: (required)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: Behavior
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_interface_behavior_with_http_info(behavior, id, behavior_id, **kwargs)
        else:
            (data) = self.update_interface_behavior_with_http_info(behavior, id, behavior_id, **kwargs)
            return data

    def update_interface_behavior_with_http_info(self, behavior, id, behavior_id, **kwargs):
        """
        Update the execution of the specified Behavior in the Defined Interface
        Update the execution of the specified Behavior in the Defined Interface. The Behaviors can be specified by ID or by name. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_interface_behavior_with_http_info(behavior, id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Behavior behavior: (required)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: Behavior
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['behavior', 'id', 'behavior_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_interface_behavior" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'behavior' is set
        if ('behavior' not in params) or (params['behavior'] is None):
            raise ValueError("Missing the required parameter `behavior` when calling `update_interface_behavior`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_interface_behavior`")
        # verify the required parameter 'behavior_id' is set
        if ('behavior_id' not in params) or (params['behavior_id'] is None):
            raise ValueError("Missing the required parameter `behavior_id` when calling `update_interface_behavior`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'behavior_id' in params:
            path_params['behaviorId'] = params['behavior_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'behavior' in params:
            body_params = params['behavior']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/interfaces/{id}/behaviors/{behaviorId}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Behavior',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_interface_behaviors(self, behaviors, id, **kwargs):
        """
        Update all the executions of the specified Behaviors (possibly removing or adding some)
        Update all Behaviors, possibly adding or removing some if the Interface is not in use. If the Interface is in use, then only the executions of the existing Behaviors can be updated. The Behaviors can be specified by ID or by name. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_interface_behaviors(behaviors, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Behaviors behaviors: (required)
        :param str id: (required)
        :return: Behaviors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_interface_behaviors_with_http_info(behaviors, id, **kwargs)
        else:
            (data) = self.update_interface_behaviors_with_http_info(behaviors, id, **kwargs)
            return data

    def update_interface_behaviors_with_http_info(self, behaviors, id, **kwargs):
        """
        Update all the executions of the specified Behaviors (possibly removing or adding some)
        Update all Behaviors, possibly adding or removing some if the Interface is not in use. If the Interface is in use, then only the executions of the existing Behaviors can be updated. The Behaviors can be specified by ID or by name. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_interface_behaviors_with_http_info(behaviors, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Behaviors behaviors: (required)
        :param str id: (required)
        :return: Behaviors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['behaviors', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_interface_behaviors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'behaviors' is set
        if ('behaviors' not in params) or (params['behaviors'] is None):
            raise ValueError("Missing the required parameter `behaviors` when calling `update_interface_behaviors`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_interface_behaviors`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'behaviors' in params:
            body_params = params['behaviors']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/interfaces/{id}/behaviors', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Behaviors',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_type_behavior(self, behavior, id, behavior_id, **kwargs):
        """
        Update the execution of the specified Behavior in the Defined Entity Type
        Override the execution of the specified Behavior in the Defined Entity Type. The Behavior must be specified by ID. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_type_behavior(behavior, id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Behavior behavior: (required)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: Behavior
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_type_behavior_with_http_info(behavior, id, behavior_id, **kwargs)
        else:
            (data) = self.update_type_behavior_with_http_info(behavior, id, behavior_id, **kwargs)
            return data

    def update_type_behavior_with_http_info(self, behavior, id, behavior_id, **kwargs):
        """
        Update the execution of the specified Behavior in the Defined Entity Type
        Override the execution of the specified Behavior in the Defined Entity Type. The Behavior must be specified by ID. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_type_behavior_with_http_info(behavior, id, behavior_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Behavior behavior: (required)
        :param str id: (required)
        :param str behavior_id: (required)
        :return: Behavior
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['behavior', 'id', 'behavior_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_type_behavior" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'behavior' is set
        if ('behavior' not in params) or (params['behavior'] is None):
            raise ValueError("Missing the required parameter `behavior` when calling `update_type_behavior`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_type_behavior`")
        # verify the required parameter 'behavior_id' is set
        if ('behavior_id' not in params) or (params['behavior_id'] is None):
            raise ValueError("Missing the required parameter `behavior_id` when calling `update_type_behavior`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'behavior_id' in params:
            path_params['behaviorId'] = params['behavior_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'behavior' in params:
            body_params = params['behavior']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['ApiKeyAuth']

        return self.api_client.call_api('/1.0.0/entityTypes/{id}/behaviors/{behaviorId}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='Behavior',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
