"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class VdcType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'compute_provider_scope': 'str',
        'network_provider_scope': 'str',
        'allocation_model': 'str',
        'storage_capacity': 'CapacityWithUsageType',
        'compute_capacity': 'ComputeCapacityType',
        'resource_entities': 'ResourceEntitiesType',
        'available_networks': 'AvailableNetworksType',
        'capabilities': 'CapabilitiesType',
        'nic_quota': 'int',
        'network_quota': 'int',
        'used_network_count': 'int',
        'vm_quota': 'int',
        'is_enabled': 'bool',
        'vdc_storage_profiles': 'VdcStorageProfilesType',
        'default_compute_policy': 'ReferenceType',
        'max_compute_policy': 'ReferenceType',
        'v_cpu_in_mhz2': 'int',
        'status': 'int',
        'is_legacy_type': 'bool'
    }

    attribute_map = {
        'compute_provider_scope': 'computeProviderScope',
        'network_provider_scope': 'networkProviderScope',
        'allocation_model': 'allocationModel',
        'storage_capacity': 'storageCapacity',
        'compute_capacity': 'computeCapacity',
        'resource_entities': 'resourceEntities',
        'available_networks': 'availableNetworks',
        'capabilities': 'capabilities',
        'nic_quota': 'nicQuota',
        'network_quota': 'networkQuota',
        'used_network_count': 'usedNetworkCount',
        'vm_quota': 'vmQuota',
        'is_enabled': 'isEnabled',
        'vdc_storage_profiles': 'vdcStorageProfiles',
        'default_compute_policy': 'defaultComputePolicy',
        'max_compute_policy': 'maxComputePolicy',
        'v_cpu_in_mhz2': 'vCpuInMhz2',
        'status': 'status',
        'is_legacy_type': 'isLegacyType'
    }

    def __init__(self, compute_provider_scope=None,network_provider_scope=None,allocation_model=None,storage_capacity=None,compute_capacity=None,resource_entities=None,available_networks=None,capabilities=None,nic_quota=None,network_quota=None,used_network_count=None,vm_quota=None,is_enabled=None,vdc_storage_profiles=None,default_compute_policy=None,max_compute_policy=None,v_cpu_in_mhz2=None,status=None,is_legacy_type=None):
        self._compute_provider_scope = None
        self._network_provider_scope = None
        self._allocation_model = None
        self._storage_capacity = None
        self._compute_capacity = None
        self._resource_entities = None
        self._available_networks = None
        self._capabilities = None
        self._nic_quota = None
        self._network_quota = None
        self._used_network_count = None
        self._vm_quota = None
        self._is_enabled = None
        self._vdc_storage_profiles = None
        self._default_compute_policy = None
        self._max_compute_policy = None
        self._v_cpu_in_mhz2 = None
        self._status = None
        self._is_legacy_type = None

        if compute_provider_scope is not None:
            self.compute_provider_scope = compute_provider_scope
        if network_provider_scope is not None:
            self.network_provider_scope = network_provider_scope
        if allocation_model is not None:
            self.allocation_model = allocation_model
        if storage_capacity is not None:
            self.storage_capacity = storage_capacity
        if compute_capacity is not None:
            self.compute_capacity = compute_capacity
        if resource_entities is not None:
            self.resource_entities = resource_entities
        if available_networks is not None:
            self.available_networks = available_networks
        if capabilities is not None:
            self.capabilities = capabilities
        if nic_quota is not None:
            self.nic_quota = nic_quota
        if network_quota is not None:
            self.network_quota = network_quota
        if used_network_count is not None:
            self.used_network_count = used_network_count
        if vm_quota is not None:
            self.vm_quota = vm_quota
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if vdc_storage_profiles is not None:
            self.vdc_storage_profiles = vdc_storage_profiles
        if default_compute_policy is not None:
            self.default_compute_policy = default_compute_policy
        if max_compute_policy is not None:
            self.max_compute_policy = max_compute_policy
        if v_cpu_in_mhz2 is not None:
            self.v_cpu_in_mhz2 = v_cpu_in_mhz2
        if status is not None:
            self.status = status
        if is_legacy_type is not None:
            self.is_legacy_type = is_legacy_type

    @property
    def compute_provider_scope(self):
        return self._compute_provider_scope
    
    @compute_provider_scope.setter
    def compute_provider_scope(self, compute_provider_scope):
        self._compute_provider_scope = compute_provider_scope

    @property
    def network_provider_scope(self):
        return self._network_provider_scope
    
    @network_provider_scope.setter
    def network_provider_scope(self, network_provider_scope):
        self._network_provider_scope = network_provider_scope

    @property
    def allocation_model(self):
        return self._allocation_model
    
    @allocation_model.setter
    def allocation_model(self, allocation_model):
        self._allocation_model = allocation_model

    @property
    def storage_capacity(self):
        return self._storage_capacity
    
    @storage_capacity.setter
    def storage_capacity(self, storage_capacity):
        self._storage_capacity = storage_capacity

    @property
    def compute_capacity(self):
        return self._compute_capacity
    
    @compute_capacity.setter
    def compute_capacity(self, compute_capacity):
        self._compute_capacity = compute_capacity

    @property
    def resource_entities(self):
        return self._resource_entities
    
    @resource_entities.setter
    def resource_entities(self, resource_entities):
        self._resource_entities = resource_entities

    @property
    def available_networks(self):
        return self._available_networks
    
    @available_networks.setter
    def available_networks(self, available_networks):
        self._available_networks = available_networks

    @property
    def capabilities(self):
        return self._capabilities
    
    @capabilities.setter
    def capabilities(self, capabilities):
        self._capabilities = capabilities

    @property
    def nic_quota(self):
        return self._nic_quota
    
    @nic_quota.setter
    def nic_quota(self, nic_quota):
        self._nic_quota = nic_quota

    @property
    def network_quota(self):
        return self._network_quota
    
    @network_quota.setter
    def network_quota(self, network_quota):
        self._network_quota = network_quota

    @property
    def used_network_count(self):
        return self._used_network_count
    
    @used_network_count.setter
    def used_network_count(self, used_network_count):
        self._used_network_count = used_network_count

    @property
    def vm_quota(self):
        return self._vm_quota
    
    @vm_quota.setter
    def vm_quota(self, vm_quota):
        self._vm_quota = vm_quota

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def vdc_storage_profiles(self):
        return self._vdc_storage_profiles
    
    @vdc_storage_profiles.setter
    def vdc_storage_profiles(self, vdc_storage_profiles):
        self._vdc_storage_profiles = vdc_storage_profiles

    @property
    def default_compute_policy(self):
        return self._default_compute_policy
    
    @default_compute_policy.setter
    def default_compute_policy(self, default_compute_policy):
        self._default_compute_policy = default_compute_policy

    @property
    def max_compute_policy(self):
        return self._max_compute_policy
    
    @max_compute_policy.setter
    def max_compute_policy(self, max_compute_policy):
        self._max_compute_policy = max_compute_policy

    @property
    def v_cpu_in_mhz2(self):
        return self._v_cpu_in_mhz2
    
    @v_cpu_in_mhz2.setter
    def v_cpu_in_mhz2(self, v_cpu_in_mhz2):
        self._v_cpu_in_mhz2 = v_cpu_in_mhz2

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def is_legacy_type(self):
        return self._is_legacy_type
    
    @is_legacy_type.setter
    def is_legacy_type(self, is_legacy_type):
        self._is_legacy_type = is_legacy_type


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VdcType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
