"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class VdcStorageProfileType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enabled': 'bool',
        'units': 'str',
        'limit': 'int',
        'default': 'bool',
        'iops_settings': 'VdcStorageProfileIopsSettingsType',
        'inherit_pvdc_default_settings': 'bool',
        'storage_used_mb': 'int',
        'iops_allocated': 'int'
    }

    attribute_map = {
        'enabled': 'enabled',
        'units': 'units',
        'limit': 'limit',
        'default': 'default',
        'iops_settings': 'iopsSettings',
        'inherit_pvdc_default_settings': 'inheritPvdcDefaultSettings',
        'storage_used_mb': 'storageUsedMB',
        'iops_allocated': 'iopsAllocated'
    }

    def __init__(self, enabled=None,units=None,limit=None,default=None,iops_settings=None,inherit_pvdc_default_settings=None,storage_used_mb=None,iops_allocated=None):
        self._enabled = None
        self._units = None
        self._limit = None
        self._default = None
        self._iops_settings = None
        self._inherit_pvdc_default_settings = None
        self._storage_used_mb = None
        self._iops_allocated = None

        if enabled is not None:
            self.enabled = enabled
        if units is not None:
            self.units = units
        if limit is not None:
            self.limit = limit
        if default is not None:
            self.default = default
        if iops_settings is not None:
            self.iops_settings = iops_settings
        if inherit_pvdc_default_settings is not None:
            self.inherit_pvdc_default_settings = inherit_pvdc_default_settings
        if storage_used_mb is not None:
            self.storage_used_mb = storage_used_mb
        if iops_allocated is not None:
            self.iops_allocated = iops_allocated

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def units(self):
        return self._units
    
    @units.setter
    def units(self, units):
        self._units = units

    @property
    def limit(self):
        return self._limit
    
    @limit.setter
    def limit(self, limit):
        self._limit = limit

    @property
    def default(self):
        return self._default
    
    @default.setter
    def default(self, default):
        self._default = default

    @property
    def iops_settings(self):
        return self._iops_settings
    
    @iops_settings.setter
    def iops_settings(self, iops_settings):
        self._iops_settings = iops_settings

    @property
    def inherit_pvdc_default_settings(self):
        return self._inherit_pvdc_default_settings
    
    @inherit_pvdc_default_settings.setter
    def inherit_pvdc_default_settings(self, inherit_pvdc_default_settings):
        self._inherit_pvdc_default_settings = inherit_pvdc_default_settings

    @property
    def storage_used_mb(self):
        return self._storage_used_mb
    
    @storage_used_mb.setter
    def storage_used_mb(self, storage_used_mb):
        self._storage_used_mb = storage_used_mb

    @property
    def iops_allocated(self):
        return self._iops_allocated
    
    @iops_allocated.setter
    def iops_allocated(self, iops_allocated):
        self._iops_allocated = iops_allocated


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VdcStorageProfileType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
