"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class VCloudType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'organization_references': 'OrganizationReferencesType',
        'provider_vdc_references': 'ProviderVdcReferencesType',
        'right_references': 'RightReferencesType',
        'role_references': 'RoleReferencesType',
        'networks': 'NetworksType'
    }

    attribute_map = {
        'organization_references': 'organizationReferences',
        'provider_vdc_references': 'providerVdcReferences',
        'right_references': 'rightReferences',
        'role_references': 'roleReferences',
        'networks': 'networks'
    }

    def __init__(self, organization_references=None,provider_vdc_references=None,right_references=None,role_references=None,networks=None):
        self._organization_references = None
        self._provider_vdc_references = None
        self._right_references = None
        self._role_references = None
        self._networks = None

        if organization_references is not None:
            self.organization_references = organization_references
        if provider_vdc_references is not None:
            self.provider_vdc_references = provider_vdc_references
        if right_references is not None:
            self.right_references = right_references
        if role_references is not None:
            self.role_references = role_references
        if networks is not None:
            self.networks = networks

    @property
    def organization_references(self):
        return self._organization_references
    
    @organization_references.setter
    def organization_references(self, organization_references):
        self._organization_references = organization_references

    @property
    def provider_vdc_references(self):
        return self._provider_vdc_references
    
    @provider_vdc_references.setter
    def provider_vdc_references(self, provider_vdc_references):
        self._provider_vdc_references = provider_vdc_references

    @property
    def right_references(self):
        return self._right_references
    
    @right_references.setter
    def right_references(self, right_references):
        self._right_references = right_references

    @property
    def role_references(self):
        return self._role_references
    
    @role_references.setter
    def role_references(self, role_references):
        self._role_references = role_references

    @property
    def networks(self):
        return self._networks
    
    @networks.setter
    def networks(self, networks):
        self._networks = networks


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VCloudType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
