"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .params_type import ParamsType


class VAppCreationParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'v_app_parent': 'ReferenceType',
        'instantiation_params': 'InstantiationParamsType',
        'deploy': 'bool',
        'power_on': 'bool'
    }

    attribute_map = {
        'v_app_parent': 'vAppParent',
        'instantiation_params': 'instantiationParams',
        'deploy': 'deploy',
        'power_on': 'powerOn'
    }

    def __init__(self, v_app_parent=None,instantiation_params=None,deploy=None,power_on=None):
        self._v_app_parent = None
        self._instantiation_params = None
        self._deploy = None
        self._power_on = None

        if v_app_parent is not None:
            self.v_app_parent = v_app_parent
        if instantiation_params is not None:
            self.instantiation_params = instantiation_params
        if deploy is not None:
            self.deploy = deploy
        if power_on is not None:
            self.power_on = power_on

    @property
    def v_app_parent(self):
        return self._v_app_parent
    
    @v_app_parent.setter
    def v_app_parent(self, v_app_parent):
        self._v_app_parent = v_app_parent

    @property
    def instantiation_params(self):
        return self._instantiation_params
    
    @instantiation_params.setter
    def instantiation_params(self, instantiation_params):
        self._instantiation_params = instantiation_params

    @property
    def deploy(self):
        return self._deploy
    
    @deploy.setter
    def deploy(self, deploy):
        self._deploy = deploy

    @property
    def power_on(self):
        return self._power_on
    
    @power_on.setter
    def power_on(self, power_on):
        self._power_on = power_on


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VAppCreationParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
