"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class ToCloudTunnelType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'traffic_type': 'str',
        'destination_id': 'str',
        'source_id': 'str'
    }

    attribute_map = {
        'traffic_type': 'trafficType',
        'destination_id': 'destinationId',
        'source_id': 'sourceId'
    }

    def __init__(self, traffic_type=None,destination_id=None,source_id=None):
        self._traffic_type = None
        self._destination_id = None
        self._source_id = None

        if traffic_type is not None:
            self.traffic_type = traffic_type
        if destination_id is not None:
            self.destination_id = destination_id
        if source_id is not None:
            self.source_id = source_id

    @property
    def traffic_type(self):
        return self._traffic_type
    
    @traffic_type.setter
    def traffic_type(self, traffic_type):
        self._traffic_type = traffic_type

    @property
    def destination_id(self):
        return self._destination_id
    
    @destination_id.setter
    def destination_id(self, destination_id):
        self._destination_id = destination_id

    @property
    def source_id(self):
        return self._source_id
    
    @source_id.setter
    def source_id(self, source_id):
        self._source_id = source_id


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ToCloudTunnelType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
