"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class TaskType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'owner': 'ReferenceType',
        'error': 'ErrorType',
        'user': 'ReferenceType',
        'organization': 'ReferenceType',
        'progress': 'int',
        'params': 'object',
        'details': 'str',
        'vc_task_list': 'VcTaskListType',
        'result': 'ResultType',
        'status': 'str',
        'operation': 'str',
        'operation_name': 'str',
        'service_namespace': 'str',
        'start_time': 'str',
        'end_time': 'str',
        'expiry_time': 'str',
        'cancel_requested': 'bool'
    }

    attribute_map = {
        'owner': 'owner',
        'error': 'error',
        'user': 'user',
        'organization': 'organization',
        'progress': 'progress',
        'params': 'params',
        'details': 'details',
        'vc_task_list': 'vcTaskList',
        'result': 'result',
        'status': 'status',
        'operation': 'operation',
        'operation_name': 'operationName',
        'service_namespace': 'serviceNamespace',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'expiry_time': 'expiryTime',
        'cancel_requested': 'cancelRequested'
    }

    def __init__(self, owner=None,error=None,user=None,organization=None,progress=None,params=None,details=None,vc_task_list=None,result=None,status=None,operation=None,operation_name=None,service_namespace=None,start_time=None,end_time=None,expiry_time=None,cancel_requested=None):
        self._owner = None
        self._error = None
        self._user = None
        self._organization = None
        self._progress = None
        self._params = None
        self._details = None
        self._vc_task_list = None
        self._result = None
        self._status = None
        self._operation = None
        self._operation_name = None
        self._service_namespace = None
        self._start_time = None
        self._end_time = None
        self._expiry_time = None
        self._cancel_requested = None

        if owner is not None:
            self.owner = owner
        if error is not None:
            self.error = error
        if user is not None:
            self.user = user
        if organization is not None:
            self.organization = organization
        if progress is not None:
            self.progress = progress
        if params is not None:
            self.params = params
        if details is not None:
            self.details = details
        if vc_task_list is not None:
            self.vc_task_list = vc_task_list
        if result is not None:
            self.result = result
        if status is not None:
            self.status = status
        if operation is not None:
            self.operation = operation
        if operation_name is not None:
            self.operation_name = operation_name
        if service_namespace is not None:
            self.service_namespace = service_namespace
        if start_time is not None:
            self.start_time = start_time
        if end_time is not None:
            self.end_time = end_time
        if expiry_time is not None:
            self.expiry_time = expiry_time
        if cancel_requested is not None:
            self.cancel_requested = cancel_requested

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def error(self):
        return self._error
    
    @error.setter
    def error(self, error):
        self._error = error

    @property
    def user(self):
        return self._user
    
    @user.setter
    def user(self, user):
        self._user = user

    @property
    def organization(self):
        return self._organization
    
    @organization.setter
    def organization(self, organization):
        self._organization = organization

    @property
    def progress(self):
        return self._progress
    
    @progress.setter
    def progress(self, progress):
        self._progress = progress

    @property
    def params(self):
        return self._params
    
    @params.setter
    def params(self, params):
        self._params = params

    @property
    def details(self):
        return self._details
    
    @details.setter
    def details(self, details):
        self._details = details

    @property
    def vc_task_list(self):
        return self._vc_task_list
    
    @vc_task_list.setter
    def vc_task_list(self, vc_task_list):
        self._vc_task_list = vc_task_list

    @property
    def result(self):
        return self._result
    
    @result.setter
    def result(self, result):
        self._result = result

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def operation(self):
        return self._operation
    
    @operation.setter
    def operation(self, operation):
        self._operation = operation

    @property
    def operation_name(self):
        return self._operation_name
    
    @operation_name.setter
    def operation_name(self, operation_name):
        self._operation_name = operation_name

    @property
    def service_namespace(self):
        return self._service_namespace
    
    @service_namespace.setter
    def service_namespace(self, service_namespace):
        self._service_namespace = service_namespace

    @property
    def start_time(self):
        return self._start_time
    
    @start_time.setter
    def start_time(self, start_time):
        self._start_time = start_time

    @property
    def end_time(self):
        return self._end_time
    
    @end_time.setter
    def end_time(self, end_time):
        self._end_time = end_time

    @property
    def expiry_time(self):
        return self._expiry_time
    
    @expiry_time.setter
    def expiry_time(self, expiry_time):
        self._expiry_time = expiry_time

    @property
    def cancel_requested(self):
        return self._cancel_requested
    
    @cancel_requested.setter
    def cancel_requested(self, cancel_requested):
        self._cancel_requested = cancel_requested


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
