"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .multisite_type import MultisiteType


class SiteType(MultisiteType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'multi_site_url': 'str',
        'site_associations': 'SiteAssociationsType'
    }

    attribute_map = {
        'multi_site_url': 'multiSiteUrl',
        'site_associations': 'siteAssociations'
    }

    def __init__(self, multi_site_url=None,site_associations=None):
        self._multi_site_url = None
        self._site_associations = None

        if multi_site_url is not None:
            self.multi_site_url = multi_site_url
        if site_associations is not None:
            self.site_associations = site_associations

    @property
    def multi_site_url(self):
        return self._multi_site_url
    
    @multi_site_url.setter
    def multi_site_url(self, multi_site_url):
        self._multi_site_url = multi_site_url

    @property
    def site_associations(self):
        return self._site_associations
    
    @site_associations.setter
    def site_associations(self, site_associations):
        self._site_associations = site_associations


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SiteType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
