"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class SessionType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'authorized_locations': 'AuthorizedLocationsType',
        'user': 'str',
        'org': 'str',
        'user_id': 'str',
        'roles': 'str',
        'location_id': 'str'
    }

    attribute_map = {
        'authorized_locations': 'authorizedLocations',
        'user': 'user',
        'org': 'org',
        'user_id': 'userId',
        'roles': 'roles',
        'location_id': 'locationId'
    }

    def __init__(self, authorized_locations=None,user=None,org=None,user_id=None,roles=None,location_id=None):
        self._authorized_locations = None
        self._user = None
        self._org = None
        self._user_id = None
        self._roles = None
        self._location_id = None

        if authorized_locations is not None:
            self.authorized_locations = authorized_locations
        if user is not None:
            self.user = user
        if org is not None:
            self.org = org
        if user_id is not None:
            self.user_id = user_id
        if roles is not None:
            self.roles = roles
        if location_id is not None:
            self.location_id = location_id

    @property
    def authorized_locations(self):
        return self._authorized_locations
    
    @authorized_locations.setter
    def authorized_locations(self, authorized_locations):
        self._authorized_locations = authorized_locations

    @property
    def user(self):
        return self._user
    
    @user.setter
    def user(self, user):
        self._user = user

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def user_id(self):
        return self._user_id
    
    @user_id.setter
    def user_id(self, user_id):
        self._user_id = user_id

    @property
    def roles(self):
        return self._roles
    
    @roles.setter
    def roles(self, roles):
        self._roles = roles

    @property
    def location_id(self):
        return self._location_id
    
    @location_id.setter
    def location_id(self, location_id):
        self._location_id = location_id


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SessionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
