"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class ReservationPoolVdcSummaryType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'memory_consumption_mb': 'int',
        'memory_reservation_mb': 'int',
        'storage_consumption_mb': 'int',
        'cpu_reservation_mhz': 'int',
        'cpu_consumption_mhz': 'int'
    }

    attribute_map = {
        'memory_consumption_mb': 'memoryConsumptionMB',
        'memory_reservation_mb': 'memoryReservationMB',
        'storage_consumption_mb': 'storageConsumptionMB',
        'cpu_reservation_mhz': 'cpuReservationMhz',
        'cpu_consumption_mhz': 'cpuConsumptionMhz'
    }

    def __init__(self, memory_consumption_mb=None,memory_reservation_mb=None,storage_consumption_mb=None,cpu_reservation_mhz=None,cpu_consumption_mhz=None):
        self._memory_consumption_mb = None
        self._memory_reservation_mb = None
        self._storage_consumption_mb = None
        self._cpu_reservation_mhz = None
        self._cpu_consumption_mhz = None

        if memory_consumption_mb is not None:
            self.memory_consumption_mb = memory_consumption_mb
        if memory_reservation_mb is not None:
            self.memory_reservation_mb = memory_reservation_mb
        if storage_consumption_mb is not None:
            self.storage_consumption_mb = storage_consumption_mb
        if cpu_reservation_mhz is not None:
            self.cpu_reservation_mhz = cpu_reservation_mhz
        if cpu_consumption_mhz is not None:
            self.cpu_consumption_mhz = cpu_consumption_mhz

    @property
    def memory_consumption_mb(self):
        return self._memory_consumption_mb
    
    @memory_consumption_mb.setter
    def memory_consumption_mb(self, memory_consumption_mb):
        self._memory_consumption_mb = memory_consumption_mb

    @property
    def memory_reservation_mb(self):
        return self._memory_reservation_mb
    
    @memory_reservation_mb.setter
    def memory_reservation_mb(self, memory_reservation_mb):
        self._memory_reservation_mb = memory_reservation_mb

    @property
    def storage_consumption_mb(self):
        return self._storage_consumption_mb
    
    @storage_consumption_mb.setter
    def storage_consumption_mb(self, storage_consumption_mb):
        self._storage_consumption_mb = storage_consumption_mb

    @property
    def cpu_reservation_mhz(self):
        return self._cpu_reservation_mhz
    
    @cpu_reservation_mhz.setter
    def cpu_reservation_mhz(self, cpu_reservation_mhz):
        self._cpu_reservation_mhz = cpu_reservation_mhz

    @property
    def cpu_consumption_mhz(self):
        return self._cpu_consumption_mhz
    
    @cpu_consumption_mhz.setter
    def cpu_consumption_mhz(self, cpu_consumption_mhz):
        self._cpu_consumption_mhz = cpu_consumption_mhz


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReservationPoolVdcSummaryType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
