"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultVAppOrgVdcNetworkRelationRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'entity_type': 'str',
        'name': 'str',
        'org': 'str',
        'org_vdc_network': 'str',
        'org_vdc_network_name': 'str',
        'status': 'str',
        'owner_name': 'str'
    }

    attribute_map = {
        'entity_type': 'entityType',
        'name': 'name',
        'org': 'org',
        'org_vdc_network': 'orgVdcNetwork',
        'org_vdc_network_name': 'orgVdcNetworkName',
        'status': 'status',
        'owner_name': 'ownerName'
    }

    def __init__(self, entity_type=None,name=None,org=None,org_vdc_network=None,org_vdc_network_name=None,status=None,owner_name=None):
        self._entity_type = None
        self._name = None
        self._org = None
        self._org_vdc_network = None
        self._org_vdc_network_name = None
        self._status = None
        self._owner_name = None

        if entity_type is not None:
            self.entity_type = entity_type
        if name is not None:
            self.name = name
        if org is not None:
            self.org = org
        if org_vdc_network is not None:
            self.org_vdc_network = org_vdc_network
        if org_vdc_network_name is not None:
            self.org_vdc_network_name = org_vdc_network_name
        if status is not None:
            self.status = status
        if owner_name is not None:
            self.owner_name = owner_name

    @property
    def entity_type(self):
        return self._entity_type
    
    @entity_type.setter
    def entity_type(self, entity_type):
        self._entity_type = entity_type

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def org_vdc_network(self):
        return self._org_vdc_network
    
    @org_vdc_network.setter
    def org_vdc_network(self, org_vdc_network):
        self._org_vdc_network = org_vdc_network

    @property
    def org_vdc_network_name(self):
        return self._org_vdc_network_name
    
    @org_vdc_network_name.setter
    def org_vdc_network_name(self, org_vdc_network_name):
        self._org_vdc_network_name = org_vdc_network_name

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultVAppOrgVdcNetworkRelationRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
