"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultUserRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'full_name': 'str',
        'is_enabled': 'bool',
        'number_of_deployed_v_ms': 'int',
        'deployed_vm_quota': 'int',
        'number_of_stored_v_ms': 'int',
        'stored_vm_quota': 'int',
        'is_ldap_user': 'bool',
        'is_external': 'bool',
        'identity_provider_type': 'str',
        'is_locked': 'bool',
        'role_names': 'str'
    }

    attribute_map = {
        'name': 'name',
        'full_name': 'fullName',
        'is_enabled': 'isEnabled',
        'number_of_deployed_v_ms': 'numberOfDeployedVMs',
        'deployed_vm_quota': 'deployedVMQuota',
        'number_of_stored_v_ms': 'numberOfStoredVMs',
        'stored_vm_quota': 'storedVMQuota',
        'is_ldap_user': 'isLdapUser',
        'is_external': 'isExternal',
        'identity_provider_type': 'identityProviderType',
        'is_locked': 'isLocked',
        'role_names': 'roleNames'
    }

    def __init__(self, name=None,full_name=None,is_enabled=None,number_of_deployed_v_ms=None,deployed_vm_quota=None,number_of_stored_v_ms=None,stored_vm_quota=None,is_ldap_user=None,is_external=None,identity_provider_type=None,is_locked=None,role_names=None):
        self._name = None
        self._full_name = None
        self._is_enabled = None
        self._number_of_deployed_v_ms = None
        self._deployed_vm_quota = None
        self._number_of_stored_v_ms = None
        self._stored_vm_quota = None
        self._is_ldap_user = None
        self._is_external = None
        self._identity_provider_type = None
        self._is_locked = None
        self._role_names = None

        if name is not None:
            self.name = name
        if full_name is not None:
            self.full_name = full_name
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if number_of_deployed_v_ms is not None:
            self.number_of_deployed_v_ms = number_of_deployed_v_ms
        if deployed_vm_quota is not None:
            self.deployed_vm_quota = deployed_vm_quota
        if number_of_stored_v_ms is not None:
            self.number_of_stored_v_ms = number_of_stored_v_ms
        if stored_vm_quota is not None:
            self.stored_vm_quota = stored_vm_quota
        if is_ldap_user is not None:
            self.is_ldap_user = is_ldap_user
        if is_external is not None:
            self.is_external = is_external
        if identity_provider_type is not None:
            self.identity_provider_type = identity_provider_type
        if is_locked is not None:
            self.is_locked = is_locked
        if role_names is not None:
            self.role_names = role_names

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def full_name(self):
        return self._full_name
    
    @full_name.setter
    def full_name(self, full_name):
        self._full_name = full_name

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def number_of_deployed_v_ms(self):
        return self._number_of_deployed_v_ms
    
    @number_of_deployed_v_ms.setter
    def number_of_deployed_v_ms(self, number_of_deployed_v_ms):
        self._number_of_deployed_v_ms = number_of_deployed_v_ms

    @property
    def deployed_vm_quota(self):
        return self._deployed_vm_quota
    
    @deployed_vm_quota.setter
    def deployed_vm_quota(self, deployed_vm_quota):
        self._deployed_vm_quota = deployed_vm_quota

    @property
    def number_of_stored_v_ms(self):
        return self._number_of_stored_v_ms
    
    @number_of_stored_v_ms.setter
    def number_of_stored_v_ms(self, number_of_stored_v_ms):
        self._number_of_stored_v_ms = number_of_stored_v_ms

    @property
    def stored_vm_quota(self):
        return self._stored_vm_quota
    
    @stored_vm_quota.setter
    def stored_vm_quota(self, stored_vm_quota):
        self._stored_vm_quota = stored_vm_quota

    @property
    def is_ldap_user(self):
        return self._is_ldap_user
    
    @is_ldap_user.setter
    def is_ldap_user(self, is_ldap_user):
        self._is_ldap_user = is_ldap_user

    @property
    def is_external(self):
        return self._is_external
    
    @is_external.setter
    def is_external(self, is_external):
        self._is_external = is_external

    @property
    def identity_provider_type(self):
        return self._identity_provider_type
    
    @identity_provider_type.setter
    def identity_provider_type(self, identity_provider_type):
        self._identity_provider_type = identity_provider_type

    @property
    def is_locked(self):
        return self._is_locked
    
    @is_locked.setter
    def is_locked(self, is_locked):
        self._is_locked = is_locked

    @property
    def role_names(self):
        return self._role_names
    
    @role_names.setter
    def role_names(self, role_names):
        self._role_names = role_names


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultUserRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
