"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultStorageProfileRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'number_of_provider_vdcs': 'int',
        'number_of_org_vdcs': 'int',
        'number_of_datastores': 'int',
        'requested_mb': 'int',
        'total_mb': 'int',
        'used_mb': 'int',
        'provisioned_mb': 'int',
        'capabilities': 'str',
        'number_of_capabilities': 'int'
    }

    attribute_map = {
        'name': 'name',
        'number_of_provider_vdcs': 'numberOfProviderVdcs',
        'number_of_org_vdcs': 'numberOfOrgVdcs',
        'number_of_datastores': 'numberOfDatastores',
        'requested_mb': 'requestedMb',
        'total_mb': 'totalMb',
        'used_mb': 'usedMb',
        'provisioned_mb': 'provisionedMb',
        'capabilities': 'capabilities',
        'number_of_capabilities': 'numberOfCapabilities'
    }

    def __init__(self, name=None,number_of_provider_vdcs=None,number_of_org_vdcs=None,number_of_datastores=None,requested_mb=None,total_mb=None,used_mb=None,provisioned_mb=None,capabilities=None,number_of_capabilities=None):
        self._name = None
        self._number_of_provider_vdcs = None
        self._number_of_org_vdcs = None
        self._number_of_datastores = None
        self._requested_mb = None
        self._total_mb = None
        self._used_mb = None
        self._provisioned_mb = None
        self._capabilities = None
        self._number_of_capabilities = None

        if name is not None:
            self.name = name
        if number_of_provider_vdcs is not None:
            self.number_of_provider_vdcs = number_of_provider_vdcs
        if number_of_org_vdcs is not None:
            self.number_of_org_vdcs = number_of_org_vdcs
        if number_of_datastores is not None:
            self.number_of_datastores = number_of_datastores
        if requested_mb is not None:
            self.requested_mb = requested_mb
        if total_mb is not None:
            self.total_mb = total_mb
        if used_mb is not None:
            self.used_mb = used_mb
        if provisioned_mb is not None:
            self.provisioned_mb = provisioned_mb
        if capabilities is not None:
            self.capabilities = capabilities
        if number_of_capabilities is not None:
            self.number_of_capabilities = number_of_capabilities

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def number_of_provider_vdcs(self):
        return self._number_of_provider_vdcs
    
    @number_of_provider_vdcs.setter
    def number_of_provider_vdcs(self, number_of_provider_vdcs):
        self._number_of_provider_vdcs = number_of_provider_vdcs

    @property
    def number_of_org_vdcs(self):
        return self._number_of_org_vdcs
    
    @number_of_org_vdcs.setter
    def number_of_org_vdcs(self, number_of_org_vdcs):
        self._number_of_org_vdcs = number_of_org_vdcs

    @property
    def number_of_datastores(self):
        return self._number_of_datastores
    
    @number_of_datastores.setter
    def number_of_datastores(self, number_of_datastores):
        self._number_of_datastores = number_of_datastores

    @property
    def requested_mb(self):
        return self._requested_mb
    
    @requested_mb.setter
    def requested_mb(self, requested_mb):
        self._requested_mb = requested_mb

    @property
    def total_mb(self):
        return self._total_mb
    
    @total_mb.setter
    def total_mb(self, total_mb):
        self._total_mb = total_mb

    @property
    def used_mb(self):
        return self._used_mb
    
    @used_mb.setter
    def used_mb(self, used_mb):
        self._used_mb = used_mb

    @property
    def provisioned_mb(self):
        return self._provisioned_mb
    
    @provisioned_mb.setter
    def provisioned_mb(self, provisioned_mb):
        self._provisioned_mb = provisioned_mb

    @property
    def capabilities(self):
        return self._capabilities
    
    @capabilities.setter
    def capabilities(self, capabilities):
        self._capabilities = capabilities

    @property
    def number_of_capabilities(self):
        return self._number_of_capabilities
    
    @number_of_capabilities.setter
    def number_of_capabilities(self, number_of_capabilities):
        self._number_of_capabilities = number_of_capabilities


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultStorageProfileRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
