"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultSiteAssociationRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'associated_site_name': 'str',
        'associated_site_id': 'str',
        'rest_endpoint': 'str',
        'base_ui_endpoint': 'str',
        'status': 'str'
    }

    attribute_map = {
        'associated_site_name': 'associatedSiteName',
        'associated_site_id': 'associatedSiteId',
        'rest_endpoint': 'restEndpoint',
        'base_ui_endpoint': 'baseUiEndpoint',
        'status': 'status'
    }

    def __init__(self, associated_site_name=None,associated_site_id=None,rest_endpoint=None,base_ui_endpoint=None,status=None):
        self._associated_site_name = None
        self._associated_site_id = None
        self._rest_endpoint = None
        self._base_ui_endpoint = None
        self._status = None

        if associated_site_name is not None:
            self.associated_site_name = associated_site_name
        if associated_site_id is not None:
            self.associated_site_id = associated_site_id
        if rest_endpoint is not None:
            self.rest_endpoint = rest_endpoint
        if base_ui_endpoint is not None:
            self.base_ui_endpoint = base_ui_endpoint
        if status is not None:
            self.status = status

    @property
    def associated_site_name(self):
        return self._associated_site_name
    
    @associated_site_name.setter
    def associated_site_name(self, associated_site_name):
        self._associated_site_name = associated_site_name

    @property
    def associated_site_id(self):
        return self._associated_site_id
    
    @associated_site_id.setter
    def associated_site_id(self, associated_site_id):
        self._associated_site_id = associated_site_id

    @property
    def rest_endpoint(self):
        return self._rest_endpoint
    
    @rest_endpoint.setter
    def rest_endpoint(self, rest_endpoint):
        self._rest_endpoint = rest_endpoint

    @property
    def base_ui_endpoint(self):
        return self._base_ui_endpoint
    
    @base_ui_endpoint.setter
    def base_ui_endpoint(self, base_ui_endpoint):
        self._base_ui_endpoint = base_ui_endpoint

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultSiteAssociationRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
