"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultResourceClassRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'service': 'str',
        'mime_type': 'str',
        'url_template': 'str',
        'nid': 'str',
        'urn_pattern': 'str'
    }

    attribute_map = {
        'name': 'name',
        'service': 'service',
        'mime_type': 'mimeType',
        'url_template': 'urlTemplate',
        'nid': 'nid',
        'urn_pattern': 'urnPattern'
    }

    def __init__(self, name=None,service=None,mime_type=None,url_template=None,nid=None,urn_pattern=None):
        self._name = None
        self._service = None
        self._mime_type = None
        self._url_template = None
        self._nid = None
        self._urn_pattern = None

        if name is not None:
            self.name = name
        if service is not None:
            self.service = service
        if mime_type is not None:
            self.mime_type = mime_type
        if url_template is not None:
            self.url_template = url_template
        if nid is not None:
            self.nid = nid
        if urn_pattern is not None:
            self.urn_pattern = urn_pattern

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def service(self):
        return self._service
    
    @service.setter
    def service(self, service):
        self._service = service

    @property
    def mime_type(self):
        return self._mime_type
    
    @mime_type.setter
    def mime_type(self, mime_type):
        self._mime_type = mime_type

    @property
    def url_template(self):
        return self._url_template
    
    @url_template.setter
    def url_template(self, url_template):
        self._url_template = url_template

    @property
    def nid(self):
        return self._nid
    
    @nid.setter
    def nid(self, nid):
        self._nid = nid

    @property
    def urn_pattern(self):
        return self._urn_pattern
    
    @urn_pattern.setter
    def urn_pattern(self, urn_pattern):
        self._urn_pattern = urn_pattern


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultResourceClassRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
