"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultResourceClassActionRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'http_method': 'str',
        'url_pattern': 'str',
        'resource_class': 'str'
    }

    attribute_map = {
        'name': 'name',
        'http_method': 'httpMethod',
        'url_pattern': 'urlPattern',
        'resource_class': 'resourceClass'
    }

    def __init__(self, name=None,http_method=None,url_pattern=None,resource_class=None):
        self._name = None
        self._http_method = None
        self._url_pattern = None
        self._resource_class = None

        if name is not None:
            self.name = name
        if http_method is not None:
            self.http_method = http_method
        if url_pattern is not None:
            self.url_pattern = url_pattern
        if resource_class is not None:
            self.resource_class = resource_class

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def http_method(self):
        return self._http_method
    
    @http_method.setter
    def http_method(self, http_method):
        self._http_method = http_method

    @property
    def url_pattern(self):
        return self._url_pattern
    
    @url_pattern.setter
    def url_pattern(self, url_pattern):
        self._url_pattern = url_pattern

    @property
    def resource_class(self):
        return self._resource_class
    
    @resource_class.setter
    def resource_class(self, resource_class):
        self._resource_class = resource_class


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultResourceClassActionRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
