"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultProviderVdcResourcePoolRelationRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'resource_pool_moref': 'str',
        'cpu_reservation_limit_mhz': 'int',
        'cpu_reservation_allocation_mhz': 'int',
        'is_enabled': 'bool',
        'memory_reservation_limit_mb': 'int',
        'memory_reservation_allocation_mb': 'int',
        'is_primary': 'bool',
        'provider_vdc': 'str',
        'vc': 'str',
        'vc_name': 'str',
        'number_of_v_ms': 'int'
    }

    attribute_map = {
        'name': 'name',
        'resource_pool_moref': 'resourcePoolMoref',
        'cpu_reservation_limit_mhz': 'cpuReservationLimitMhz',
        'cpu_reservation_allocation_mhz': 'cpuReservationAllocationMhz',
        'is_enabled': 'isEnabled',
        'memory_reservation_limit_mb': 'memoryReservationLimitMB',
        'memory_reservation_allocation_mb': 'memoryReservationAllocationMB',
        'is_primary': 'isPrimary',
        'provider_vdc': 'providerVdc',
        'vc': 'vc',
        'vc_name': 'vcName',
        'number_of_v_ms': 'numberOfVMs'
    }

    def __init__(self, name=None,resource_pool_moref=None,cpu_reservation_limit_mhz=None,cpu_reservation_allocation_mhz=None,is_enabled=None,memory_reservation_limit_mb=None,memory_reservation_allocation_mb=None,is_primary=None,provider_vdc=None,vc=None,vc_name=None,number_of_v_ms=None):
        self._name = None
        self._resource_pool_moref = None
        self._cpu_reservation_limit_mhz = None
        self._cpu_reservation_allocation_mhz = None
        self._is_enabled = None
        self._memory_reservation_limit_mb = None
        self._memory_reservation_allocation_mb = None
        self._is_primary = None
        self._provider_vdc = None
        self._vc = None
        self._vc_name = None
        self._number_of_v_ms = None

        if name is not None:
            self.name = name
        if resource_pool_moref is not None:
            self.resource_pool_moref = resource_pool_moref
        if cpu_reservation_limit_mhz is not None:
            self.cpu_reservation_limit_mhz = cpu_reservation_limit_mhz
        if cpu_reservation_allocation_mhz is not None:
            self.cpu_reservation_allocation_mhz = cpu_reservation_allocation_mhz
        if is_enabled is not None:
            self.is_enabled = is_enabled
        if memory_reservation_limit_mb is not None:
            self.memory_reservation_limit_mb = memory_reservation_limit_mb
        if memory_reservation_allocation_mb is not None:
            self.memory_reservation_allocation_mb = memory_reservation_allocation_mb
        if is_primary is not None:
            self.is_primary = is_primary
        if provider_vdc is not None:
            self.provider_vdc = provider_vdc
        if vc is not None:
            self.vc = vc
        if vc_name is not None:
            self.vc_name = vc_name
        if number_of_v_ms is not None:
            self.number_of_v_ms = number_of_v_ms

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def resource_pool_moref(self):
        return self._resource_pool_moref
    
    @resource_pool_moref.setter
    def resource_pool_moref(self, resource_pool_moref):
        self._resource_pool_moref = resource_pool_moref

    @property
    def cpu_reservation_limit_mhz(self):
        return self._cpu_reservation_limit_mhz
    
    @cpu_reservation_limit_mhz.setter
    def cpu_reservation_limit_mhz(self, cpu_reservation_limit_mhz):
        self._cpu_reservation_limit_mhz = cpu_reservation_limit_mhz

    @property
    def cpu_reservation_allocation_mhz(self):
        return self._cpu_reservation_allocation_mhz
    
    @cpu_reservation_allocation_mhz.setter
    def cpu_reservation_allocation_mhz(self, cpu_reservation_allocation_mhz):
        self._cpu_reservation_allocation_mhz = cpu_reservation_allocation_mhz

    @property
    def is_enabled(self):
        return self._is_enabled
    
    @is_enabled.setter
    def is_enabled(self, is_enabled):
        self._is_enabled = is_enabled

    @property
    def memory_reservation_limit_mb(self):
        return self._memory_reservation_limit_mb
    
    @memory_reservation_limit_mb.setter
    def memory_reservation_limit_mb(self, memory_reservation_limit_mb):
        self._memory_reservation_limit_mb = memory_reservation_limit_mb

    @property
    def memory_reservation_allocation_mb(self):
        return self._memory_reservation_allocation_mb
    
    @memory_reservation_allocation_mb.setter
    def memory_reservation_allocation_mb(self, memory_reservation_allocation_mb):
        self._memory_reservation_allocation_mb = memory_reservation_allocation_mb

    @property
    def is_primary(self):
        return self._is_primary
    
    @is_primary.setter
    def is_primary(self, is_primary):
        self._is_primary = is_primary

    @property
    def provider_vdc(self):
        return self._provider_vdc
    
    @provider_vdc.setter
    def provider_vdc(self, provider_vdc):
        self._provider_vdc = provider_vdc

    @property
    def vc(self):
        return self._vc
    
    @vc.setter
    def vc(self, vc):
        self._vc = vc

    @property
    def vc_name(self):
        return self._vc_name
    
    @vc_name.setter
    def vc_name(self, vc_name):
        self._vc_name = vc_name

    @property
    def number_of_v_ms(self):
        return self._number_of_v_ms
    
    @number_of_v_ms.setter
    def number_of_v_ms(self, number_of_v_ms):
        self._number_of_v_ms = number_of_v_ms


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultProviderVdcResourcePoolRelationRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
