"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultMediaRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'owner_name': 'str',
        'catalog_name': 'str',
        'is_published': 'bool',
        'name': 'str',
        'vdc': 'str',
        'vdc_name': 'str',
        'org': 'str',
        'creation_date': 'str',
        'is_busy': 'bool',
        'storage_b': 'int',
        'owner': 'str',
        'catalog': 'str',
        'catalog_item': 'str',
        'status': 'str',
        'storage_profile_name': 'str',
        'version': 'int',
        'last_successful_sync': 'str'
    }

    attribute_map = {
        'owner_name': 'ownerName',
        'catalog_name': 'catalogName',
        'is_published': 'isPublished',
        'name': 'name',
        'vdc': 'vdc',
        'vdc_name': 'vdcName',
        'org': 'org',
        'creation_date': 'creationDate',
        'is_busy': 'isBusy',
        'storage_b': 'storageB',
        'owner': 'owner',
        'catalog': 'catalog',
        'catalog_item': 'catalogItem',
        'status': 'status',
        'storage_profile_name': 'storageProfileName',
        'version': 'version',
        'last_successful_sync': 'lastSuccessfulSync'
    }

    def __init__(self, owner_name=None,catalog_name=None,is_published=None,name=None,vdc=None,vdc_name=None,org=None,creation_date=None,is_busy=None,storage_b=None,owner=None,catalog=None,catalog_item=None,status=None,storage_profile_name=None,version=None,last_successful_sync=None):
        self._owner_name = None
        self._catalog_name = None
        self._is_published = None
        self._name = None
        self._vdc = None
        self._vdc_name = None
        self._org = None
        self._creation_date = None
        self._is_busy = None
        self._storage_b = None
        self._owner = None
        self._catalog = None
        self._catalog_item = None
        self._status = None
        self._storage_profile_name = None
        self._version = None
        self._last_successful_sync = None

        if owner_name is not None:
            self.owner_name = owner_name
        if catalog_name is not None:
            self.catalog_name = catalog_name
        if is_published is not None:
            self.is_published = is_published
        if name is not None:
            self.name = name
        if vdc is not None:
            self.vdc = vdc
        if vdc_name is not None:
            self.vdc_name = vdc_name
        if org is not None:
            self.org = org
        if creation_date is not None:
            self.creation_date = creation_date
        if is_busy is not None:
            self.is_busy = is_busy
        if storage_b is not None:
            self.storage_b = storage_b
        if owner is not None:
            self.owner = owner
        if catalog is not None:
            self.catalog = catalog
        if catalog_item is not None:
            self.catalog_item = catalog_item
        if status is not None:
            self.status = status
        if storage_profile_name is not None:
            self.storage_profile_name = storage_profile_name
        if version is not None:
            self.version = version
        if last_successful_sync is not None:
            self.last_successful_sync = last_successful_sync

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def catalog_name(self):
        return self._catalog_name
    
    @catalog_name.setter
    def catalog_name(self, catalog_name):
        self._catalog_name = catalog_name

    @property
    def is_published(self):
        return self._is_published
    
    @is_published.setter
    def is_published(self, is_published):
        self._is_published = is_published

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def vdc_name(self):
        return self._vdc_name
    
    @vdc_name.setter
    def vdc_name(self, vdc_name):
        self._vdc_name = vdc_name

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def creation_date(self):
        return self._creation_date
    
    @creation_date.setter
    def creation_date(self, creation_date):
        self._creation_date = creation_date

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def storage_b(self):
        return self._storage_b
    
    @storage_b.setter
    def storage_b(self, storage_b):
        self._storage_b = storage_b

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def catalog(self):
        return self._catalog
    
    @catalog.setter
    def catalog(self, catalog):
        self._catalog = catalog

    @property
    def catalog_item(self):
        return self._catalog_item
    
    @catalog_item.setter
    def catalog_item(self, catalog_item):
        self._catalog_item = catalog_item

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def storage_profile_name(self):
        return self._storage_profile_name
    
    @storage_profile_name.setter
    def storage_profile_name(self, storage_profile_name):
        self._storage_profile_name = storage_profile_name

    @property
    def version(self):
        return self._version
    
    @version.setter
    def version(self, version):
        self._version = version

    @property
    def last_successful_sync(self):
        return self._last_successful_sync
    
    @last_successful_sync.setter
    def last_successful_sync(self, last_successful_sync):
        self._last_successful_sync = last_successful_sync


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultMediaRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
