"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultGatewayUplinksRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ip_address': 'str',
        'gateway_id': 'str',
        'network_name': 'str',
        'category': 'str'
    }

    attribute_map = {
        'ip_address': 'ipAddress',
        'gateway_id': 'gatewayId',
        'network_name': 'networkName',
        'category': 'category'
    }

    def __init__(self, ip_address=None,gateway_id=None,network_name=None,category=None):
        self._ip_address = None
        self._gateway_id = None
        self._network_name = None
        self._category = None

        if ip_address is not None:
            self.ip_address = ip_address
        if gateway_id is not None:
            self.gateway_id = gateway_id
        if network_name is not None:
            self.network_name = network_name
        if category is not None:
            self.category = category

    @property
    def ip_address(self):
        return self._ip_address
    
    @ip_address.setter
    def ip_address(self, ip_address):
        self._ip_address = ip_address

    @property
    def gateway_id(self):
        return self._gateway_id
    
    @gateway_id.setter
    def gateway_id(self, gateway_id):
        self._gateway_id = gateway_id

    @property
    def network_name(self):
        return self._network_name
    
    @network_name.setter
    def network_name(self, network_name):
        self._network_name = network_name

    @property
    def category(self):
        return self._category
    
    @category.setter
    def category(self, category):
        self._category = category


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultGatewayUplinksRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
