"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultEdgeGatewayRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'vdc': 'str',
        'number_of_ext_networks': 'int',
        'number_of_org_networks': 'int',
        'is_busy': 'bool',
        'edge_gateway_type': 'str',
        'org_vdc_name': 'str',
        'org_name': 'str',
        'available_net_count': 'int',
        'gateway_status': 'str',
        'ha_status': 'str',
        'advanced_networking_enabled': 'bool',
        'distributed_routing_enabled': 'bool',
        'egress_point_id': 'str',
        'vdc_group_id': 'str',
        'vdc_group_name': 'str'
    }

    attribute_map = {
        'name': 'name',
        'vdc': 'vdc',
        'number_of_ext_networks': 'numberOfExtNetworks',
        'number_of_org_networks': 'numberOfOrgNetworks',
        'is_busy': 'isBusy',
        'edge_gateway_type': 'edgeGatewayType',
        'org_vdc_name': 'orgVdcName',
        'org_name': 'orgName',
        'available_net_count': 'availableNetCount',
        'gateway_status': 'gatewayStatus',
        'ha_status': 'haStatus',
        'advanced_networking_enabled': 'advancedNetworkingEnabled',
        'distributed_routing_enabled': 'distributedRoutingEnabled',
        'egress_point_id': 'egressPointId',
        'vdc_group_id': 'vdcGroupId',
        'vdc_group_name': 'vdcGroupName'
    }

    def __init__(self, name=None,vdc=None,number_of_ext_networks=None,number_of_org_networks=None,is_busy=None,edge_gateway_type=None,org_vdc_name=None,org_name=None,available_net_count=None,gateway_status=None,ha_status=None,advanced_networking_enabled=None,distributed_routing_enabled=None,egress_point_id=None,vdc_group_id=None,vdc_group_name=None):
        self._name = None
        self._vdc = None
        self._number_of_ext_networks = None
        self._number_of_org_networks = None
        self._is_busy = None
        self._edge_gateway_type = None
        self._org_vdc_name = None
        self._org_name = None
        self._available_net_count = None
        self._gateway_status = None
        self._ha_status = None
        self._advanced_networking_enabled = None
        self._distributed_routing_enabled = None
        self._egress_point_id = None
        self._vdc_group_id = None
        self._vdc_group_name = None

        if name is not None:
            self.name = name
        if vdc is not None:
            self.vdc = vdc
        if number_of_ext_networks is not None:
            self.number_of_ext_networks = number_of_ext_networks
        if number_of_org_networks is not None:
            self.number_of_org_networks = number_of_org_networks
        if is_busy is not None:
            self.is_busy = is_busy
        if edge_gateway_type is not None:
            self.edge_gateway_type = edge_gateway_type
        if org_vdc_name is not None:
            self.org_vdc_name = org_vdc_name
        if org_name is not None:
            self.org_name = org_name
        if available_net_count is not None:
            self.available_net_count = available_net_count
        if gateway_status is not None:
            self.gateway_status = gateway_status
        if ha_status is not None:
            self.ha_status = ha_status
        if advanced_networking_enabled is not None:
            self.advanced_networking_enabled = advanced_networking_enabled
        if distributed_routing_enabled is not None:
            self.distributed_routing_enabled = distributed_routing_enabled
        if egress_point_id is not None:
            self.egress_point_id = egress_point_id
        if vdc_group_id is not None:
            self.vdc_group_id = vdc_group_id
        if vdc_group_name is not None:
            self.vdc_group_name = vdc_group_name

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def number_of_ext_networks(self):
        return self._number_of_ext_networks
    
    @number_of_ext_networks.setter
    def number_of_ext_networks(self, number_of_ext_networks):
        self._number_of_ext_networks = number_of_ext_networks

    @property
    def number_of_org_networks(self):
        return self._number_of_org_networks
    
    @number_of_org_networks.setter
    def number_of_org_networks(self, number_of_org_networks):
        self._number_of_org_networks = number_of_org_networks

    @property
    def is_busy(self):
        return self._is_busy
    
    @is_busy.setter
    def is_busy(self, is_busy):
        self._is_busy = is_busy

    @property
    def edge_gateway_type(self):
        return self._edge_gateway_type
    
    @edge_gateway_type.setter
    def edge_gateway_type(self, edge_gateway_type):
        self._edge_gateway_type = edge_gateway_type

    @property
    def org_vdc_name(self):
        return self._org_vdc_name
    
    @org_vdc_name.setter
    def org_vdc_name(self, org_vdc_name):
        self._org_vdc_name = org_vdc_name

    @property
    def org_name(self):
        return self._org_name
    
    @org_name.setter
    def org_name(self, org_name):
        self._org_name = org_name

    @property
    def available_net_count(self):
        return self._available_net_count
    
    @available_net_count.setter
    def available_net_count(self, available_net_count):
        self._available_net_count = available_net_count

    @property
    def gateway_status(self):
        return self._gateway_status
    
    @gateway_status.setter
    def gateway_status(self, gateway_status):
        self._gateway_status = gateway_status

    @property
    def ha_status(self):
        return self._ha_status
    
    @ha_status.setter
    def ha_status(self, ha_status):
        self._ha_status = ha_status

    @property
    def advanced_networking_enabled(self):
        return self._advanced_networking_enabled
    
    @advanced_networking_enabled.setter
    def advanced_networking_enabled(self, advanced_networking_enabled):
        self._advanced_networking_enabled = advanced_networking_enabled

    @property
    def distributed_routing_enabled(self):
        return self._distributed_routing_enabled
    
    @distributed_routing_enabled.setter
    def distributed_routing_enabled(self, distributed_routing_enabled):
        self._distributed_routing_enabled = distributed_routing_enabled

    @property
    def egress_point_id(self):
        return self._egress_point_id
    
    @egress_point_id.setter
    def egress_point_id(self, egress_point_id):
        self._egress_point_id = egress_point_id

    @property
    def vdc_group_id(self):
        return self._vdc_group_id
    
    @vdc_group_id.setter
    def vdc_group_id(self, vdc_group_id):
        self._vdc_group_id = vdc_group_id

    @property
    def vdc_group_name(self):
        return self._vdc_group_name
    
    @vdc_group_name.setter
    def vdc_group_name(self, vdc_group_name):
        self._vdc_group_name = vdc_group_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultEdgeGatewayRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
