"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultBlockingTaskRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'str',
        'operation_name': 'str',
        'owner': 'str',
        'owner_name': 'str',
        'originating_org_name': 'str',
        'originating_org': 'str',
        'creation_date': 'str',
        'expiration_time': 'str',
        'timeout_action': 'str',
        'task': 'str',
        'description': 'str',
        'job_status': 'str',
        'has_owner': 'bool'
    }

    attribute_map = {
        'status': 'status',
        'operation_name': 'operationName',
        'owner': 'owner',
        'owner_name': 'ownerName',
        'originating_org_name': 'originatingOrgName',
        'originating_org': 'originatingOrg',
        'creation_date': 'creationDate',
        'expiration_time': 'expirationTime',
        'timeout_action': 'timeoutAction',
        'task': 'task',
        'description': 'description',
        'job_status': 'jobStatus',
        'has_owner': 'hasOwner'
    }

    def __init__(self, status=None,operation_name=None,owner=None,owner_name=None,originating_org_name=None,originating_org=None,creation_date=None,expiration_time=None,timeout_action=None,task=None,description=None,job_status=None,has_owner=None):
        self._status = None
        self._operation_name = None
        self._owner = None
        self._owner_name = None
        self._originating_org_name = None
        self._originating_org = None
        self._creation_date = None
        self._expiration_time = None
        self._timeout_action = None
        self._task = None
        self._description = None
        self._job_status = None
        self._has_owner = None

        if status is not None:
            self.status = status
        if operation_name is not None:
            self.operation_name = operation_name
        if owner is not None:
            self.owner = owner
        if owner_name is not None:
            self.owner_name = owner_name
        if originating_org_name is not None:
            self.originating_org_name = originating_org_name
        if originating_org is not None:
            self.originating_org = originating_org
        if creation_date is not None:
            self.creation_date = creation_date
        if expiration_time is not None:
            self.expiration_time = expiration_time
        if timeout_action is not None:
            self.timeout_action = timeout_action
        if task is not None:
            self.task = task
        if description is not None:
            self.description = description
        if job_status is not None:
            self.job_status = job_status
        if has_owner is not None:
            self.has_owner = has_owner

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status

    @property
    def operation_name(self):
        return self._operation_name
    
    @operation_name.setter
    def operation_name(self, operation_name):
        self._operation_name = operation_name

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def owner_name(self):
        return self._owner_name
    
    @owner_name.setter
    def owner_name(self, owner_name):
        self._owner_name = owner_name

    @property
    def originating_org_name(self):
        return self._originating_org_name
    
    @originating_org_name.setter
    def originating_org_name(self, originating_org_name):
        self._originating_org_name = originating_org_name

    @property
    def originating_org(self):
        return self._originating_org
    
    @originating_org.setter
    def originating_org(self, originating_org):
        self._originating_org = originating_org

    @property
    def creation_date(self):
        return self._creation_date
    
    @creation_date.setter
    def creation_date(self, creation_date):
        self._creation_date = creation_date

    @property
    def expiration_time(self):
        return self._expiration_time
    
    @expiration_time.setter
    def expiration_time(self, expiration_time):
        self._expiration_time = expiration_time

    @property
    def timeout_action(self):
        return self._timeout_action
    
    @timeout_action.setter
    def timeout_action(self, timeout_action):
        self._timeout_action = timeout_action

    @property
    def task(self):
        return self._task
    
    @task.setter
    def task(self, task):
        self._task = task

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def job_status(self):
        return self._job_status
    
    @job_status.setter
    def job_status(self, job_status):
        self._job_status = job_status

    @property
    def has_owner(self):
        return self._has_owner
    
    @has_owner.setter
    def has_owner(self, has_owner):
        self._has_owner = has_owner


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultBlockingTaskRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
