"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminEventRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'event_id': 'str',
        'event_type': 'str',
        'time_stamp': 'str',
        'event_status': 'int',
        'user_name': 'str',
        'org_name': 'str',
        'entity_type': 'str',
        'entity_name': 'str',
        'description': 'str',
        'details': 'str',
        'service_namespace': 'str',
        'product_version': 'str',
        'entity': 'str',
        'org': 'str'
    }

    attribute_map = {
        'event_id': 'eventId',
        'event_type': 'eventType',
        'time_stamp': 'timeStamp',
        'event_status': 'eventStatus',
        'user_name': 'userName',
        'org_name': 'orgName',
        'entity_type': 'entityType',
        'entity_name': 'entityName',
        'description': 'description',
        'details': 'details',
        'service_namespace': 'serviceNamespace',
        'product_version': 'productVersion',
        'entity': 'entity',
        'org': 'org'
    }

    def __init__(self, event_id=None,event_type=None,time_stamp=None,event_status=None,user_name=None,org_name=None,entity_type=None,entity_name=None,description=None,details=None,service_namespace=None,product_version=None,entity=None,org=None):
        self._event_id = None
        self._event_type = None
        self._time_stamp = None
        self._event_status = None
        self._user_name = None
        self._org_name = None
        self._entity_type = None
        self._entity_name = None
        self._description = None
        self._details = None
        self._service_namespace = None
        self._product_version = None
        self._entity = None
        self._org = None

        if event_id is not None:
            self.event_id = event_id
        if event_type is not None:
            self.event_type = event_type
        if time_stamp is not None:
            self.time_stamp = time_stamp
        if event_status is not None:
            self.event_status = event_status
        if user_name is not None:
            self.user_name = user_name
        if org_name is not None:
            self.org_name = org_name
        if entity_type is not None:
            self.entity_type = entity_type
        if entity_name is not None:
            self.entity_name = entity_name
        if description is not None:
            self.description = description
        if details is not None:
            self.details = details
        if service_namespace is not None:
            self.service_namespace = service_namespace
        if product_version is not None:
            self.product_version = product_version
        if entity is not None:
            self.entity = entity
        if org is not None:
            self.org = org

    @property
    def event_id(self):
        return self._event_id
    
    @event_id.setter
    def event_id(self, event_id):
        self._event_id = event_id

    @property
    def event_type(self):
        return self._event_type
    
    @event_type.setter
    def event_type(self, event_type):
        self._event_type = event_type

    @property
    def time_stamp(self):
        return self._time_stamp
    
    @time_stamp.setter
    def time_stamp(self, time_stamp):
        self._time_stamp = time_stamp

    @property
    def event_status(self):
        return self._event_status
    
    @event_status.setter
    def event_status(self, event_status):
        self._event_status = event_status

    @property
    def user_name(self):
        return self._user_name
    
    @user_name.setter
    def user_name(self, user_name):
        self._user_name = user_name

    @property
    def org_name(self):
        return self._org_name
    
    @org_name.setter
    def org_name(self, org_name):
        self._org_name = org_name

    @property
    def entity_type(self):
        return self._entity_type
    
    @entity_type.setter
    def entity_type(self, entity_type):
        self._entity_type = entity_type

    @property
    def entity_name(self):
        return self._entity_name
    
    @entity_name.setter
    def entity_name(self, entity_name):
        self._entity_name = entity_name

    @property
    def description(self):
        return self._description
    
    @description.setter
    def description(self, description):
        self._description = description

    @property
    def details(self):
        return self._details
    
    @details.setter
    def details(self, details):
        self._details = details

    @property
    def service_namespace(self):
        return self._service_namespace
    
    @service_namespace.setter
    def service_namespace(self, service_namespace):
        self._service_namespace = service_namespace

    @property
    def product_version(self):
        return self._product_version
    
    @product_version.setter
    def product_version(self, product_version):
        self._product_version = product_version

    @property
    def entity(self):
        return self._entity
    
    @entity.setter
    def entity(self, entity):
        self._entity = entity

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminEventRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
