"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAdminApiDefinitionRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'entry_point': 'str',
        'service': 'str',
        'namespace': 'str',
        'api_vendor': 'str',
        'service_name': 'str',
        'service_namespace': 'str',
        'service_vendor': 'str'
    }

    attribute_map = {
        'name': 'name',
        'entry_point': 'entryPoint',
        'service': 'service',
        'namespace': 'namespace',
        'api_vendor': 'apiVendor',
        'service_name': 'serviceName',
        'service_namespace': 'serviceNamespace',
        'service_vendor': 'serviceVendor'
    }

    def __init__(self, name=None,entry_point=None,service=None,namespace=None,api_vendor=None,service_name=None,service_namespace=None,service_vendor=None):
        self._name = None
        self._entry_point = None
        self._service = None
        self._namespace = None
        self._api_vendor = None
        self._service_name = None
        self._service_namespace = None
        self._service_vendor = None

        if name is not None:
            self.name = name
        if entry_point is not None:
            self.entry_point = entry_point
        if service is not None:
            self.service = service
        if namespace is not None:
            self.namespace = namespace
        if api_vendor is not None:
            self.api_vendor = api_vendor
        if service_name is not None:
            self.service_name = service_name
        if service_namespace is not None:
            self.service_namespace = service_namespace
        if service_vendor is not None:
            self.service_vendor = service_vendor

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def entry_point(self):
        return self._entry_point
    
    @entry_point.setter
    def entry_point(self, entry_point):
        self._entry_point = entry_point

    @property
    def service(self):
        return self._service
    
    @service.setter
    def service(self, service):
        self._service = service

    @property
    def namespace(self):
        return self._namespace
    
    @namespace.setter
    def namespace(self, namespace):
        self._namespace = namespace

    @property
    def api_vendor(self):
        return self._api_vendor
    
    @api_vendor.setter
    def api_vendor(self, api_vendor):
        self._api_vendor = api_vendor

    @property
    def service_name(self):
        return self._service_name
    
    @service_name.setter
    def service_name(self, service_name):
        self._service_name = service_name

    @property
    def service_namespace(self):
        return self._service_namespace
    
    @service_namespace.setter
    def service_namespace(self, service_namespace):
        self._service_namespace = service_namespace

    @property
    def service_vendor(self):
        return self._service_vendor
    
    @service_vendor.setter
    def service_vendor(self, service_vendor):
        self._service_vendor = service_vendor


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAdminApiDefinitionRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
