"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .query_result_record_type import QueryResultRecordType


class QueryResultAclRuleRecordType(QueryResultRecordType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'org': 'str',
        'principal': 'str',
        'name': 'str',
        'service_resource': 'str',
        'principal_type': 'str',
        'resource_class_action': 'str',
        'org_access': 'str',
        'service_resource_access': 'str',
        'principal_access': 'str'
    }

    attribute_map = {
        'org': 'org',
        'principal': 'principal',
        'name': 'name',
        'service_resource': 'serviceResource',
        'principal_type': 'principalType',
        'resource_class_action': 'resourceClassAction',
        'org_access': 'orgAccess',
        'service_resource_access': 'serviceResourceAccess',
        'principal_access': 'principalAccess'
    }

    def __init__(self, org=None,principal=None,name=None,service_resource=None,principal_type=None,resource_class_action=None,org_access=None,service_resource_access=None,principal_access=None):
        self._org = None
        self._principal = None
        self._name = None
        self._service_resource = None
        self._principal_type = None
        self._resource_class_action = None
        self._org_access = None
        self._service_resource_access = None
        self._principal_access = None

        if org is not None:
            self.org = org
        if principal is not None:
            self.principal = principal
        if name is not None:
            self.name = name
        if service_resource is not None:
            self.service_resource = service_resource
        if principal_type is not None:
            self.principal_type = principal_type
        if resource_class_action is not None:
            self.resource_class_action = resource_class_action
        if org_access is not None:
            self.org_access = org_access
        if service_resource_access is not None:
            self.service_resource_access = service_resource_access
        if principal_access is not None:
            self.principal_access = principal_access

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def principal(self):
        return self._principal
    
    @principal.setter
    def principal(self, principal):
        self._principal = principal

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def service_resource(self):
        return self._service_resource
    
    @service_resource.setter
    def service_resource(self, service_resource):
        self._service_resource = service_resource

    @property
    def principal_type(self):
        return self._principal_type
    
    @principal_type.setter
    def principal_type(self, principal_type):
        self._principal_type = principal_type

    @property
    def resource_class_action(self):
        return self._resource_class_action
    
    @resource_class_action.setter
    def resource_class_action(self, resource_class_action):
        self._resource_class_action = resource_class_action

    @property
    def org_access(self):
        return self._org_access
    
    @org_access.setter
    def org_access(self, org_access):
        self._org_access = org_access

    @property
    def service_resource_access(self):
        return self._service_resource_access
    
    @service_resource_access.setter
    def service_resource_access(self, service_resource_access):
        self._service_resource_access = service_resource_access

    @property
    def principal_access(self):
        return self._principal_access
    
    @principal_access.setter
    def principal_access(self, principal_access):
        self._principal_access = principal_access


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QueryResultAclRuleRecordType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
