"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class PublishExternalCatalogParamsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_published_externally': 'bool',
        'catalog_published_url': 'str',
        'password': 'str',
        'is_cache_enabled': 'bool',
        'preserve_identity_info_flag': 'bool'
    }

    attribute_map = {
        'is_published_externally': 'isPublishedExternally',
        'catalog_published_url': 'catalogPublishedUrl',
        'password': 'password',
        'is_cache_enabled': 'isCacheEnabled',
        'preserve_identity_info_flag': 'preserveIdentityInfoFlag'
    }

    def __init__(self, is_published_externally=None,catalog_published_url=None,password=None,is_cache_enabled=None,preserve_identity_info_flag=None):
        self._is_published_externally = None
        self._catalog_published_url = None
        self._password = None
        self._is_cache_enabled = None
        self._preserve_identity_info_flag = None

        if is_published_externally is not None:
            self.is_published_externally = is_published_externally
        if catalog_published_url is not None:
            self.catalog_published_url = catalog_published_url
        if password is not None:
            self.password = password
        if is_cache_enabled is not None:
            self.is_cache_enabled = is_cache_enabled
        if preserve_identity_info_flag is not None:
            self.preserve_identity_info_flag = preserve_identity_info_flag

    @property
    def is_published_externally(self):
        return self._is_published_externally
    
    @is_published_externally.setter
    def is_published_externally(self, is_published_externally):
        self._is_published_externally = is_published_externally

    @property
    def catalog_published_url(self):
        return self._catalog_published_url
    
    @catalog_published_url.setter
    def catalog_published_url(self, catalog_published_url):
        self._catalog_published_url = catalog_published_url

    @property
    def password(self):
        return self._password
    
    @password.setter
    def password(self, password):
        self._password = password

    @property
    def is_cache_enabled(self):
        return self._is_cache_enabled
    
    @is_cache_enabled.setter
    def is_cache_enabled(self, is_cache_enabled):
        self._is_cache_enabled = is_cache_enabled

    @property
    def preserve_identity_info_flag(self):
        return self._preserve_identity_info_flag
    
    @preserve_identity_info_flag.setter
    def preserve_identity_info_flag(self, preserve_identity_info_flag):
        self._preserve_identity_info_flag = preserve_identity_info_flag


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PublishExternalCatalogParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
