"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .network_type import NetworkType


class OrgVdcNetworkType(NetworkType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'provider_info': 'str',
        'edge_gateway': 'ReferenceType',
        'service_config': 'GatewayFeaturesType',
        'is_shared': 'bool',
        'vim_port_group_ref': 'VimObjectRefType',
        'status': 'int'
    }

    attribute_map = {
        'provider_info': 'providerInfo',
        'edge_gateway': 'edgeGateway',
        'service_config': 'serviceConfig',
        'is_shared': 'isShared',
        'vim_port_group_ref': 'vimPortGroupRef',
        'status': 'status'
    }

    def __init__(self, provider_info=None,edge_gateway=None,service_config=None,is_shared=None,vim_port_group_ref=None,status=None):
        self._provider_info = None
        self._edge_gateway = None
        self._service_config = None
        self._is_shared = None
        self._vim_port_group_ref = None
        self._status = None

        if provider_info is not None:
            self.provider_info = provider_info
        if edge_gateway is not None:
            self.edge_gateway = edge_gateway
        if service_config is not None:
            self.service_config = service_config
        if is_shared is not None:
            self.is_shared = is_shared
        if vim_port_group_ref is not None:
            self.vim_port_group_ref = vim_port_group_ref
        if status is not None:
            self.status = status

    @property
    def provider_info(self):
        return self._provider_info
    
    @provider_info.setter
    def provider_info(self, provider_info):
        self._provider_info = provider_info

    @property
    def edge_gateway(self):
        return self._edge_gateway
    
    @edge_gateway.setter
    def edge_gateway(self, edge_gateway):
        self._edge_gateway = edge_gateway

    @property
    def service_config(self):
        return self._service_config
    
    @service_config.setter
    def service_config(self, service_config):
        self._service_config = service_config

    @property
    def is_shared(self):
        return self._is_shared
    
    @is_shared.setter
    def is_shared(self, is_shared):
        self._is_shared = is_shared

    @property
    def vim_port_group_ref(self):
        return self._vim_port_group_ref
    
    @vim_port_group_ref.setter
    def vim_port_group_ref(self, vim_port_group_ref):
        self._vim_port_group_ref = vim_port_group_ref

    @property
    def status(self):
        return self._status
    
    @status.setter
    def status(self, status):
        self._status = status


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgVdcNetworkType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
