"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OrgSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'org_general_settings': 'OrgGeneralSettingsType',
        'v_app_lease_settings': 'OrgLeaseSettingsType',
        'v_app_template_lease_settings': 'OrgVAppTemplateLeaseSettingsType',
        'org_ldap_settings': 'OrgLdapSettingsType',
        'org_email_settings': 'OrgEmailSettingsType',
        'org_password_policy_settings': 'OrgPasswordPolicySettingsType',
        'org_operation_limits_settings': 'OrgOperationLimitsSettingsType',
        'org_federation_settings': 'OrgFederationSettingsType',
        'org_o_auth_settings': 'OrgOAuthSettingsType'
    }

    attribute_map = {
        'org_general_settings': 'orgGeneralSettings',
        'v_app_lease_settings': 'vAppLeaseSettings',
        'v_app_template_lease_settings': 'vAppTemplateLeaseSettings',
        'org_ldap_settings': 'orgLdapSettings',
        'org_email_settings': 'orgEmailSettings',
        'org_password_policy_settings': 'orgPasswordPolicySettings',
        'org_operation_limits_settings': 'orgOperationLimitsSettings',
        'org_federation_settings': 'orgFederationSettings',
        'org_o_auth_settings': 'orgOAuthSettings'
    }

    def __init__(self, org_general_settings=None,v_app_lease_settings=None,v_app_template_lease_settings=None,org_ldap_settings=None,org_email_settings=None,org_password_policy_settings=None,org_operation_limits_settings=None,org_federation_settings=None,org_o_auth_settings=None):
        self._org_general_settings = None
        self._v_app_lease_settings = None
        self._v_app_template_lease_settings = None
        self._org_ldap_settings = None
        self._org_email_settings = None
        self._org_password_policy_settings = None
        self._org_operation_limits_settings = None
        self._org_federation_settings = None
        self._org_o_auth_settings = None

        if org_general_settings is not None:
            self.org_general_settings = org_general_settings
        if v_app_lease_settings is not None:
            self.v_app_lease_settings = v_app_lease_settings
        if v_app_template_lease_settings is not None:
            self.v_app_template_lease_settings = v_app_template_lease_settings
        if org_ldap_settings is not None:
            self.org_ldap_settings = org_ldap_settings
        if org_email_settings is not None:
            self.org_email_settings = org_email_settings
        if org_password_policy_settings is not None:
            self.org_password_policy_settings = org_password_policy_settings
        if org_operation_limits_settings is not None:
            self.org_operation_limits_settings = org_operation_limits_settings
        if org_federation_settings is not None:
            self.org_federation_settings = org_federation_settings
        if org_o_auth_settings is not None:
            self.org_o_auth_settings = org_o_auth_settings

    @property
    def org_general_settings(self):
        return self._org_general_settings
    
    @org_general_settings.setter
    def org_general_settings(self, org_general_settings):
        self._org_general_settings = org_general_settings

    @property
    def v_app_lease_settings(self):
        return self._v_app_lease_settings
    
    @v_app_lease_settings.setter
    def v_app_lease_settings(self, v_app_lease_settings):
        self._v_app_lease_settings = v_app_lease_settings

    @property
    def v_app_template_lease_settings(self):
        return self._v_app_template_lease_settings
    
    @v_app_template_lease_settings.setter
    def v_app_template_lease_settings(self, v_app_template_lease_settings):
        self._v_app_template_lease_settings = v_app_template_lease_settings

    @property
    def org_ldap_settings(self):
        return self._org_ldap_settings
    
    @org_ldap_settings.setter
    def org_ldap_settings(self, org_ldap_settings):
        self._org_ldap_settings = org_ldap_settings

    @property
    def org_email_settings(self):
        return self._org_email_settings
    
    @org_email_settings.setter
    def org_email_settings(self, org_email_settings):
        self._org_email_settings = org_email_settings

    @property
    def org_password_policy_settings(self):
        return self._org_password_policy_settings
    
    @org_password_policy_settings.setter
    def org_password_policy_settings(self, org_password_policy_settings):
        self._org_password_policy_settings = org_password_policy_settings

    @property
    def org_operation_limits_settings(self):
        return self._org_operation_limits_settings
    
    @org_operation_limits_settings.setter
    def org_operation_limits_settings(self, org_operation_limits_settings):
        self._org_operation_limits_settings = org_operation_limits_settings

    @property
    def org_federation_settings(self):
        return self._org_federation_settings
    
    @org_federation_settings.setter
    def org_federation_settings(self, org_federation_settings):
        self._org_federation_settings = org_federation_settings

    @property
    def org_o_auth_settings(self):
        return self._org_o_auth_settings
    
    @org_o_auth_settings.setter
    def org_o_auth_settings(self, org_o_auth_settings):
        self._org_o_auth_settings = org_o_auth_settings


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
