"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OrgLeaseSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'delete_on_storage_lease_expiration': 'bool',
        'deployment_lease_seconds': 'int',
        'storage_lease_seconds': 'int',
        'power_off_on_runtime_lease_expiration': 'bool'
    }

    attribute_map = {
        'delete_on_storage_lease_expiration': 'deleteOnStorageLeaseExpiration',
        'deployment_lease_seconds': 'deploymentLeaseSeconds',
        'storage_lease_seconds': 'storageLeaseSeconds',
        'power_off_on_runtime_lease_expiration': 'powerOffOnRuntimeLeaseExpiration'
    }

    def __init__(self, delete_on_storage_lease_expiration=None,deployment_lease_seconds=None,storage_lease_seconds=None,power_off_on_runtime_lease_expiration=None):
        self._delete_on_storage_lease_expiration = None
        self._deployment_lease_seconds = None
        self._storage_lease_seconds = None
        self._power_off_on_runtime_lease_expiration = None

        if delete_on_storage_lease_expiration is not None:
            self.delete_on_storage_lease_expiration = delete_on_storage_lease_expiration
        if deployment_lease_seconds is not None:
            self.deployment_lease_seconds = deployment_lease_seconds
        if storage_lease_seconds is not None:
            self.storage_lease_seconds = storage_lease_seconds
        if power_off_on_runtime_lease_expiration is not None:
            self.power_off_on_runtime_lease_expiration = power_off_on_runtime_lease_expiration

    @property
    def delete_on_storage_lease_expiration(self):
        return self._delete_on_storage_lease_expiration
    
    @delete_on_storage_lease_expiration.setter
    def delete_on_storage_lease_expiration(self, delete_on_storage_lease_expiration):
        self._delete_on_storage_lease_expiration = delete_on_storage_lease_expiration

    @property
    def deployment_lease_seconds(self):
        return self._deployment_lease_seconds
    
    @deployment_lease_seconds.setter
    def deployment_lease_seconds(self, deployment_lease_seconds):
        self._deployment_lease_seconds = deployment_lease_seconds

    @property
    def storage_lease_seconds(self):
        return self._storage_lease_seconds
    
    @storage_lease_seconds.setter
    def storage_lease_seconds(self, storage_lease_seconds):
        self._storage_lease_seconds = storage_lease_seconds

    @property
    def power_off_on_runtime_lease_expiration(self):
        return self._power_off_on_runtime_lease_expiration
    
    @power_off_on_runtime_lease_expiration.setter
    def power_off_on_runtime_lease_expiration(self, power_off_on_runtime_lease_expiration):
        self._power_off_on_runtime_lease_expiration = power_off_on_runtime_lease_expiration


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgLeaseSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
