"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class OrgLdapUserAttributesType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'object_class': 'str',
        'object_identifier': 'str',
        'user_name': 'str',
        'email': 'str',
        'full_name': 'str',
        'given_name': 'str',
        'surname': 'str',
        'telephone': 'str',
        'group_membership_identifier': 'str',
        'group_back_link_identifier': 'str'
    }

    attribute_map = {
        'object_class': 'objectClass',
        'object_identifier': 'objectIdentifier',
        'user_name': 'userName',
        'email': 'email',
        'full_name': 'fullName',
        'given_name': 'givenName',
        'surname': 'surname',
        'telephone': 'telephone',
        'group_membership_identifier': 'groupMembershipIdentifier',
        'group_back_link_identifier': 'groupBackLinkIdentifier'
    }

    def __init__(self, object_class=None,object_identifier=None,user_name=None,email=None,full_name=None,given_name=None,surname=None,telephone=None,group_membership_identifier=None,group_back_link_identifier=None):
        self._object_class = None
        self._object_identifier = None
        self._user_name = None
        self._email = None
        self._full_name = None
        self._given_name = None
        self._surname = None
        self._telephone = None
        self._group_membership_identifier = None
        self._group_back_link_identifier = None

        if object_class is not None:
            self.object_class = object_class
        if object_identifier is not None:
            self.object_identifier = object_identifier
        if user_name is not None:
            self.user_name = user_name
        if email is not None:
            self.email = email
        if full_name is not None:
            self.full_name = full_name
        if given_name is not None:
            self.given_name = given_name
        if surname is not None:
            self.surname = surname
        if telephone is not None:
            self.telephone = telephone
        if group_membership_identifier is not None:
            self.group_membership_identifier = group_membership_identifier
        if group_back_link_identifier is not None:
            self.group_back_link_identifier = group_back_link_identifier

    @property
    def object_class(self):
        return self._object_class
    
    @object_class.setter
    def object_class(self, object_class):
        self._object_class = object_class

    @property
    def object_identifier(self):
        return self._object_identifier
    
    @object_identifier.setter
    def object_identifier(self, object_identifier):
        self._object_identifier = object_identifier

    @property
    def user_name(self):
        return self._user_name
    
    @user_name.setter
    def user_name(self, user_name):
        self._user_name = user_name

    @property
    def email(self):
        return self._email
    
    @email.setter
    def email(self, email):
        self._email = email

    @property
    def full_name(self):
        return self._full_name
    
    @full_name.setter
    def full_name(self, full_name):
        self._full_name = full_name

    @property
    def given_name(self):
        return self._given_name
    
    @given_name.setter
    def given_name(self, given_name):
        self._given_name = given_name

    @property
    def surname(self):
        return self._surname
    
    @surname.setter
    def surname(self, surname):
        self._surname = surname

    @property
    def telephone(self):
        return self._telephone
    
    @telephone.setter
    def telephone(self, telephone):
        self._telephone = telephone

    @property
    def group_membership_identifier(self):
        return self._group_membership_identifier
    
    @group_membership_identifier.setter
    def group_membership_identifier(self, group_membership_identifier):
        self._group_membership_identifier = group_membership_identifier

    @property
    def group_back_link_identifier(self):
        return self._group_back_link_identifier
    
    @group_back_link_identifier.setter
    def group_back_link_identifier(self, group_back_link_identifier):
        self._group_back_link_identifier = group_back_link_identifier


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgLdapUserAttributesType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
