"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OrgGeneralSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'can_publish_catalogs': 'bool',
        'can_publish_externally': 'bool',
        'can_subscribe': 'bool',
        'deployed_vm_quota': 'int',
        'stored_vm_quota': 'int',
        'use_server_boot_sequence': 'bool',
        'delay_after_power_on_seconds': 'int',
        'vdc_quota': 'int',
        'vm_discovery_enabled': 'bool'
    }

    attribute_map = {
        'can_publish_catalogs': 'canPublishCatalogs',
        'can_publish_externally': 'canPublishExternally',
        'can_subscribe': 'canSubscribe',
        'deployed_vm_quota': 'deployedVMQuota',
        'stored_vm_quota': 'storedVmQuota',
        'use_server_boot_sequence': 'useServerBootSequence',
        'delay_after_power_on_seconds': 'delayAfterPowerOnSeconds',
        'vdc_quota': 'vdcQuota',
        'vm_discovery_enabled': 'vmDiscoveryEnabled'
    }

    def __init__(self, can_publish_catalogs=None,can_publish_externally=None,can_subscribe=None,deployed_vm_quota=None,stored_vm_quota=None,use_server_boot_sequence=None,delay_after_power_on_seconds=None,vdc_quota=None,vm_discovery_enabled=None):
        self._can_publish_catalogs = None
        self._can_publish_externally = None
        self._can_subscribe = None
        self._deployed_vm_quota = None
        self._stored_vm_quota = None
        self._use_server_boot_sequence = None
        self._delay_after_power_on_seconds = None
        self._vdc_quota = None
        self._vm_discovery_enabled = None

        if can_publish_catalogs is not None:
            self.can_publish_catalogs = can_publish_catalogs
        if can_publish_externally is not None:
            self.can_publish_externally = can_publish_externally
        if can_subscribe is not None:
            self.can_subscribe = can_subscribe
        if deployed_vm_quota is not None:
            self.deployed_vm_quota = deployed_vm_quota
        if stored_vm_quota is not None:
            self.stored_vm_quota = stored_vm_quota
        if use_server_boot_sequence is not None:
            self.use_server_boot_sequence = use_server_boot_sequence
        if delay_after_power_on_seconds is not None:
            self.delay_after_power_on_seconds = delay_after_power_on_seconds
        if vdc_quota is not None:
            self.vdc_quota = vdc_quota
        if vm_discovery_enabled is not None:
            self.vm_discovery_enabled = vm_discovery_enabled

    @property
    def can_publish_catalogs(self):
        return self._can_publish_catalogs
    
    @can_publish_catalogs.setter
    def can_publish_catalogs(self, can_publish_catalogs):
        self._can_publish_catalogs = can_publish_catalogs

    @property
    def can_publish_externally(self):
        return self._can_publish_externally
    
    @can_publish_externally.setter
    def can_publish_externally(self, can_publish_externally):
        self._can_publish_externally = can_publish_externally

    @property
    def can_subscribe(self):
        return self._can_subscribe
    
    @can_subscribe.setter
    def can_subscribe(self, can_subscribe):
        self._can_subscribe = can_subscribe

    @property
    def deployed_vm_quota(self):
        return self._deployed_vm_quota
    
    @deployed_vm_quota.setter
    def deployed_vm_quota(self, deployed_vm_quota):
        self._deployed_vm_quota = deployed_vm_quota

    @property
    def stored_vm_quota(self):
        return self._stored_vm_quota
    
    @stored_vm_quota.setter
    def stored_vm_quota(self, stored_vm_quota):
        self._stored_vm_quota = stored_vm_quota

    @property
    def use_server_boot_sequence(self):
        return self._use_server_boot_sequence
    
    @use_server_boot_sequence.setter
    def use_server_boot_sequence(self, use_server_boot_sequence):
        self._use_server_boot_sequence = use_server_boot_sequence

    @property
    def delay_after_power_on_seconds(self):
        return self._delay_after_power_on_seconds
    
    @delay_after_power_on_seconds.setter
    def delay_after_power_on_seconds(self, delay_after_power_on_seconds):
        self._delay_after_power_on_seconds = delay_after_power_on_seconds

    @property
    def vdc_quota(self):
        return self._vdc_quota
    
    @vdc_quota.setter
    def vdc_quota(self, vdc_quota):
        self._vdc_quota = vdc_quota

    @property
    def vm_discovery_enabled(self):
        return self._vm_discovery_enabled
    
    @vm_discovery_enabled.setter
    def vm_discovery_enabled(self, vm_discovery_enabled):
        self._vm_discovery_enabled = vm_discovery_enabled


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgGeneralSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
