"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OrgEmailSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_default_smtp_server': 'bool',
        'is_default_org_email': 'bool',
        'from_email_address': 'str',
        'default_subject_prefix': 'str',
        'is_alert_email_to_all_admins': 'bool',
        'alert_email_to': 'list[str]',
        'smtp_server_settings': 'SmtpServerSettingsType'
    }

    attribute_map = {
        'is_default_smtp_server': 'isDefaultSmtpServer',
        'is_default_org_email': 'isDefaultOrgEmail',
        'from_email_address': 'fromEmailAddress',
        'default_subject_prefix': 'defaultSubjectPrefix',
        'is_alert_email_to_all_admins': 'isAlertEmailToAllAdmins',
        'alert_email_to': 'alertEmailTo',
        'smtp_server_settings': 'smtpServerSettings'
    }

    def __init__(self, is_default_smtp_server=None,is_default_org_email=None,from_email_address=None,default_subject_prefix=None,is_alert_email_to_all_admins=None,alert_email_to=None,smtp_server_settings=None):
        self._is_default_smtp_server = None
        self._is_default_org_email = None
        self._from_email_address = None
        self._default_subject_prefix = None
        self._is_alert_email_to_all_admins = None
        self._alert_email_to = None
        self._smtp_server_settings = None

        if is_default_smtp_server is not None:
            self.is_default_smtp_server = is_default_smtp_server
        if is_default_org_email is not None:
            self.is_default_org_email = is_default_org_email
        if from_email_address is not None:
            self.from_email_address = from_email_address
        if default_subject_prefix is not None:
            self.default_subject_prefix = default_subject_prefix
        if is_alert_email_to_all_admins is not None:
            self.is_alert_email_to_all_admins = is_alert_email_to_all_admins
        if alert_email_to is not None:
            self.alert_email_to = alert_email_to
        if smtp_server_settings is not None:
            self.smtp_server_settings = smtp_server_settings

    @property
    def is_default_smtp_server(self):
        return self._is_default_smtp_server
    
    @is_default_smtp_server.setter
    def is_default_smtp_server(self, is_default_smtp_server):
        self._is_default_smtp_server = is_default_smtp_server

    @property
    def is_default_org_email(self):
        return self._is_default_org_email
    
    @is_default_org_email.setter
    def is_default_org_email(self, is_default_org_email):
        self._is_default_org_email = is_default_org_email

    @property
    def from_email_address(self):
        return self._from_email_address
    
    @from_email_address.setter
    def from_email_address(self, from_email_address):
        self._from_email_address = from_email_address

    @property
    def default_subject_prefix(self):
        return self._default_subject_prefix
    
    @default_subject_prefix.setter
    def default_subject_prefix(self, default_subject_prefix):
        self._default_subject_prefix = default_subject_prefix

    @property
    def is_alert_email_to_all_admins(self):
        return self._is_alert_email_to_all_admins
    
    @is_alert_email_to_all_admins.setter
    def is_alert_email_to_all_admins(self, is_alert_email_to_all_admins):
        self._is_alert_email_to_all_admins = is_alert_email_to_all_admins

    @property
    def alert_email_to(self):
        return self._alert_email_to
    
    @alert_email_to.setter
    def alert_email_to(self, alert_email_to):
        self._alert_email_to = alert_email_to

    @property
    def smtp_server_settings(self):
        return self._smtp_server_settings
    
    @smtp_server_settings.setter
    def smtp_server_settings(self, smtp_server_settings):
        self._smtp_server_settings = smtp_server_settings


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrgEmailSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
