"""
 Copyright (c) 2021 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_type import ResourceType


class OIDCAttributeMappingType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'subject_attribute_name': 'str',
        'email_attribute_name': 'str',
        'full_name_attribute_name': 'str',
        'first_name_attribute_name': 'str',
        'last_name_attribute_name': 'str',
        'groups_attribute_name': 'str',
        'roles_attribute_name': 'str'
    }

    attribute_map = {
        'subject_attribute_name': 'subjectAttributeName',
        'email_attribute_name': 'emailAttributeName',
        'full_name_attribute_name': 'fullNameAttributeName',
        'first_name_attribute_name': 'firstNameAttributeName',
        'last_name_attribute_name': 'lastNameAttributeName',
        'groups_attribute_name': 'groupsAttributeName',
        'roles_attribute_name': 'rolesAttributeName'
    }

    def __init__(self, subject_attribute_name=None,email_attribute_name=None,full_name_attribute_name=None,first_name_attribute_name=None,last_name_attribute_name=None,groups_attribute_name=None,roles_attribute_name=None):
        self._subject_attribute_name = None
        self._email_attribute_name = None
        self._full_name_attribute_name = None
        self._first_name_attribute_name = None
        self._last_name_attribute_name = None
        self._groups_attribute_name = None
        self._roles_attribute_name = None

        if subject_attribute_name is not None:
            self.subject_attribute_name = subject_attribute_name
        if email_attribute_name is not None:
            self.email_attribute_name = email_attribute_name
        if full_name_attribute_name is not None:
            self.full_name_attribute_name = full_name_attribute_name
        if first_name_attribute_name is not None:
            self.first_name_attribute_name = first_name_attribute_name
        if last_name_attribute_name is not None:
            self.last_name_attribute_name = last_name_attribute_name
        if groups_attribute_name is not None:
            self.groups_attribute_name = groups_attribute_name
        if roles_attribute_name is not None:
            self.roles_attribute_name = roles_attribute_name

    @property
    def subject_attribute_name(self):
        return self._subject_attribute_name
    
    @subject_attribute_name.setter
    def subject_attribute_name(self, subject_attribute_name):
        self._subject_attribute_name = subject_attribute_name

    @property
    def email_attribute_name(self):
        return self._email_attribute_name
    
    @email_attribute_name.setter
    def email_attribute_name(self, email_attribute_name):
        self._email_attribute_name = email_attribute_name

    @property
    def full_name_attribute_name(self):
        return self._full_name_attribute_name
    
    @full_name_attribute_name.setter
    def full_name_attribute_name(self, full_name_attribute_name):
        self._full_name_attribute_name = full_name_attribute_name

    @property
    def first_name_attribute_name(self):
        return self._first_name_attribute_name
    
    @first_name_attribute_name.setter
    def first_name_attribute_name(self, first_name_attribute_name):
        self._first_name_attribute_name = first_name_attribute_name

    @property
    def last_name_attribute_name(self):
        return self._last_name_attribute_name
    
    @last_name_attribute_name.setter
    def last_name_attribute_name(self, last_name_attribute_name):
        self._last_name_attribute_name = last_name_attribute_name

    @property
    def groups_attribute_name(self):
        return self._groups_attribute_name
    
    @groups_attribute_name.setter
    def groups_attribute_name(self, groups_attribute_name):
        self._groups_attribute_name = groups_attribute_name

    @property
    def roles_attribute_name(self):
        return self._roles_attribute_name
    
    @roles_attribute_name.setter
    def roles_attribute_name(self, roles_attribute_name):
        self._roles_attribute_name = roles_attribute_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OIDCAttributeMappingType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
